//+------------------------------------------------------------------+
//| CoreWinTT ?????? ??? ??????? ? ?????! :)                           
//+------------------------------------------------------------------+

#property link      "CoreWinTT"
//---- indicator settings

#property indicator_separate_window
#property indicator_buffers 6
#property indicator_color1 MediumPurple
#property indicator_color2 Magenta
#property indicator_color3 Aqua
#property indicator_color4 Silver
#property indicator_color5 Red
#property indicator_color6 Black
//---- indicator parameters
//extern string Setup =  "Classic 12 26 9";
extern double ColdSintez=1;
extern int ElderEMA=13;
extern int FastEMA=5;
extern int SlowEMA=34;
extern int SignalEMA=5;
extern int OsmaX=2;
extern bool TwoColor=false;
extern bool ShowLines=true;
extern bool ShowOsma=true;
double Diff1,Diff2;
double  Zero_level=0.0;
double minuse;
double Vol;
//---- indicator buffers
double ind_buffer1[];
double ind_buffer2[];
double ind_buffer3[];
double ind_buffer4[];
double ind_buffer5[];
double ind_buffer6[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function |
//+------------------------------------------------------------------+
int init()
  {

//---- drawing settings
   if(ShowOsma)
     {
      SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,2);
      SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,2);
      SetIndexStyle(2,DRAW_HISTOGRAM,STYLE_SOLID,2);
      SetIndexStyle(3,DRAW_LINE,STYLE_SOLID,1);
     }
   else 
     {
      SetIndexStyle(0,DRAW_NONE);
      SetIndexStyle(1,DRAW_NONE);
      SetIndexStyle(2,DRAW_NONE);
      SetIndexStyle(3,DRAW_NONE);
     }

   if(ShowLines)
     {

      SetIndexStyle(4,DRAW_LINE,STYLE_SOLID,1);
      SetIndexStyle(5,DRAW_LINE,STYLE_SOLID,1);
     }
   else 
     {

      SetIndexStyle(4,DRAW_NONE);
      SetIndexStyle(5,DRAW_NONE);

     }

   SetIndexDrawBegin(1,"OsMA");
//---- indicator buffers mapping
   SetIndexBuffer(0,ind_buffer1);
   SetIndexBuffer(1,ind_buffer2);
   SetIndexBuffer(2,ind_buffer3);
   SetIndexBuffer(3,ind_buffer4);
   SetIndexBuffer(4,ind_buffer5);
   SetIndexBuffer(5,ind_buffer6);

//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("MA("+DoubleToStr(ElderEMA*ColdSintez,0)+")MACD("+DoubleToStr(FastEMA*ColdSintez,0)+","+DoubleToStr(SlowEMA*ColdSintez,0)+","+DoubleToStr(SignalEMA*ColdSintez,0)+")");
   SetIndexLabel(0,"osma");
   SetIndexLabel(1,NULL);
   SetIndexLabel(2,NULL);
   SetIndexLabel(3,NULL);
   SetIndexLabel(4,"macd");
   SetIndexLabel(5,NULL);
//---- initialization done


   return(0);
  }
//+------------------------------------------------------------------+
//| Moving Averages Convergence/Divergence |
//+------------------------------------------------------------------+
int start()
  {
   bool UseOneColor=false;
   int counted_bars = IndicatorCounted();
   if(counted_bars < 0)  return(-1);
   if(counted_bars > 0)   counted_bars--;
   int limit = Bars - counted_bars;
   if(counted_bars==0) limit--;

   for(int i=0; i<limit; i++)
      ind_buffer6[i]=iMA(NULL,0,FastEMA*ColdSintez,0,MODE_EMA,PRICE_CLOSE,i)-iMA(NULL,0,SlowEMA*ColdSintez,0,MODE_EMA,PRICE_CLOSE,i);

   for(i=0; i<limit; i++)
      ind_buffer5[i]=iMAOnArray(ind_buffer6,Bars,SignalEMA*ColdSintez,0,MODE_EMA,i);
   for(i=0; i<limit; i++)
      ind_buffer4[i]=(ind_buffer6[i]-ind_buffer5[i])*OsmaX;
   for(i=0; i<limit; i++)
      ind_buffer3[i]=ind_buffer4[i];
   for(i=0; i<limit; i++)
      ind_buffer2[i]=ind_buffer4[i];
   for(i=0; i<limit; i++)
      ind_buffer1[i]=ind_buffer4[i];
//---- done
//---- Three Colour MACD mapping 
   for(i=0; i<limit; i++)
     {   //for open
      if(UseOneColor)
        {
         ind_buffer3[i]=0.0;
         ind_buffer2[i]=0.0;
        }
      else 
        {

         if(ElderEMA==0) 
           {
            Diff1=ind_buffer6[i];
            Diff2=ind_buffer6[i+1];
           }
         else 
           {
            Diff1=iMA(NULL,0,ElderEMA*ColdSintez,0,MODE_EMA,PRICE_MEDIAN,i);
            Diff2=iMA(NULL,0,ElderEMA*ColdSintez,0,MODE_EMA,PRICE_MEDIAN,i+1);
           }

         if(Diff1>Diff2)
           {
            ind_buffer2[i]=Zero_level;

            Vol=ind_buffer1[i];     minuse=Vol-ind_buffer1[i+1];

            if(minuse>0.0){ind_buffer3[i]=Vol; ind_buffer2[i]=0.0; ind_buffer1[i]=0.0;}
            else 
              {
               if(minuse<0.0){ind_buffer3[i]=0.0; ind_buffer2[i]=0.0; ind_buffer1[i]=Vol;}
               else{ind_buffer3[i]=0.0; ind_buffer2[i]=0.0; ind_buffer1[i]=Vol;}
              }
           } //if Close
         else 
           {
            ind_buffer2[i]=Zero_level;

            Vol=ind_buffer1[i];     minuse=Vol-ind_buffer1[i+1];

            if(minuse>0.0){ind_buffer3[i]=0.0; ind_buffer2[i]=0.0; ind_buffer1[i]=Vol;}
            else 
              {
               if(minuse<0.0){ind_buffer3[i]=0.0; ind_buffer2[i]=Vol; ind_buffer1[i]=0.0;}
               else{ind_buffer4[i]=0.0; ind_buffer2[i]=0.0; ind_buffer1[i]=Vol;}
              }

           }
        }
     }//for Close

   if(TwoColor==true && UseOneColor==false)
     {
      for(i=limit; i>=0; i--)
        {
         ind_buffer1[i]=0;
         if(ind_buffer4[i]>=ind_buffer4[i+1]) {ind_buffer2[i]=0;ind_buffer3[i]=ind_buffer4[i];}//Magenta
         else {ind_buffer3[i]=0;ind_buffer2[i]=ind_buffer4[i];}//aqua
        }
     }

   int dt;
   if((Time[0]-Time[1])>(Time[1]-Time[2])) dt=(Time[1]-Time[2])/60;
   else dt=(Time[0]-Time[1])/60;
   GlobalVariableSet("BMACD4_"+dt+Symbol()+"ElderEMA",ElderEMA*ColdSintez);
   GlobalVariableSet("BMACD4_"+dt+Symbol()+"FastEMA",FastEMA*ColdSintez);
   GlobalVariableSet("BMACD4_"+dt+Symbol()+"SlowEMA",SlowEMA*ColdSintez);
   GlobalVariableSet("BMACD4_"+dt+Symbol()+"SignalEMA",SignalEMA*ColdSintez);
   GlobalVariableSet("BMACD4_"+dt+Symbol()+"TwoColor",TwoColor);



   return(0);
  } 
//+------------------------------------------------------------------+
