//+------------------------------------------------------------------+
//|                                   Copyright  2010, Ivan Kornilov|
//|                                                        Oracle.mq4|
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, Ivan Kornilov. All rights reserved."
#property link "excelf@gmail.com"
#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 Crimson
#property indicator_color2 Gray

double Sum[];
double MaBuffer[];

extern int period=55;
extern int maPeriod=8;
extern int shift=3;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorDigits(Digits+3);
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,Sum);

   SetIndexStyle(1,DRAW_LINE,STYLE_DOT);
   SetIndexBuffer(1,MaBuffer);

   SetIndexDrawBegin(1,period*3);

   IndicatorShortName("Oracle("+period+","+maPeriod+")");
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int deinit()
  {
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {
   SetIndexShift(0,shift);
   SetIndexShift(1,shift);
   
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   int limit=Bars-counted_bars;
   if(counted_bars==0) limit--;
      
   double div1;
   double div2;
   double div3;
   double div4;
   double max;
   double min;

   int i;
   for(i=limit -1; i>=0; i--) 
     {
      div1 = (iCCI(NULL,0,period,PRICE_CLOSE,i) - iRSI(NULL,0,period,PRICE_CLOSE,i));
      div2 = (iCCI(NULL,0,period,PRICE_CLOSE,i - 1) - iRSI(NULL,0,period,PRICE_CLOSE,i + 1)) - (iCCI(NULL,0,period,PRICE_CLOSE,i) - iRSI(NULL,0,period,PRICE_CLOSE, i));
      div3 = (iCCI(NULL,0,period,PRICE_CLOSE,i - 2) - iRSI(NULL,0,period,PRICE_CLOSE,i + 2)) - (iCCI(NULL,0,period,PRICE_CLOSE,i - 1) - iRSI(NULL,0,period,PRICE_CLOSE, i + 1));
      div4 = (iCCI(NULL,0,period,PRICE_CLOSE,i - period) - iRSI(NULL,0,period,PRICE_CLOSE,i + period)) - (iCCI(NULL,0,period,PRICE_CLOSE,i - (period - 1)) - iRSI(NULL,0,period,PRICE_CLOSE, i+(period - 1)));
      if(div1>div2 && div1>div3 && div1>div4)
         max=div1;
      if(div2>div1 && div2>div3 && div2>div4)
         max=div2;
      if(div3>div1 && div3>div2 && div3>div4)
         max=div3;
      if(div4>div1 && div4>div2 && div4>div3)
         max=div4;

      if(div1<div2 && div1<div3 && div1<div4)
         min=div1;
      if(div2<div1 && div2<div3 && div2<div4)
         min=div2;
      if(div3<div1 && div3<div2 && div3<div4)
         min=div3;
      if(div4<div1 && div4<div3 && div4<div3)
         min=div4;

      Sum[i]=max+min;
     }

   for(i=limit; i>=0; i--) 
     {
      MaBuffer[i]=iMAOnArray(Sum,0,maPeriod,0,MODE_EMA,i);
     }

   return(0);
  }
//+------------------------------------------------------------------+
