//+------------------------------------------------------------------+
//|                                                              |
//|                                                        |
//|                                           www.Zuzabush@yandex.ru |
//|                                                                  |
//|                                                                  |
//|                                                                  |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "  -"
#property link      "www.Zuzabush@yandex.ru"

//-------   ------------------------------------------
extern double Lots = 0.1;             //  
extern int  SE= 35;                   //      
extern bool   AllPositions   = False; //   
extern bool   ProfitTrailing = True;  //   
extern int    TrailingStop   = 10;    //   
extern int    TrailingStep   = 2;     //  
extern int    Otstup = 15;
extern bool   UseSound       = True;  //   
extern string NameFileSound  = "expert.wav";  //   
static datetime prevtime = 0;
double  OT;
double  VSL;
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
void start() {  
    if(OrdersTotal()<3) VSL=AccountBalance();

if(prevtime == Time[0]) return(0); 

if ((OrdersTotal()<2)||(OrdersTotal()<OT))
{OrderSend(Symbol(),OP_BUY,Lots,Ask,5,0,0,"",5,0);
OrderSend(Symbol(),OP_SELL,Lots,Bid,5,0,0,"",5,0);}
prevtime = Time[0]; OT= OrdersTotal(); 

 if(AccountEquity()>VSL+SE) CloseAll(); 
            
  for (int i=0; i<OrdersTotal(); i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (AllPositions || OrderSymbol()==Symbol()) {
        TrailingPositions();
      }
    }
  }
}

//+------------------------------------------------------------------+
//|       (  )              |
//+------------------------------------------------------------------+
void TrailingPositions() {
  double pBid, pAsk, pp;

  pp = MarketInfo(OrderSymbol(), MODE_POINT);
  if (OrderType()==OP_BUY) {
    pBid = MarketInfo(OrderSymbol(), MODE_BID);
    if (!ProfitTrailing || (pBid-OrderOpenPrice())>TrailingStop*pp+Otstup*Point) {
      if (OrderStopLoss()<pBid-((TrailingStop+Otstup*Point)+TrailingStep-1)*pp) {
        ModifyStopLoss(pBid-TrailingStop*pp);
        return;
      }
    }
  }
  if (OrderType()==OP_SELL) {
    pAsk = MarketInfo(OrderSymbol(), MODE_ASK);
    if (!ProfitTrailing || OrderOpenPrice()-pAsk>TrailingStop*pp+Otstup*Point) {
      if (OrderStopLoss()>pAsk+((TrailingStop+Otstup*Point)+TrailingStep-1)*pp || OrderStopLoss()==0) {
        ModifyStopLoss(pAsk+TrailingStop*pp);
        return;
      }
    }
  }
}

//+------------------------------------------------------------------+
//|   StopLoss                                          |
//|                                                                  |
//|                                                |
//+------------------------------------------------------------------+
void ModifyStopLoss(double ldStopLoss) {
  bool fm;

  fm=OrderModify(OrderTicket(),OrderOpenPrice(),ldStopLoss,OrderTakeProfit(),0,CLR_NONE);
  if (fm && UseSound) PlaySound(NameFileSound);
}

//+------------------------------------------------------------------+
//                                                 |
//+------------------------------------------------------------------+
void CloseAll()
{
 int ticket, i;
 while(OrdersTotal()>0) {
  for(i=OrdersTotal()-1;i>=0;i--){
   OrderSelect(i,SELECT_BY_POS,MODE_TRADES);
    if(OrderType()<2){
     if(OrderType()==OP_BUY) {
        RefreshRates();
        ticket=OrderClose(OrderTicket(),OrderLots(),Bid,3,Green);
        if(!ticket) Print(" ! ",GetLastError()); 
        Sleep(1000); }
     if(OrderType()==OP_SELL) {
        RefreshRates();
        ticket=OrderClose(OrderTicket(),OrderLots(),Ask,3,Green);
        if(!ticket) Print(" ! ",GetLastError()); 
        Sleep(1000); }
    }    
  }
 }   
}

