//***********************************************************************//
//***********************************************************************//
//*                                            MA Rounding Off_FULL.mq4 *//
//*                                         Copyright  2009, BACKSPACE *//
//*                                              Updating from 10.01.10 *//
//***********************************************************************//
//***********************************************************************//
//*                                                         *//
//*                                                       *//
//*                                                    *//
//*                                                      *//
//***********************************************************************//
//***********************************************************************//
#property copyright "Copyright  2009, BACKSPACE"                        //
#property link      "Updating from 10.01.10"                             //
                                                                         //
#property indicator_chart_window                                         //
#property indicator_buffers 1                                            //
#property indicator_color1 DarkViolet                                    //
                                                     //******************//   
extern int    MaPeriod=8;                                                //   -  Moving Average
extern double MaRound=13;                                                //   -   
                                                     //******************//   
double MovingRound[],                                                    //   - Moving Rounding Off
       MovAve[],                                                         //   - Moving Average
       MovAle[];                                                         //   -  Moving
                                                     //******************//  
int    Counter,                                                          //   -  
       MaPer;                                                            //   -  Moving Average
double MaRo;                                                             //   -  
                                                                         //
//***********************************************************************//
//**********************-Indicator Initialization-***********************//
//***********************************************************************//
                                                                         //
int init()                                                               //
  {                                                  //******************//   
   IndicatorBuffers(3);                                                  //
   SetIndexLabel(0,"MovingRound");                                       //
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,2);                             //
   SetIndexBuffer(0,MovingRound);                                        //
   SetIndexBuffer(1,MovAve);                                             //
   SetIndexBuffer(2,MovAle);                                             //
                                                                         //
   if(MaPeriod>=1 && MaPeriod<=720)                  //******************//   
     MaPer=MaPeriod;                                                     //
   else                                                                  //
     MaPer=21;                                                           //
   if(MaRound>=0 && MaRound<=720)                    //******************//   
     MaRo = Point*MaRound;                                               //
   else                                                                  //
     MaRo = Point*72;                                                    //
                                                              //*********//
   return(0);                                                            //
  }                                                                      //
//***********************************************************************//
//*************************-Moving Rounding Off-*************************//
//***********************************************************************//
                                                                         //
int start()                                                              //
  {                                                                      //
   if(MaPer>Bars||MaRo>Bars)                         //******************//   
     {                                                                   //
      Alert("    .");           //
      return(0);                                                         //
     }                       
     
   int counted_bars = IndicatorCounted();
   if(counted_bars < 0)  return(-1);
   if(counted_bars > 0)   counted_bars--;
   int limit = Bars - counted_bars;
   if(counted_bars==0) limit-=2;
   
   for(int mr=limit; mr>=1; mr--)                               //
     {                                                                   //
      Moving_Average(mr);                            //******************// Moving Average
      Rounding_Off(mr);                              //******************// Rounding Off
     }                                                                   //
                                                              //*********//
   return(0);                                                            //
  }                                                                      //
//***********************************************************************//
//******************************-SubPogramms-****************************//
//***********************************************************************//
                                                                         //
                                    //***********************************// Moving Average
double Moving_Average(int ma)                                            //
  {                                                                      //
   MovAve[ma]=iMA(NULL,0,MaPer,0,MODE_SMMA,PRICE_CLOSE,ma);              //
                                                              //*********//
   return(0);                                                            //
  }                                                                      //
                                    //***********************************// Rounding Off
double Rounding_Off(int ro)                                              //
  {                                                                      //
      if(MovAve[ro]>MovAve[ro+1]+MaRo ||                                 //
         MovAve[ro]<MovAve[ro+1]-MaRo ||                                 //
         MovAve[ro]>MovingRound[ro+1]+MaRo ||                            //
         MovAve[ro]<MovingRound[ro+1]-MaRo ||                            //
        (MovAve[ro]>MovingRound[ro+1] && MovAle[ro+1]==1) ||             //
        (MovAve[ro]<MovingRound[ro+1] && MovAle[ro+1]==-1))              //
         MovingRound[ro] =MovAve[ro];                                    //
       else                                                              //
         MovingRound[ro]=MovingRound[ro+1];                              //
      if(MovingRound[ro]<MovingRound[ro+1]) MovAle[ro] =-1;              //
      if(MovingRound[ro]>MovingRound[ro+1]) MovAle[ro] =1;               //
      if(MovingRound[ro]==MovingRound[ro+1])MovAle[ro] =MovAle[ro+1];    //
                                                              //*********//
   return(0);                                                            //
  }                                                                      //
//***********************************************************************//
//********************************************************************BS*//
//***********************************************************************//