//+------------------------------------------------------------------+
//|                                                     SafeZone.mq4 |
//|                      Copyright  2009, MetaQuotes Software Corp. |
//|                                        http://www.mql4.ru        |
//+------------------------------------------------------------------+
#property link      "CoreWinTT"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Red
#property indicator_color2 Red
//---- input parameters
extern int       Median=10;
extern int       Max=15;
extern int       MASAFE=3;
//---- buffers
double BuffUP[];
double BuffDown[];

double massup[];
double massdown[];
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorBuffers(7);
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,BuffUP);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,BuffDown);

   SetIndexBuffer(2,massup);
   SetIndexBuffer(3,massdown);
   SetIndexBuffer(4,ExtMapBuffer1);
   SetIndexBuffer(5,ExtMapBuffer2);
   SetIndexBuffer(6,ExtMapBuffer3);


   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start() {
   int limit;
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
   if(counted_bars==0) limit-=1+Max;

   for (int i=limit; i>=0;i--)
      ExtMapBuffer1[i]=High[i]-Low[i];
   for (i=limit; i>=0;i--)
      ExtMapBuffer2[i]=iMAOnArray(ExtMapBuffer1,0,Median,0,MODE_SMA,i);
   
   
   for ( i=limit; i>=0;i--) {
      ExtMapBuffer3[i]=ExtMapBuffer2[i];
      for (int R=0; R<Max;R++)  
         if (ExtMapBuffer3[i]<ExtMapBuffer2[i+R]) 
            ExtMapBuffer3[i]=ExtMapBuffer2[i+R];
   }

   for ( i=limit; i>=0;i--) {
      massup[i]=High[i]+ExtMapBuffer3[i];
      massdown[i]=Low[i]-ExtMapBuffer3[i];
   }
   for (i=limit; i>=0;i--) {
      BuffUP[i]=iMAOnArray(massup,0,MASAFE,0,MODE_EMA,i);
      BuffDown[i]=iMAOnArray(massdown,0,MASAFE,0,MODE_EMA,i);
   }

   return(0);
}