//+------------------------------------------------------------------+
//|                                                   OtherChart.mq4 |
//|                      Copyright  2008, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "jax1000"
#property link  "http://www.onix-trade.net/forum/index.php?showtopic=107&view=findpost&p=383010"
#property indicator_chart_window
#property indicator_buffers 8
#property indicator_color1 MediumBlue
#property indicator_color2 LimeGreen
#property indicator_color3 Crimson
#property indicator_color4 SaddleBrown
#property indicator_color5 Yellow
#property indicator_color6 DeepPink
#property indicator_color7 BlueViolet
#property indicator_color8 Turquoise
extern bool all_idx_mode=true;//  -      ( true)     -        ( false).
extern int period=8;//   
extern int period1=8;// ""   
extern int period2=24;// ""   
extern int MA_Method=0;//      .  -  .
extern int Price=0;//       .  - .
extern int shift=0;//     .
extern int width=3;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
double Buffer1[],Buffer2[],Buffer3[],Buffer4[],Buffer5[],Buffer6[],Buffer7[],Buffer8[];
//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//    ,   .
   string s=Symbol();
   string k=StringSubstr(Symbol(), 3, 3);//  
   string b=StringSubstr(Symbol(), 0, 3);//  
   string buffer1_name;
   string buffer2_name;
   if(all_idx_mode==false){buffer1_name=b;buffer2_name=k;}else{buffer1_name="EUR";buffer2_name="USD";}
//     all_idx_mode
   color color1=clrNONE;
   color color2=clrNONE;;
   if(all_idx_mode==false)
     {
      if(b=="EUR") {color1=MediumBlue;}else
      if(b=="USD") {color1=LimeGreen;}else
      if(b=="GBP") {color1=Crimson;}else
      if(b=="CHF") {color1=SaddleBrown;}else
      if(b=="CAD") {color1=DeepPink;}else
      if(b=="AUD") {color1=BlueViolet;}else
      if(b=="NZD") {color1=Turquoise;}

      if(k=="JPY") {color2=Yellow;}else
      if(k=="USD") {color2=LimeGreen;}else
      if(k=="GBP") {color2=Crimson;}else
      if(k=="CHF") {color2=SaddleBrown;}else
      if(k=="CAD") {color2=DeepPink;}else
      if(k=="AUD") {color2=BlueViolet;}else
      if(k=="NZD") {color2=Turquoise;}
     }
   else
     {
      color1=MediumBlue;
      color2=LimeGreen;
     }
   IndicatorDigits(Digits);
   SetIndexStyle(0,DRAW_LINE,0,width,color1);
   SetIndexBuffer(0,Buffer1);
   SetIndexStyle(1,DRAW_LINE,0,width,color2);
   SetIndexBuffer(1,Buffer2);
   SetIndexStyle(2,DRAW_LINE,0,width);
   SetIndexBuffer(2,Buffer3);
   SetIndexStyle(3,DRAW_LINE,0,width);
   SetIndexBuffer(3,Buffer4);
   SetIndexStyle(4,DRAW_LINE,0,width);
   SetIndexBuffer(4,Buffer5);
   SetIndexStyle(5,DRAW_LINE,0,width);
   SetIndexBuffer(5,Buffer6);
   SetIndexStyle(6,DRAW_LINE,0,width);
   SetIndexBuffer(6,Buffer7);
   SetIndexStyle(7,DRAW_LINE,0,width);
   SetIndexBuffer(7,Buffer8);
   SetIndexLabel(0,buffer1_name);
   SetIndexLabel(1,buffer2_name);
   SetIndexLabel(2,"GBP");
   SetIndexLabel(3,"CHF");
   SetIndexLabel(4,"JPY");
   SetIndexLabel(5,"CAD");
   SetIndexLabel(6,"AUD");
   SetIndexLabel(7,"NZD");

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()

  {
   int    i;
   int limit;
   int counted_bars=IndicatorCounted();
   if(counted_bars>0) counted_bars--;
   int barsGBPUSD = iBars("GBPUSD",0);
   int barsUSDCHF = iBars("USDCHF",0);
   int barsUSDJPY = iBars("USDJPY",0);
   int barsUSDCAD = iBars("USDCAD",0);
   int barsEURUSD = iBars("EURUSD",0);
   int barsAUDUSD = iBars("AUDUSD",0);
   int barsNZDUSD = iBars("NZDUSD",0);
   
   int temp = MathMin(barsGBPUSD,MathMin(barsUSDCHF,MathMin(barsUSDJPY,MathMin(barsUSDCAD,MathMin(barsEURUSD,MathMin(barsAUDUSD,barsNZDUSD))))));
   if(temp>0) limit = temp-counted_bars;
   else
     {
      Print("Not enough history for used symbols.");
      return(0);
     }
   limit=Bars-counted_bars;
   if(counted_bars==0) limit-=(period2+1);

   for(i=0; i<limit; i++)
     {
      //   
      int shiftEUR = iBarShift("EURUSD", 0, Time[i]);
      int shiftGBP = iBarShift("GBPUSD", 0, Time[i]);
      int shiftCHF = iBarShift("USDCHF", 0, Time[i]);
      int shiftJPY = iBarShift("USDJPY", 0, Time[i]);
      int shiftCAD = iBarShift("USDCAD", 0, Time[i]);
      int shiftAUD = iBarShift("AUDUSD", 0, Time[i]);
      int shiftNZD = iBarShift("NZDUSD", 0, Time[i]);

      //      .
      double usd1=MathPow(iMA("USDCHF",0,period1,shift,MA_Method,Price,shiftCHF)*
                          iMA("USDJPY",0,period1,shift,MA_Method,Price,shiftJPY)*
                          iMA("USDCAD",0,period1,shift,MA_Method,Price,shiftCAD)/
                          iMA("EURUSD",0,period1,shift,MA_Method,Price,shiftEUR)/
                          iMA("GBPUSD",0,period1,shift,MA_Method,Price,shiftGBP)/
                          iMA("AUDUSD",0,period1,shift,MA_Method,Price,shiftAUD)/
                          iMA("NZDUSD",0,period1,shift,MA_Method,Price,shiftNZD),1./8.);
      double eur1=iMA("EURUSD",0,period1,shift,MA_Method,Price,shiftEUR)*usd1;
      double gbp1=iMA("GBPUSD",0,period1,shift,MA_Method,Price,shiftGBP)*usd1;
      double chf1=usd1/iMA("USDCHF",0,period1,shift,MA_Method,Price,shiftCHF);
      double idxjpy1=(iMA("USDJPY",0,period1,shift,MA_Method,Price,shiftJPY))/usd1;
      double cad1=usd1/iMA("USDCAD",0,period1,shift,MA_Method,Price,shiftCAD);
      double aud1=iMA("AUDUSD",0,period1,shift,MA_Method,Price,shiftAUD)*usd1;
      double nzd1=iMA("NZDUSD",0,period1,shift,MA_Method,Price,shiftNZD)*usd1;

      //      .
      double usd2=MathPow(iMA("USDCHF",0,period2,shift,MA_Method,Price,shiftCHF)*
                          iMA("USDJPY",0,period2,shift,MA_Method,Price,shiftJPY)*
                          iMA("USDCAD",0,period2,shift,MA_Method,Price,shiftCAD)/
                          iMA("EURUSD",0,period2,shift,MA_Method,Price,shiftEUR)/
                          iMA("GBPUSD",0,period2,shift,MA_Method,Price,shiftGBP)/
                          iMA("AUDUSD",0,period2,shift,MA_Method,Price,shiftAUD)/
                          iMA("NZDUSD",0,period2,shift,MA_Method,Price,shiftNZD),1./8.);
      double eur2=iMA("EURUSD",0,period2,shift,MA_Method,Price,shiftEUR)*usd2;
      double gbp2=iMA("GBPUSD",0,period2,shift,MA_Method,Price,shiftGBP)*usd2;
      double chf2=usd2/iMA("USDCHF",0,period2,shift,MA_Method,Price,shiftCHF);
      double idxjpy2=(iMA("USDJPY",0,period2,shift,MA_Method,Price,shiftJPY))/usd2;
      double cad2=usd2/iMA("USDCAD",0,period2,shift,MA_Method,Price,shiftCAD);
      double aud2=iMA("AUDUSD",0,period2,shift,MA_Method,Price,shiftAUD)*usd2;
      double nzd2=iMA("NZDUSD",0,period2,shift,MA_Method,Price,shiftNZD)*usd2;

      //  ""   "",    . (  )
      double usdp=usd1-usd2;
      double eurp=eur1-eur2;
      double gbpp=gbp1-gbp2;
      double chfp=chf1-chf2;
      double idxjpyp=idxjpy1-idxjpy2;
      double cadp=cad1-cad2;
      double audp=aud1-aud2;
      double nzdp=nzd1-nzd2;
      string s=Symbol();
      string k=StringSubstr(Symbol(), 3, 3);//  
      string b=StringSubstr(Symbol(), 0, 3);//  
                                            // ,            .
      double ch1=0,ch2=0;
      if(b=="USD"){ch1=usdp;}
      if(b=="EUR"){ch1=eurp;}    if(k=="USD"){ch2=usdp;}
      if(b=="GBP"){ch1=gbpp;}    if(k=="GBP"){ch2=gbpp;}
      if(b=="CHF"){ch1=chfp;}    if(k=="CHF"){ch2=chfp;}
      if(k=="JPY"){ch2=idxjpyp;}
      if(b=="CAD"){ch1=cadp;}    if(k=="CAD"){ch2=cadp;}
      if(b=="NZD"){ch1=nzdp;}    if(k=="AUD"){ch2=audp;}
      if(b=="AUD"){ch1=audp;}    if(k=="NZD"){ch2=nzdp;}


      // ,    ;    ,   ;    ,        .
      if(all_idx_mode)
        {//      
         if(k=="JPY")// k  "JPY" 
           {
            Buffer1[i]=iMA(s,0,period,shift,MA_Method,Price,i)+eurp*100;
            Buffer2[i]=iMA(s,0,period,shift,MA_Method,Price,i)+usdp*100;
            Buffer3[i]=iMA(s,0,period,shift,MA_Method,Price,i)+gbpp*100;
            Buffer4[i]=iMA(s,0,period,shift,MA_Method,Price,i)+chfp*100;
            Buffer5[i]=iMA(s,0,period,shift,MA_Method,Price,i)-idxjpyp;
            Buffer6[i]=iMA(s,0,period,shift,MA_Method,Price,i)+cadp*100;
            Buffer7[i]=iMA(s,0,period,shift,MA_Method,Price,i)+audp*100;
            Buffer8[i]=iMA(s,0,period,shift,MA_Method,Price,i)+nzdp*100;

           }
         else
           {
            Buffer1[i]=iMA(s,0,period,shift,MA_Method,Price,i)+eurp;
            Buffer2[i]=iMA(s,0,period,shift,MA_Method,Price,i)+usdp;
            Buffer3[i]=iMA(s,0,period,shift,MA_Method,Price,i)+gbpp;
            Buffer4[i]=iMA(s,0,period,shift,MA_Method,Price,i)+chfp;
            Buffer5[i]=iMA(s,0,period,shift,MA_Method,Price,i)-idxjpyp/100;
            Buffer6[i]=iMA(s,0,period,shift,MA_Method,Price,i)+cadp;
            Buffer7[i]=iMA(s,0,period,shift,MA_Method,Price,i)+audp;
            Buffer8[i]=iMA(s,0,period,shift,MA_Method,Price,i)+nzdp;
           }

        }
      else   //   -       
        {
         if(k=="JPY")
           {
            Buffer1[i]=iMA(s,0,period,shift,MA_Method,Price,i)+ch1*100;
            Buffer2[i]=iMA(s,0,period,shift,MA_Method,Price,i)-ch2;
           }
         else
           {
            Buffer1[i]=iMA(s,0,period,shift,MA_Method,Price,i)+ch1;
            Buffer2[i]=iMA(s,0,period,shift,MA_Method,Price,i)+ch2;
           }
        }

     }
//----

//----
   return(0);
  }
//+------------------------------------------------------------------+
