//+------------------------------------------------------------------+
//|                                                   Sort_array.mq4 |
//|                                                             amba |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "amba"
#property link      ""

#import "ArrayEx.ex4"
    int Array.Sort(double &a[][],int order[]);
    int Array.Group(double &a[][],int groups[],int sums[],double &dest[][]);
    int Array.Select(double &a[][], double & filter[][], double & dest[][]);

#define COLS 7
int start()
{
    double A[200000][COLS];
    
    ArrayInitialize(A,1);
    
    for(int i=0;i<200000;i++)
        for(int j=0;j<COLS-1;j++)
            A[i][j]=MathRand()*5/32767;

    Print(" ...  (AR10.csv)    ", ArrayRange(A,0));
    Array.Print(A,10);
    
    //   .   1 !. ASC +1, DESC -1
    int g[]={ 6, 4, 2,-1,-3,-5};    // {5 asc, 3 asc, 1 asc, 0 desc, 2 desc, 4 desc}
    int s[]={COLS};                 //   .   1 !
    
    double dest[][COLS];            //    s[]   g[]
    
    int tt;
    tt = GetTickCount();
    Array.Sort(A,g);
    Print("1 , : ",GetTickCount()-tt," (AR1.csv)");
    
    tt = GetTickCount();
    Array.Sort(A,g);
    Print("2  , : ",GetTickCount()-tt);
    
    Array.Print(A,1);
    
    tt = GetTickCount();
    Array.Group(A, g, s, dest);
    Print(", : ",GetTickCount()-tt, ";    ", 
        ArrayRange(A,0), ",   ", ArrayRange(dest,0)," (AR2.csv)");
    
    Array.Print(dest,2);
    
    ///////// 
    double b[][COLS];
    double filt[3][3];
    
    //  +1    min               max
    filt[0][0]=1;    filt[0][1]=1;    filt[0][2]=2;
    filt[1][0]=2;    filt[1][1]=1;    filt[1][2]=1;
    filt[2][0]=3;    filt[2][1]=3;    filt[2][2]=3;

    tt = GetTickCount();
    Array.Select(A, filt, b);
    Print(", : ",GetTickCount()-tt, ";    ", ArrayRange(A,0),
        ",   ", ArrayRange(b,0)," (AR4.csv)");

    Array.Print(b,4);

    tt = GetTickCount();
    Array.Select(dest, filt, b);
    Print(", : ",GetTickCount()-tt, ";    ", ArrayRange(dest,0), 
        ",   ", ArrayRange(b,0)," (AR5.csv)");

    Array.Print(b,5);

    Print("END       experts\files\AP*.csv    Excel");
    
}




void Array.Print(double & a[][], int p=0)
{
    if(p==0) p=GetTickCount();
    int handle=FileOpen("AP"+p+".csv",FILE_WRITE|FILE_CSV,",");
    if(handle<0)
    {
        Print(GetLastError());
        return(0);
    } 
    for(int i=0;i<ArrayRange(a,0);i++)
    {
        string s="";
        for(int j=0;j<ArrayRange(a,1);j++)
            s=StringConcatenate(s, a[i][j], ",");
        
        FileWrite(handle,s);
    }
    FileClose(handle);
 }