//+-------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                               ZH_StandardFunctionsTfQ1.lib.mq4|
//|                                                                                               Copyright  Zhunko              |
//|14.09.2009 - 12.10.2009                                                                        F ZHUNKO vadim@zhunko.ru       |
//+-------------------------------------------------------------------------------------------------------------------------------+
//|      Q1.                                                                                          |
//+-------------------------------------------------------------------------------------------------------------------------------+
//|1.    Q1.                                                                                                    |
//|  int iBars_Q1 (string symbol); //   .                                                                 |
//+-------------------------------------------------------------------------------------------------------------------------------+
//|2.      Q1.                                                                                               |
//|  int iBarShift_Q1 (string   symbol, //   .                                                            |
//|                    datetime time,   //    .                                                           |
//|                    bool     exact)  //                                                     |
//|                                     // (FALSE - iBarShift  /TRUE - iBarShift  -1).               |
//+-------------------------------------------------------------------------------------------------------------------------------+
//|3.       Q1.                                                                                       |
//|  datetime iTime_Q1 (string symbol, //                                                                 |
//|                     int    shift)  //  .                                                                             |
//+-------------------------------------------------------------------------------------------------------------------------------+
//|4.      Q1.                                                                                       |
//|  double iOpen_Q1 (string symbol, //   .                                                               |
//|                   int    shift)  //  .                                                                               |
//+-------------------------------------------------------------------------------------------------------------------------------+
//|5.      Q1.                                                                                   |
//|  double iHigh_Q1 (string symbol, //   .                                                               |
//|                   int    shift)  //  .                                                                               |
//+-------------------------------------------------------------------------------------------------------------------------------+
//|6.      Q1.                                                                                    |
//|  double iLow_Q1 (string symbol, //  .                                                                            |
//|                  int    shift)  //  .                                                                                |
//+-------------------------------------------------------------------------------------------------------------------------------+
//|7.      Q1.                                                                                       |
//|  double iClose_Q1 (string symbol, //   .                                                              |
//|                    int    shift)  //  .                                                                              |
//+-------------------------------------------------------------------------------------------------------------------------------+
//|8.       .                                                                          |
//|   int Quarter()                                                                                                               |
//+-------------------------------------------------------------------------------------------------------------------------------+
//|9.      .                                                                           |
//|   int TimeQuarter (datetime time) // ,     ,   00:00 1  1970 . |
//+-------------------------------------------------------------------------------------------------------------------------------+
//
#property copyright "Copyright  2006 Zhunko"
#property link      "vadim@zhunko.ru"
#property library
//----.-----------------------------------------------------------------------------------------------------------------------------
//          :                                         
int ArSecondsInMonth[2][12] = {2678400, 2419200, 2678400, 2592000, 2678400, 2592000, 2678400, 2678400, 2592000, 2678400, 2592000, 2678400,
//         :                                            
                               2678400, 2505600, 2678400, 2592000, 2678400, 2592000, 2678400, 2678400, 2592000, 2678400, 2592000, 2678400};
//
// 1.     Q1.
int iBars_Q1 (string symbol) //   .
 {
  bool     Switch_Q1 = true; //       .
  bool     Switch_Q2 = true; //       .
  bool     Switch_Q3 = true; //       .
  bool     Switch_Q4 = true; //       .
  datetime iTimeMN1;         //    .
  int      i;
  int      iBarsMN1;         //     MN1  .
  int      iBarsQ1;          //     Q1.
  //----
  iBarsMN1 = iBars (symbol, PERIOD_MN1); //     MN1  .
  for (i = 0, iBarsQ1 = 0; i < iBarsMN1; i++)
   {
    iTimeMN1 = iTime (symbol, PERIOD_MN1, i); //    .
    if (i > 0) //       .
     {//   ,       .            (  ).
      if (MathMod (TimeYear (iTimeMN1), TimeYear (iTime (symbol, PERIOD_MN1, i - 1))) != 0)
       {
        Switch_Q1 = true; //       .
        Switch_Q2 = true; //       .
        Switch_Q3 = true; //       .
        Switch_Q4 = true; //       .
       }
     }
    //    .
    switch (TimeMonth (iTimeMN1))
     {//---- 4- .-----------------------------------------------------------------------------------------
      case 12:
      case 11:
      case 10:
       {
        Switch_Q3 = true;      //      3- .
        Switch_Q2 = true;      //      2- .
        Switch_Q1 = true;      //      1- .
        if (Switch_Q4 == true) //   .
         {
          iBarsQ1++;           //   .
          Switch_Q4 = false;   //         .
          break;               //   .
         }
        else continue;         //    ,       .
       }
      //---- 3- .-----------------------------------------------------------------------------------------
      case 9:
      case 8:
      case 7:
       {
        Switch_Q4 = true;      //      4- .
        Switch_Q2 = true;      //      2- .
        Switch_Q1 = true;      //      1- .
        if (Switch_Q3 == true) //   .
         {
          iBarsQ1++;           //   .
          Switch_Q3 = false;   //         .
          break;               //   .
         }
        else continue;         //    ,       .
       }
      //---- 2- .-----------------------------------------------------------------------------------------
      case 6:
      case 5:
      case 4:
       {
        Switch_Q4 = true;      //      4- .
        Switch_Q3 = true;      //      3- .
        Switch_Q1 = true;      //      1- .
        if (Switch_Q2 == true) //   .
         {
          iBarsQ1++;           //   .
          Switch_Q2 = false;   //         .
          break;               //   .
         }
        else continue;         //    ,       .
       }
      //---- 1- .-----------------------------------------------------------------------------------------
      case 3:
      case 2:
      case 1:
       {
        Switch_Q4 = true;      //      4- .
        Switch_Q3 = true;      //      3- .
        Switch_Q2 = true;      //      2- .
        if (Switch_Q1 == true) //   .
         {
          iBarsQ1++;           //   .
          Switch_Q1 = false;   //         .
          break;               //   .
         }
        else continue;         //    ,       .
       }
     }
   }
  return (iBarsQ1);
 }
//
// 2.       Q1.
int iBarShift_Q1 (string   symbol, //   .
                  datetime time,   //    .
                  bool     exact)  //       (FALSE - iBarShift  /TRUE - iBarShift  -1).
 {
  bool     Switch_Q1 = true; //       .
  bool     Switch_Q2 = true; //       .
  bool     Switch_Q3 = true; //       .
  bool     Switch_Q4 = true; //       .
  datetime TimeFirst_Q1;     //       .    .
  datetime TimeLast_Q1;      //       .
  datetime iTimeMN1;         //      MN1.
  datetime iTimeQ1_0;        //      Q1.
  datetime iTimeQ1_1;        //      Q1.
  int      AmountBar;        //         .
  int      i, j;
  int      ShiftQ1 = 0;      //       Q1.
  int      iBarsMN1;         //     MN1  .
  int      LeapYear;         //    .
  int      NumberMonth;      //  .
  //==== .================================================================================================================================================================================================================
  iBarsMN1 = iBars (symbol, PERIOD_MN1);                           //     MN1  .
  //====       .    .==========================================================================================================================================
  TimeFirst_Q1 = iTime (symbol, PERIOD_MN1, iBarsMN1 - 1);         //       .
  if (MathMod (TimeYear (TimeFirst_Q1), 4) == 0) LeapYear = true;  //   .
  else LeapYear = false;                                           //    .
  NumberMonth = TimeMonth (TimeFirst_Q1);                          //  .
  //       .
  AmountBar = MathMod (NumberMonth, 3);                            //     ,      .
  if (AmountBar > 0) AmountBar = 3 - AmountBar;                    //      ,  .
  //   .
  for (i = NumberMonth; i <= (NumberMonth + AmountBar); i++) TimeFirst_Q1 += ArSecondsInMonth[LeapYear][i - 1];
  //====       .===================================================================================================================================================================
  TimeLast_Q1 = iTime (symbol, PERIOD_MN1, 0);                     //       .
  if (MathMod (TimeYear (TimeLast_Q1), 4) == 0) LeapYear = true;   //   .
  else LeapYear = false;                                           //    .
  NumberMonth = TimeMonth (TimeLast_Q1);                           //  .
  //       .
  AmountBar = MathMod (NumberMonth, 3);                            //     .
  if (AmountBar == 0) AmountBar = 2;                               //     ,      .
  else AmountBar = AmountBar - 1;                                  //      ,  .
  //   .    .
  for (i = (NumberMonth - AmountBar); i < NumberMonth; i++) TimeLast_Q1 -= ArSecondsInMonth[LeapYear][i - 1];
  //----.---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//  Comment ("TimeFirst_Q1 = ", TimeToStr (TimeFirst_Q1, TIME_DATE|TIME_MINUTES|TIME_SECONDS), "\nLastQuarter = ", TimeToStr (TimeLast_Q1, TIME_DATE|TIME_MINUTES|TIME_SECONDS));
  //======================================================================================================================================================================================================================================
  if (time < TimeFirst_Q1 || time >= TimeLast_Q1)              //     ,             . 
   {
    if (exact == true) return (-1);                            //   ,   -1    .
    else                                                       //   ,       () .
     {
      if (time < TimeFirst_Q1) return (iBars_Q1 (symbol) - 1); //          ,   .
      if (time > TimeLast_Q1) return (0);                      //          ,   .
     }
   }
  else                                                               //       .
   {//      Q1.
    iTimeQ1_0 = iTime (symbol, PERIOD_MN1, 0);                       //       .
    if (MathMod (TimeYear (TimeFirst_Q1), 4) == 0) LeapYear = true;  //   .
    else LeapYear = false;                                           //    .
    NumberMonth = TimeMonth (iTimeQ1_0);                             //  .
    AmountBar = 3 - MathMod (NumberMonth, 3);                        //       .
    //      Q1.   .
    for (i = NumberMonth; i <= (NumberMonth + AmountBar); i++) iTimeQ1_0 += ArSecondsInMonth[LeapYear][i - 1];
    //    .  .
    if (MathMod (TimeYear (TimeLast_Q1), 4) == 0) LeapYear = true;   //   .
    else LeapYear = false;                                           //    .
    for (i = 0, ShiftQ1 = -1; i < iBarsMN1; i++) //    .    .
     {
      iTimeMN1 = iTime (symbol, PERIOD_MN1, i);  //     .
      //        .         MN1.
      if (i > 0) //       .
       {//   ,       .            (  ).
        if (MathMod (TimeYear (iTimeMN1), TimeYear (iTime (symbol, PERIOD_MN1, i - 1))) != 0)
         {
          Switch_Q1 = true; //       .
          Switch_Q2 = true; //       .
          Switch_Q3 = true; //       .
          Switch_Q4 = true; //       .
          //    .
          if (MathMod (TimeYear (iTimeMN1), 4) == 0) LeapYear = true; //   .
          else LeapYear = false;                                      //    .
         }
       }
      //    .
      NumberMonth = TimeMonth (iTimeMN1); //  .
      switch (NumberMonth)
       {//---- 4- .--------------------------------------------------------------------------------------
        case 12:
        case 11:
        case 10:
         {
          Switch_Q3 = true;       //      3- .
          Switch_Q2 = true;       //      2- .
          Switch_Q1 = true;       //      1- .
          if (Switch_Q4 == true)  //   .
           {
            ShiftQ1++;            //   .
            Switch_Q4 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
        //---- 3- .--------------------------------------------------------------------------------------
        case 9:
        case 8:
        case 7:
         {
          Switch_Q4 = true;      //      4- .
          Switch_Q2 = true;      //      2- .
          Switch_Q1 = true;      //      1- .
          if (Switch_Q3 == true) //   .
           {
            ShiftQ1++;           //   .
            Switch_Q3 = false;   //         .
            break;               //   .
           }
          else continue;         //    ,       .
         }
        //---- 2- .--------------------------------------------------------------------------------------
        case 6:
        case 5:
        case 4:
         {
          Switch_Q4 = true;      //      4- .
          Switch_Q3 = true;      //      3- .
          Switch_Q1 = true;      //      1- .
          if (Switch_Q2 == true) //   .
           {
            ShiftQ1++;           //   .
            Switch_Q2 = false;   //         .
            break;               //   .
           }
          else continue;         //    ,       .
         }
        //---- 1- .--------------------------------------------------------------------------------------
        case 3:
        case 2:
        case 1:
         {
          Switch_Q4 = true;      //      4- .
          Switch_Q3 = true;      //      3- .
          Switch_Q2 = true;      //      2- .
          if (Switch_Q1 == true) //   .
           {
            ShiftQ1++;           //   .
            Switch_Q1 = false;   //         .
            break;               //   .
           }
          else continue;         //    ,       .
         }
       }
      //   ,       "" .
      if (exact == true)
       {//      .
        iTimeQ1_1 = iTimeMN1;                         //       .
        //       .
        AmountBar = MathMod (NumberMonth, 3);         //     ,      .
        if (AmountBar > 0) AmountBar = 3 - AmountBar; //      ,  .
        //           Q1.
        for (j = NumberMonth; j <= (NumberMonth + AmountBar); j++) iTimeQ1_1 += ArSecondsInMonth[LeapYear][j - 1];
        //   ""  .
        if (iTimeQ1_1 < time && time < iTimeQ1_0) return (-1); //  -1    .
       }
      //      .
      iTimeQ1_0 = iTimeMN1;                 //       .
      //       .
      AmountBar = MathMod (NumberMonth, 3); //     .
      if (AmountBar == 0) AmountBar = 2;    //     ,      .
      else AmountBar = AmountBar - 1;       //      ,  .
      //           Q1.
      for (j = (NumberMonth - AmountBar); j < NumberMonth; j++) iTimeQ1_0 -= ArSecondsInMonth[LeapYear][j - 1];
      if (time >= iTimeQ1_0) return (ShiftQ1);  //      Q1.
     }
   }
 }
//
// 3.        Q1.
datetime iTime_Q1 (string symbol, //   
                   int    shift)  //  .
 {
  bool     Switch_Q1 = true; //       .
  bool     Switch_Q2 = true; //       .
  bool     Switch_Q3 = true; //       .
  bool     Switch_Q4 = true; //       .
  datetime iTimeMN1;         //    .
  datetime iTimeQ1;          //  .
  int      AmountBar;        //         .
  int      i, j;
  int      iBarsMN1 = iBars (symbol, PERIOD_MN1); //     MN1  .
  int      iBarsQ1 = iBars_Q1 (symbol);           //     Q1.
  int      LeapYear;                              //  .
  int      NumberMonth;                           //  .
  int      ShiftQ1;                               //     Q1.
  //----
  if (0 > shift || shift >= iBarsQ1) return (0); //     .
  else                                           //       ,  .
   {//    .   .
    if (MathMod (TimeYear (MarketInfo (symbol, MODE_TIME)), 4) == 0) LeapYear = true; //   .
    else LeapYear = false;                                                            //    .
    for (i = 0, ShiftQ1 = -1; i < iBarsMN1; i++) //     .
     {
      iTimeMN1 = iTime (symbol, PERIOD_MN1, i);  //    .
      if (i > 0) //       .
       {//   ,       .            (  ).
        if (MathMod (TimeYear (iTimeMN1), TimeYear (iTime (symbol, PERIOD_MN1, i - 1))) != 0)
         {
          Switch_Q1 = true; //       .
          Switch_Q2 = true; //       .
          Switch_Q3 = true; //       .
          Switch_Q4 = true; //       .
          //    .
          if (MathMod (TimeYear (iTimeMN1), 4) == 0) LeapYear = true; //   .
          else LeapYear = false;                                      //    .
         }
       }
      //    .
      NumberMonth = TimeMonth (iTimeMN1); //  .
      switch (NumberMonth)
       {//---- 4- .-----------------------------------------------------------------------------------------
        case 12:
        case 11:
        case 10:
         {
          Switch_Q3 = true;       //      3- .
          Switch_Q2 = true;       //      2- .
          Switch_Q1 = true;       //      1- .
          if (Switch_Q4 == true)  //   .
           {
            ShiftQ1++;            //   .
            Switch_Q4 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
        //---- 3- .-----------------------------------------------------------------------------------------
        case 9:
        case 8:
        case 7:
         {
          Switch_Q4 = true;       //      4- .
          Switch_Q2 = true;       //      2- .
          Switch_Q1 = true;       //      1- .
          if (Switch_Q3 == true)  //   .
           {
            ShiftQ1++;            //   .
            Switch_Q3 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
        //---- 2- .-----------------------------------------------------------------------------------------
        case 6:
        case 5:
        case 4:
         {
          Switch_Q4 = true;       //      4- .
          Switch_Q3 = true;       //      3- .
          Switch_Q1 = true;       //      1- .
          if (Switch_Q2 == true)  //   .
           {
            ShiftQ1++;            //   .
            Switch_Q2 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
        //---- 1- .-----------------------------------------------------------------------------------------
        case 3:
        case 2:
        case 1:
         {
          Switch_Q4 = true;       //      4- .
          Switch_Q3 = true;       //      3- .
          Switch_Q2 = true;       //      2- .
          if (Switch_Q1 == true)  //   .
           {
            ShiftQ1++;            //   .
            Switch_Q1 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
       }
      //    .
      if (shift == ShiftQ1)
       {//      .
        iTimeQ1 = iTimeMN1;                   //       .
        //       .
        AmountBar = MathMod (NumberMonth, 3); //     .
        if (AmountBar == 0) AmountBar = 2;    //     ,      .
        else AmountBar = AmountBar - 1;       //      ,  .
        //   .
        for (j = (NumberMonth - AmountBar); j < NumberMonth; j++) iTimeQ1 -= ArSecondsInMonth[LeapYear][j - 1]; //      Q1.
//        Comment ("NumberMonth = ", NumberMonth, "\nShiftQ1 = ", ShiftQ1, "\niTimeQ1 = ", TimeToStr (iTimeQ1, TIME_DATE|TIME_MINUTES|TIME_SECONDS));
//        Sleep (5000);
        return (iTimeQ1);                     //     .
       }
     }
   }
 }
//
// 4.       Q1.
double iOpen_Q1 (string symbol, //   .
                 int    shift)  //  .
 {
  bool     Switch_Q1 = true; //       .
  bool     Switch_Q2 = true; //       .
  bool     Switch_Q3 = true; //       .
  bool     Switch_Q4 = true; //       .
  datetime iTimeMN1;         //    .
  int      i, j, k;
  int      iBarsMN1 = iBars (symbol, PERIOD_MN1); //     MN1  .
  int      iBarsQ1 = iBars_Q1 (symbol);           //     Q1.
  int      FirstMonth;                            //    .
  int      ShiftQ1;                               //     Q1.
  //----
  if (0 > shift || shift >= iBarsQ1) return (0); //     .
  else                                           //       ,  .
   {
    for (i = 0, ShiftQ1 = -1; i < iBarsMN1; i++) //     .
     {
      iTimeMN1 = iTime (symbol, PERIOD_MN1, i);  //    .
      if (i > 0) //       .
       {//   ,       .            (  ).
        if (MathMod (TimeYear (iTimeMN1), TimeYear (iTime (symbol, PERIOD_MN1, i - 1))) != 0)
         {
          Switch_Q1 = true; //       .
          Switch_Q2 = true; //       .
          Switch_Q3 = true; //       .
          Switch_Q4 = true; //       .
         }
       }
      //    .
      switch (TimeMonth (iTimeMN1))
       {//---- 4- .-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        case 12:
        case 11:
        case 10:
         {
          Switch_Q3 = true;       //      3- .
          Switch_Q2 = true;       //      2- .
          Switch_Q1 = true;       //      1- .
          if (Switch_Q4 == true)  //   .
           {
            ShiftQ1++;            //   .
            FirstMonth = 10;      //    .
            Switch_Q4 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
        //---- 3- .-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        case 9:
        case 8:
        case 7:
         {
          Switch_Q4 = true;       //      4- .
          Switch_Q2 = true;       //      2- .
          Switch_Q1 = true;       //      1- .
          if (Switch_Q3 == true)  //   .
           {
            ShiftQ1++;            //   .
            FirstMonth = 7;       //    .
            Switch_Q3 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
        //---- 2- .-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        case 6:
        case 5:
        case 4:
         {
          Switch_Q4 = true;       //      4- .
          Switch_Q3 = true;       //      3- .
          Switch_Q1 = true;       //      1- .
          if (Switch_Q2 == true)  //   .
           {
            ShiftQ1++;            //   .
            FirstMonth = 4;       //    .
            Switch_Q2 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
        //---- 1- .-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        case 3:
        case 2:
        case 1:
         {
          Switch_Q4 = true;       //      4- .
          Switch_Q3 = true;       //      3- .
          Switch_Q2 = true;       //      2- .
          if (Switch_Q1 == true)  //   .
           {
            ShiftQ1++;            //   .
            FirstMonth = 1;       //    .
            Switch_Q1 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
        //--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
       }
      if (shift == ShiftQ1) //    .
       {
        for (i++, k = TimeYear (iTimeMN1);; i++) //      .
         {
          iTimeMN1 = iTime (symbol, PERIOD_MN1, i);    //    .
          //         .
          if (FirstMonth == 1) {if (TimeMonth (iTimeMN1) > 3 || TimeYear (iTimeMN1) != k) return (iOpen (symbol, PERIOD_MN1, i - 1));} //  ,         .
          else {if (TimeMonth (iTimeMN1) < FirstMonth || TimeYear (iTimeMN1) != k) return (iOpen (symbol, PERIOD_MN1, i - 1));}        //  ,         .
         }
       }
     }
   }
 }
//
// 5.       Q1.
double iHigh_Q1 (string symbol, //   .
                 int    shift)  //  .
 {
  bool     Switch_Q1 = true; //       .
  bool     Switch_Q2 = true; //       .
  bool     Switch_Q3 = true; //       .
  bool     Switch_Q4 = true; //       .
  datetime iTimeMN1;         //    .
  datetime iTimeMN1_1;       //     .
  int      i, l;
  int      iBarsMN1 = iBars (symbol, PERIOD_MN1); //     MN1  .
  int      iBarsQ1 = iBars_Q1 (symbol);           //     Q1.
  int      FirstMonth;                            //    .
  int      ShiftQ1;                               //     Q1.
  // .
  double   ArHighMN1[3]; //         .
  //----
  if (0 > shift || shift >= iBarsQ1) return (0); //     .
  else                                           //       ,  .
   {
    for (i = 0, ShiftQ1 = -1; i < iBarsMN1; i++) //     .
     {
      iTimeMN1 = iTime (symbol, PERIOD_MN1, i);  //    .
      if (i > 0) //       .
       {//   ,       .            (  ).
        if (MathMod (TimeYear (iTimeMN1), TimeYear (iTime (symbol, PERIOD_MN1, i - 1))) != 0)
         {
          Switch_Q1 = true; //       .
          Switch_Q2 = true; //       .
          Switch_Q3 = true; //       .
          Switch_Q4 = true; //       .
         }
       }
      //    .
      switch (TimeMonth (iTimeMN1))
       {//---- 4- .-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        case 12:
        case 11:
        case 10:
         {
          Switch_Q3 = true;       //      3- .
          Switch_Q2 = true;       //      2- .
          Switch_Q1 = true;       //      1- .
          if (Switch_Q4 == true)  //   .
           {
            ShiftQ1++;            //   .
            FirstMonth = 10;      //    .
            Switch_Q4 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
        //---- 3- .-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        case 9:
        case 8:
        case 7:
         {
          Switch_Q4 = true;       //      4- .
          Switch_Q2 = true;       //      2- .
          Switch_Q1 = true;       //      1- .
          if (Switch_Q3 == true)  //   .
           {
            ShiftQ1++;            //   .
            FirstMonth = 7;       //    .
            Switch_Q3 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
        //---- 2- .-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        case 6:
        case 5:
        case 4:
         {
          Switch_Q4 = true;       //      4- .
          Switch_Q3 = true;       //      3- .
          Switch_Q1 = true;       //      1- .
          if (Switch_Q2 == true)  //   .
           {
            ShiftQ1++;            //   .
            FirstMonth = 4;       //    .
            Switch_Q2 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
        //---- 1- .-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        case 3:
        case 2:
        case 1:
         {
          Switch_Q4 = true;       //      4- .
          Switch_Q3 = true;       //      3- .
          Switch_Q2 = true;       //      2- .
          if (Switch_Q1 == true)  //   .
           {
            ShiftQ1++;            //   .
            FirstMonth = 1;       //    .
            Switch_Q1 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
        //--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
       }
      if (shift == ShiftQ1) //    .
       {
        for (l = 0; l < 3; i++, l++)  //      .
         {
          iTimeMN1 = iTime (symbol, PERIOD_MN1, i);             //     .
          iTimeMN1_1 = iTime (symbol, PERIOD_MN1, i + 1);       //     .
          ArHighMN1[l] = iHigh (symbol, PERIOD_MN1, i);         //        .
          //         .
          if (FirstMonth == 1) {if (TimeMonth (iTimeMN1_1) > 3 || TimeYear (iTimeMN1) != TimeYear (iTimeMN1_1)) break;} //  ,         .
          else {if (TimeMonth (iTimeMN1_1) < FirstMonth || TimeYear (iTimeMN1) != TimeYear (iTimeMN1_1)) break;}        //  ,         .
         }
        return (ArHighMN1[ArrayMaximum (ArHighMN1, l + 1, 0)]); //     .
       }
     }
   }
 }
//
// 6.       Q1.
double iLow_Q1 (string symbol, //  .
                int    shift)  //  .
 {
  bool     Switch_Q1 = true; //       .
  bool     Switch_Q2 = true; //       .
  bool     Switch_Q3 = true; //       .
  bool     Switch_Q4 = true; //       .
  datetime iTimeMN1;         //    .
  datetime iTimeMN1_1;       //     .
  int      i, l;
  int      iBarsMN1 = iBars (symbol, PERIOD_MN1); //     MN1  .
  int      iBarsQ1 = iBars_Q1 (symbol);           //     Q1.
  int      FirstMonth;                            //    .
  int      ShiftQ1;                               //     Q1.
  // .
  double   ArLowMN1[3]; //         .
  //----
  if (0 > shift || shift >= iBarsQ1) return (0); //     .
  else                                           //       ,  .
   {
    for (i = 0, ShiftQ1 = -1; i < iBarsMN1; i++) //     .
     {
      iTimeMN1 = iTime (symbol, PERIOD_MN1, i);  //    .
      if (i > 0) //       .
       {//   ,       .            (  ).
        if (MathMod (TimeYear (iTimeMN1), TimeYear (iTime (symbol, PERIOD_MN1, i - 1))) != 0)
         {
          Switch_Q1 = true; //       .
          Switch_Q2 = true; //       .
          Switch_Q3 = true; //       .
          Switch_Q4 = true; //       .
         }
       }
      //    .
      switch (TimeMonth (iTimeMN1))
       {//---- 4- .-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        case 12:
        case 11:
        case 10:
         {
          Switch_Q3 = true;       //      3- .
          Switch_Q2 = true;       //      2- .
          Switch_Q1 = true;       //      1- .
          if (Switch_Q4 == true)  //   .
           {
            ShiftQ1++;            //   .
            FirstMonth = 10;      //    .
            Switch_Q4 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
        //---- 3- .-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        case 9:
        case 8:
        case 7:
         {
          Switch_Q4 = true;       //      4- .
          Switch_Q2 = true;       //      2- .
          Switch_Q1 = true;       //      1- .
          if (Switch_Q3 == true)  //   .
           {
            ShiftQ1++;            //   .
            FirstMonth = 7;       //    .
            Switch_Q3 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
        //---- 2- .-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        case 6:
        case 5:
        case 4:
         {
          Switch_Q4 = true;       //      4- .
          Switch_Q3 = true;       //      3- .
          Switch_Q1 = true;       //      1- .
          if (Switch_Q2 == true)  //   .
           {
            ShiftQ1++;            //   .
            FirstMonth = 4;       //    .
            Switch_Q2 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
        //---- 1- .-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        case 3:
        case 2:
        case 1:
         {
          Switch_Q4 = true;       //      4- .
          Switch_Q3 = true;       //      3- .
          Switch_Q2 = true;       //      2- .
          if (Switch_Q1 == true)  //   .
           {
            ShiftQ1++;            //   .
            FirstMonth = 1;       //    .
            Switch_Q1 = false;    //         .
            break;                //   .
           }
          else continue;          //    ,       .
         }
        //--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
       }
      if (shift == ShiftQ1) //    .
       {
        for (l = 0; l < 3; i++, l++) //      .
         {
          iTimeMN1 = iTime (symbol, PERIOD_MN1, i);            //    .
          iTimeMN1_1 = iTime (symbol, PERIOD_MN1, i + 1);      //     .
          ArLowMN1[l] = iLow (symbol, PERIOD_MN1, i);          //        .
          //         .
          if (FirstMonth == 1) {if (TimeMonth (iTimeMN1_1) > 3 || TimeYear (iTimeMN1) != TimeYear (iTimeMN1_1)) break;} //  ,         .
          else {if (TimeMonth (iTimeMN1_1) < FirstMonth || TimeYear (iTimeMN1) != TimeYear (iTimeMN1_1)) break;}        //  ,         .
         }
        return (ArLowMN1[ArrayMinimum (ArLowMN1, l + 1, 0)]);  //     .
       }
     }
   }
 }
//
// 7.       Q1.
double iClose_Q1 (string symbol, //   .
                  int    shift)  //  .
 {
  bool     Switch_Q1 = true; //       .
  bool     Switch_Q2 = true; //       .
  bool     Switch_Q3 = true; //       .
  bool     Switch_Q4 = true; //       .
  datetime iTimeMN1;         //    .
  int      i;
  int      iBarsMN1 = iBars (symbol, PERIOD_MN1); //     MN1  .
  int      iBarsQ1 = iBars_Q1 (symbol);           //        Q1.
  //      .
  if (0 > shift || shift >= iBarsQ1) return (0); //     .
  else                                           //       ,  .
   {
    iBarsMN1 = iBars (symbol, PERIOD_MN1);       //     MN1  .
    for (i = 0, iBarsQ1 = -1; i < iBarsMN1; i++)
     {
      iTimeMN1 = iTime (symbol, PERIOD_MN1, i);  //    .
      if (i > 0) //       .
       {//   ,       .            (  ).
        if (MathMod (TimeYear (iTimeMN1), TimeYear (iTime (symbol, PERIOD_MN1, i - 1))) != 0)
         {
          Switch_Q1 = true; //       .
          Switch_Q2 = true; //       .
          Switch_Q3 = true; //       .
          Switch_Q4 = true; //       .
         }
       }
      //    .
      switch (TimeMonth (iTimeMN1))
       {//---- 4- .-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        case 12:
        case 11:
        case 10:
         {
          Switch_Q3 = true;      //      3- .
          Switch_Q2 = true;      //      2- .
          Switch_Q1 = true;      //      1- .
          if (Switch_Q4 == true) //   .
           {
            iBarsQ1++;           //   .
            Switch_Q4 = false;   //         .
            break;               //   .
           }
          else continue;         //    ,       .
         }
        //---- 3- .-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        case 9:
        case 8:
        case 7:
         {
          Switch_Q4 = true;      //      4- .
          Switch_Q2 = true;      //      2- .
          Switch_Q1 = true;      //      1- .
          if (Switch_Q3 == true) //   .
           {
            iBarsQ1++;           //   .
            Switch_Q3 = false;   //         .
            break;               //   .
           }
          else continue;         //    ,       .
         }
        //---- 2- .-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        case 6:
        case 5:
        case 4:
         {
          Switch_Q4 = true;      //      4- .
          Switch_Q3 = true;      //      3- .
          Switch_Q1 = true;      //      1- .
          if (Switch_Q2 == true) //   .
           {
            iBarsQ1++;           //   .
            Switch_Q2 = false;   //         .
            break;               //   .
           }
          else continue;         //    ,       .
         }
        //---- 1- .-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        case 3:
        case 2:
        case 1:
         {
          Switch_Q4 = true;      //      4- .
          Switch_Q3 = true;      //      3- .
          Switch_Q2 = true;      //      2- .
          if (Switch_Q1 == true) //   .
           {
            iBarsQ1++;           //   .
            Switch_Q1 = false;   //         .
            break;               //   .
           }
          else continue;         //    ,       .
         }
        //--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
       }
      if (shift == iBarsQ1) return (iClose (symbol, PERIOD_MN1, i)); //    .     .
     }
   }
 }
//
// 8.           .
int Quarter()
 {
  switch (Month())
   {
    case  1:
    case  2:
    case  3: return (1);
    case  4:
    case  5:
    case  6: return (2);
    case  7:
    case  8:
    case  9: return (3);
    case 10:
    case 11:
    case 12: return (4);
   }
 }
//
// 9.      .
int TimeQuarter (datetime time) // ,     ,   00:00 1  1970 .
 {
  switch (TimeMonth (time))
   {
    case  1:
    case  2:
    case  3: return (1);
    case  4:
    case  5:
    case  6: return (2);
    case  7:
    case  8:
    case  9: return (3);
    case 10:
    case 11:
    case 12: return (4);
   }
 }
//

