//+------------------------------------------------------------------+
//|                                                    H_MACD-H+.mqh |
//|                                MCAD- |
//|                 Copyright  2004-2007, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                                 |
//+------------------------------------------------------------------+

string InfoArr[2][5] = {"change from \'up\' to \'down\'", "\'down\'", "\'flat\'"," \'up\'", "change from \'down\' to \'up\'",  
                        "sharply decelerated ","decelerated ","uniformly ","accelerated ", "very accelerated " };

//+------------------------------------------------------------------+
//|                                                   |
//+------------------------------------------------------------------+

//   MASD-

// aPeriod -   
//   -1    , 0  , 1 -  
// aDirection -       
// (-2 -  , -1 -  , 0 - , 1  , 2  )
// aAcceleration -      
// aInfo -      

int AskOsMA(int aTimeframe, int& aDirection, int& aAcceleration, string& aInfo)
{
   // 
   double F0 = iOsMA(NULL, aTimeframe, 12, 26, 9, PRICE_CLOSE, 0);
   double F1 = iOsMA(NULL, aTimeframe, 12, 26, 9, PRICE_CLOSE, 1);
   double F2 = iOsMA(NULL, aTimeframe, 12, 26, 9, PRICE_CLOSE, 2);
   //  
   double V0 = F0 - F1;
   double V1 = F1 - F2;
   //  
   double A0 = V0 - V1;
   //  
   int aSing = 0;
   if (F0>0) aSing = 1;
   if (F0<0) aSing = -1;
   if (MathAbs(F0)<0.000001) V0 = 0; //   
   
   //  / 
   aDirection = 0;
   if ((MathAbs(V0)<0.00001)&&(MathAbs(V1)<0.00001)) aDirection = 0;
   if (V0>0) aDirection = 1;
   if ((V0>0)&&(V1<0)) aDirection = 2; // -  
   if (V0<0) aDirection = -1;
   if ((V0<0)&&(V1>0)) aDirection = -2; // -  
   
   //   
   aAcceleration = 0;
   if (A0>0) aAcceleration = 1;
   if (A0<0) aAcceleration = -1;
   if (MathAbs(A0)<0.00001) aAcceleration = 0;
   if (MathAbs(A0)>0.0002) aAcceleration = aAcceleration * 2;
   
   //   
   aInfo = InfoArr[1][aAcceleration+2] + InfoArr[0][aDirection+2];
   
   return(aSing);
}