//+------------------------------------------------------------------+
//|                                                   PriceAlert.mq4 |
//|                            Copyright  2009,  (api) |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009,  v.1.1"
#property link      ""

#property indicator_chart_window
//---- input parameters
extern color     LineColor=Red;
extern int       LineWidth=2;
extern bool      PopupWindow=true;
extern string    Sound="Alert.wav";
extern string    UniqueName="Price 1";

double LastLevel;
double LastPrice;
double TradePoint;

bool Active;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   LastLevel=0;
   LastPrice=0;
   Active=true;
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
   int reason = UninitializeReason();
   if(UninitializeReason() == REASON_REMOVE) ObjectDelete(UniqueName);
   else ObjectSetText(UniqueName,"Price alert level - Inactive",0);
   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   if(Digits==3 || Digits==5) TradePoint = Point*10;
   else TradePoint = Point;
   string PipsTextName = StringConcatenate(UniqueName," ","Pips");
   if(ObjectFind(UniqueName)==-1)
   {
      double cp = LastLevel;
      if(cp==0) cp = Ask+20*TradePoint;
      ObjectCreate(UniqueName,OBJ_HLINE,0,0,cp);
      ObjectSetText(UniqueName,"Price alert level",0);
      ObjectSet(UniqueName,OBJPROP_COLOR,LineColor);
      ObjectSet(UniqueName,OBJPROP_WIDTH,LineWidth);
   }
   if(ObjectFind(PipsTextName)==-1)
   {
      cp = LastLevel;
      if(cp==0) cp = Ask+20*TradePoint;
      ObjectCreate(PipsTextName,OBJ_TEXT,0,Time[0],cp);
   }
   double newlevel = ObjectGet(UniqueName,OBJPROP_PRICE1);
   ObjectSet(PipsTextName,OBJPROP_TIME1,Time[0]);
   if(Active)
   {
      double Pips = MathAbs(NormalizeDouble(newlevel,Digits)-Bid)/TradePoint;
      if(Digits==3 || Digits==5)
         ObjectSetText(PipsTextName,DoubleToStr(Pips,1),12,"Arial",LineColor);
      else
         ObjectSetText(PipsTextName,DoubleToStr(Pips,0),12,"Arial",LineColor);
   }
   ObjectSet(PipsTextName,OBJPROP_PRICE1,newlevel);
   if(LastLevel!=newlevel)
   {
      LastLevel = newlevel;
      LastPrice=0;
      ObjectSetText(UniqueName,"Price alert level - Active",0);
      Active = true;
   }
   if(Active && LastPrice!=0 && ((LastPrice<LastLevel && Bid>=LastLevel) || (LastPrice>LastLevel && Bid<=LastLevel)))
   {
      if(PopupWindow)
      {
         Alert(Symbol()+" Price alert level triggered at " + DoubleToStr(Bid,Digits) + ". Please activate alert level.");
      }else
         PlaySound(Sound);
      Active = false;
      ObjectSetText(PipsTextName,"",12,"Arial",LineColor);
      ObjectSetText(UniqueName,"Price alert level - Inactive",0);
   }
   LastPrice = Bid;
   return(0);
}
//+------------------------------------------------------------------+