//+------------------------------------------------------------------+
//|                                                      ProjectName |
//|                                      Copyright 2012, CompanyName |
//|                                       http://www.companyname.net |
//+------------------------------------------------------------------+
#property indicator_separate_window //  
#property indicator_buffers 7
#property indicator_color1 Red // 
#property indicator_color6 Blue //    
#property indicator_maximum 1
#property indicator_minimum 0

//  
//--     extern -     
extern int Source=1; // 0 - ; 1 - . ; 2 - ATR; 3 - ; 
int ApplPrice=0; // 0 - Close; 4 - (high+low)/2; 5 - (high+low+close)/3; 6 - (high+low+close+close)/4;
extern int SourcePeriod=88; //   
int Shift=0; // 
bool MAtypeI=1; // 0 - SMA, 1 - EMA
int PrePeriod=1; //    ,  -  MA  MACD
bool MAtypeP=1; // 0 - SMA, 1 - EMA
extern int Window=111; //   
int WindowLimit=0; //     
int WindowShift=0; //   
bool WindowMethod=0; // 0 -    , 1 - 
extern double Sensitivity=0; // 
bool abs=1; //    NP[]    .
bool ToRange=1; //   . 0...1;     WindowShift>0
double Power=1; //   
extern int Signal=55; //    ()
bool MAtypeS=1; // 0 - SMA, 1 - EMA
int SignalShift=0; //  
int History=0;

//  
double Ind[],//  
PR[],// 
NORM[],//  
SM[],// 
Input[],//     (  )
MA[], //   
NP[], //    -     -  
SIGN[]; //   -  MA

double sens,//    /
sensLimit,//  
sn,
IndPeriodK, // . EMA  
PrePeriodK, // . EMA  
SignalK; // . EMA  
bool Em=0; //     MA
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//int WindowLimit; //    

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   switch(Source)
     {
      case 0: // 
         SetIndexStyle(2,DRAW_LINE,0,1,LimeGreen);
         string ShortName="Volume(";
         double punkt=1;
         WindowShift++;
         break;
      case 3: // 
         SetIndexStyle(2,DRAW_LINE,0,1,LightSeaGreen);
         ShortName="MA(";
         WindowMethod=1; //     
         punkt=Point;
         break;
      case 2: // .
         SetIndexStyle(2,DRAW_LINE,0,1,MediumSeaGreen);
         ShortName="StDev(";
         punkt=Point;
         break;
      case 1: //ATR
         SetIndexStyle(2,DRAW_LINE,0,1,DodgerBlue);
         ShortName="ATR(";
         punkt=Point;
     }
   if(WindowMethod)
     {
      if(WindowLimit==0) WindowLimit=Window*10; //    
      else WindowLimit=MathMax(WindowLimit,Window);
     }
   ShortName=ShortName+_Price()+SourcePeriod;
   if(Shift>0) ShortName=ShortName+"+"+Shift;
   ShortName=ShortName+") ";
   if(PrePeriod>1) ShortName=ShortName+PrePeriod+" ";
   ShortName=ShortName+"["+Window;
   if(WindowMethod && Sensitivity>0) ShortName=ShortName+"_"+WindowLimit;
   if(WindowShift>0) ShortName=ShortName+"+"+WindowShift;
   if(Sensitivity>0) ShortName=ShortName+"@"+DoubleToStr(Sensitivity,1);
   ShortName=ShortName+"]";
   if(Power!=1) ShortName=ShortName+"^"+DoubleToStr(Power,1);
   if(Signal>1 || SignalShift>0)
     {
      ShortName=ShortName+" ("+Signal;
      if(SignalShift>0) ShortName=ShortName+"+"+SignalShift;
      ShortName=ShortName+")";
     }
   IndicatorShortName(ShortName); //     

//---- indicators
   SetIndexBuffer(0,SM); // 
   SetIndexStyle(0,DRAW_LINE);
   SetIndexLabel(0,"Signal");

   SetIndexBuffer(1,Ind); // 
   SetIndexStyle(1,DRAW_NONE);
   SetIndexLabel(1,NULL);

   SetIndexBuffer(2,NORM); //  
   SetIndexLabel(2,"Normed");

   SetIndexBuffer(3,MA); // MA 
   SetIndexStyle(3,DRAW_NONE);
   SetIndexLabel(3,NULL);

   SetIndexBuffer(4,Input); //    (  )
   SetIndexStyle(4,DRAW_NONE);
   SetIndexLabel(4,NULL);

   SetIndexBuffer(5,NP); //      ..
   if(Source==-3 && Sensitivity>0) //    
     {
      SetIndexStyle(5,DRAW_HISTOGRAM);
      Source=-Source;
     }
   else SetIndexStyle(5,DRAW_NONE);

   if(Source==3 && Sensitivity>0) SetIndexLabel(5,"Window");
   else SetIndexLabel(5,NULL);
   if(abs) SetIndexLabel(5,"NormSign");
   else SetIndexLabel(5,NULL);

   SetIndexBuffer(6,PR); //    (  )
   SetIndexStyle(6,DRAW_NONE);
   SetIndexLabel(6,"Source");

//----
   sensLimit=punkt/1000; //  
   sens=MathMax(Sensitivity*punkt,sensLimit); //    

   if(WindowMethod) sn=sensLimit; //   
   else sn=sens;

   if(SourcePeriod<0) {MAtypeI=0; SourcePeriod=-SourcePeriod;} // SMA
   else IndPeriodK=2.0/(SourcePeriod+1); // EMA

   if(PrePeriod<0) {MAtypeP=0; PrePeriod=-PrePeriod;} // SMA
   else PrePeriodK=2.0/(PrePeriod+1); // EMA

   if(Signal<0) {MAtypeS=0; Signal=-Signal;} // SMA
   else SignalK=2.0/(Signal+1); // EMA

   if(Source==0 || Source==1) Em=1; //     MA

   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   if(Em) EmBuff();
   //int ic=IndicatorCounted();
   //if(Bars-ic-1>1) {ic=reinit();}
   //int limit=Bars-ic-1; //BarsPrev=Bars; // - 
   //if(History!=0 && limit>History) limit=History-1; // -   

   int counted_bars=IndicatorCounted();
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   int limit=Bars-counted_bars;
   if(counted_bars==0) limit-=1+5;

   for(int i=limit; i>=0; i--) //      
     {
      double ma;
      int n;
      int iShift=i+Shift;
      if(Em)
        { //  
         if(MAtypeI) // EMA
            SIGN[i]=IndPeriodK*Price(4,iShift)+(1-IndPeriodK)*SIGN[i+1];
         else
           { // SMA
            int sh=iShift+SourcePeriod;
            ma=SIGN[i+1]*SourcePeriod-Price(4,sh);
            SIGN[i]=(ma+Close[iShift])/SourcePeriod;
           }
        }

      //  
      switch(Source)
        {
         case 0: // 
            Input[i]=Volume[iShift]; break;
         case 3: // 
            Input[i]=Price(ApplPrice,iShift); break;
         case 2:
            Input[i]=Price(ApplPrice,iShift); break;
         case 1: // ATR
            Input[i]=MathMax(High[iShift],Close[iShift+1])-MathMin(Low[iShift],Close[iShift+1]);
        }

      // MA
      if(MAtypeI)
        { // EMA
         MA[i]=IndPeriodK*Input[i]+(1-IndPeriodK)*MA[i+1];
         ma=MA[i];
        }
      else
        { // SMA
         sh=i+SourcePeriod;
         ma=MA[i+1]*SourcePeriod-Input[sh];
         MA[i]=(ma+Input[i])/SourcePeriod;
         ma=MA[i];
        }

      // .
      if(Source==2) //  
        {
         double std=0;
         for(n=0; n<SourcePeriod; n++)
           {
            double delta=Input[i+n]-ma;
            std+=delta*delta;  //  SourcePeriod(Price)
           }
         Ind[i]=MathSqrt(std/SourcePeriod);
         //
         if(PrePeriod==1) PR[i]=Ind[i];
         else
         if(MAtypeP)
            PR[i]=PrePeriodK*Ind[i]+(1-PrePeriodK)*PR[i+1];
         else
           {
            sh=i+PrePeriod;
            ma=PR[i+1]*PrePeriod-Ind[sh];
            PR[i]=(ma+Ind[i])/PrePeriod;
           }
        }
      else // MA (  )
      if(PrePeriod==1) PR[i]=MA[i];
      else
        {
         if(MAtypeP)
            Ind[i]=PrePeriodK*Input[i]+(1-PrePeriodK)*Ind[i+1];
         else
           {
            sh=i+PrePeriod;
            ma=PR[i+1]*PrePeriod-Input[sh];
            Ind[i]=(ma+Input[i])/PrePeriod;
           }
         PR[i]=MA[i]-Ind[i];
         if(abs) PR[i]=MathAbs(PR[i]);
        }

      // 
      double max=PR[ArrayMaximum(PR,Window,i+WindowShift)];
      double min=PR[ArrayMinimum(PR,Window,i+WindowShift)];
      if(WindowMethod)
         for(n=Window; max-min<sens && n<=WindowLimit; n++)
           {
            int in=i+n+WindowShift;
            max=MathMax(max,PR[in]);
            min=MathMin(min,PR[in]);
           }
      double x=(PR[i]-min)/MathMax((max-min),sn);
      if(Power!=1 && Power>0) x=MathPow(x,Power);
      NORM[i]=x;

      if(ToRange) //       .0...1
        {NORM[i]=MathMax(NORM[i],0); NORM[i]=MathMin(NORM[i],1);}

      if(abs) //     
         if(Em) //    ATR
           {if(Close[i]>SIGN[i+3]) NP[i]=NORM[i]; else NP[i]=-NORM[i];}
      else //  ..
        {if(Close[i]>MA[i+3]) NP[i]=NORM[i]; else NP[i]=-NORM[i];}

      //  .
      if(Signal==1) SM[i]=NORM[i+SignalShift];
      else
      if(MAtypeS) // EMA
      SM[i]=SignalK*NORM[i+SignalShift]+(1-SignalK)*SM[i+1];
      else
        { // SMA
         sh=i+SignalShift+Signal;
         ma=SM[i+1]*Signal-NORM[sh];
         SM[i]=(ma+NORM[i+SignalShift])/Signal;
        }
     }
//----
   return(0);
  }
//----------------------------------------------------  
// -  
int reinit()
  {
   ArrayInitialize(Input,0.0);
   ArrayInitialize(Ind,0.0);
   ArrayInitialize(PR,0.0);
   ArrayInitialize(NORM,0.0);
   ArrayInitialize(SM,0.0);
   ArrayInitialize(MA,0.0);
   ArrayInitialize(NP,0.0);
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double Price(int ApplPrice,int i)
  {
   switch(ApplPrice)
     {
      case 0: return(Close[i]);
      case 1: return(Open[i]);
      case 2: return(High[i]);
      case 3: return(Low[i]);
      case 4: return((High[i]+Low[i])/2);
      case 5: return((High[i]+Low[i]+Close[i])/3);
      case 6: return((High[i]+Low[i]+2*Close[i])/4);
      default: return(Close[i]);
     }
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
string _Price()
  {
   switch(ApplPrice)
     {
      case 0: return("");
      case 1: return("O");
      case 2: return("H");
      case 3: return("L");
      case 4: return("M");
      case 5: return("T");
      case 6: return("W");
      default: return("");
     }
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void EmBuff()
  {
   static int NewSize;
   if(NewSize==Bars) return;
   NewSize=Bars;
   ArraySetAsSeries(SIGN,0); ArrayResize(SIGN,NewSize); ArraySetAsSeries(SIGN,1);
  }

//+------------------------------------------------------------------+
