//+------------------------------------------------------------------+
//|                               Fourier_extrapolator_4th_cycle.mq4 |
//|                                      aka neoclassic |
//|                               af_FT, af_LR - ANG3100 |
//+------------------------------------------------------------------+
#property copyright " "

#property indicator_chart_window
#property indicator_buffers 8

extern int Tstart=1000;
extern int shift=0;
extern bool delete=true;

int Tmin=60;
int bars=0;
int flagdrow=1;
int Ti;
int TLR;

double aa,bb,w;
double pi=3.1415926535897932384626433832795;
double ak0,ak[],bk[],spectr[],prognoz[];
double profit[];



int deinit()
  {
if (delete==true) 
{
   for (int i=Tstart/3;i>20;i--)
   {  
      for (int k=Tstart*4/3;k>=0;k--)
      {
         ObjectDelete("sinus_"+shift+"_"+i+"_"+k);
      }
   }
}
   return(0);
  }



int start()
  {
int T=Tstart;
if ((T+shift)>Bars) T=Bars-shift;
   
   
if (bars==0)
{

SetIndexStyle(0,DRAW_NONE);
SetIndexBuffer(0, prognoz);
SetIndexStyle(1,DRAW_NONE);
SetIndexBuffer(1, ak);
SetIndexStyle(2,DRAW_NONE);
SetIndexBuffer(2, bk);
SetIndexStyle(3,DRAW_NONE);
SetIndexBuffer(3, spectr);

int count=0;

double h3[],ak3[],bk3[],aabuf[],bbbuf[],ak0buf[]; int Tbuf[]; 

ArrayInitialize(prognoz,EMPTY_VALUE);


ArrayResize(h3,T/3);
ArrayResize(ak3,T/3);
ArrayResize(bk3,T/3);
ArrayResize(aabuf,T/3);
ArrayResize(bbbuf,T/3);
ArrayResize(ak0buf,T/3);
ArrayResize(Tbuf,T/3);

ArrayInitialize(h3,0.0);
ArrayInitialize(ak3,0.0);
ArrayInitialize(bk3,0.0);
ArrayInitialize(aabuf,0.0);
ArrayInitialize(bbbuf,0.0);
ArrayInitialize(ak0buf,0.0);
ArrayInitialize(Tbuf,0.0);


while (T>=Tmin)
{
   ArrayInitialize(ak,EMPTY_VALUE);
   ArrayInitialize(bk,EMPTY_VALUE);
   ArrayInitialize(spectr,0.0);
   SetIndexShift(0,TLR-shift);
   SetIndexShift(4,TLR-shift);

   
   Ti=T+1;
   af_LR(Ti,shift);
   w=2*pi/Ti;
   af_FT(Ti,shift);
      
   for (int i=2;i<6;i++) {spectr[i]=MathPow(ak[i]*ak[i]+bk[i]*bk[i],0.5)/2;}   
   
   if (ArrayMaximum(spectr)==3)
   {
      h3[count]=spectr[3];
      ak3[count]=ak[3];
      bk3[count]=bk[3];
      Tbuf[count]=T;
      aabuf[count]=aa; bbbuf[count]=bb; ak0buf[count]=ak0;
      count++;

   }
   
   if (ArrayMaximum(spectr)!=3 && count!=0)
   {
   
      count=0;
      int amax=ArrayMaximum(h3);
      w=2*pi/(Tbuf[amax]+1);
      
      double delta=Close[shift]-(ak3[amax]*MathCos(3*Tbuf[amax]/3*w)+bk3[amax]*MathSin(3*Tbuf[amax]/3*w)+
                                bbbuf[amax]+aabuf[amax]*(Tbuf[amax]/3-Tbuf[amax]*4/3)+ak0buf[amax]);

      for (i=Tbuf[amax]*4/3;i>=0;i--)
      {
         
         double p1=ak3[amax]*MathCos(3*i*w)+bk3[amax]*MathSin(3*i*w)+
                bbbuf[amax]+aabuf[amax]*(i-Tbuf[amax]*4/3)+ak0buf[amax]+delta;
         
         double p2=ak3[amax]*MathCos(3*(i-1)*w)+bk3[amax]*MathSin(3*(i-1)*w)+
                bbbuf[amax]+aabuf[amax]*(i-1-Tbuf[amax]*4/3)+ak0buf[amax]+delta;
         
         if ((shift+Tbuf[amax])>(Tbuf[amax]*4/3-i))
         {ObjectCreate("sinus_"+shift+"_"+Tbuf[amax]/3+"_"+i,OBJ_TREND,0,Time[shift+i-Tbuf[amax]/3],p1,Time[shift+i-Tbuf[amax]/3-1],p2);}
         else {ObjectCreate("sinus_"+shift+"_"+Tbuf[amax]/3+"_"+i,OBJ_TREND,0,Time[0]-Period()*60*(shift-Tbuf[amax]/3+i),p1,Time[0]-Period()*60*(shift-Tbuf[amax]/3+i-1),p2);}
         ObjectSet("sinus_"+shift+"_"+Tbuf[amax]/3+"_"+i,OBJPROP_RAY,0);
         ObjectSet("sinus_"+shift+"_"+Tbuf[amax]/3+"_"+i,OBJPROP_COLOR,DarkOrange);
         
      }
         ArrayInitialize(h3,0.0);
         ArrayInitialize(ak3,0.0);
         ArrayInitialize(bk3,0.0);
         ArrayInitialize(Tbuf,0.0);

   }
T=T-(T+1000)/1000;
}


bars=Bars;
}
return(0);
}


//*******************************************************************
void af_FT(int T,int i0)
{
   int i,k;
   double sum_cos,sum_sin,dci; 
   
   ak0=0.0; 
   for (i=0; i<T; i++) ak0+=Close[i+i0]-bb-aa*i; 
   ak0=ak0/T; 

   for (k=1; k<=6; k++) 
   { 
      sum_cos=0.0; 
      sum_sin=0.0;  
      for (i=0; i<T; i++) 
      {
         dci=Close[i+i0]-bb-aa*i;
         sum_cos+=dci*MathCos(k*i*w); 
         sum_sin+=dci*MathSin(k*i*w);
      }
      ak[k]=sum_cos*2/T; 
      bk[k]=sum_sin*2/T; 
   }
}

//*******************************************************************
void af_LR(int p,int i) // af_LR(Ti,i0)
{ 
   double sx=0,sy=0,sxy=0,sxx=0;
   
   if (p<2) p=2;
   for (int n=0; n<p; n++) 
   {
      sx+=n; 
      sy+=Close[n+i]; 
      sxy+=n*Close[n+i]; 
      sxx+=n*n; 
   }   
   aa=(sx*sy-p*sxy)/(sx*sx-p*sxx);
   bb=(sy-aa*sx)/p;
}

