//+------------------------------------------------------------------+
//|                                              3in1_ST_RSI_CCI.mq4 |
//|                                            Copyright  2009, BB. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property  copyright "Copyright  2007,    BB"
#property  link      "http://www.metaquotes.net/"
//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 3
#property  indicator_color1  Red
#property  indicator_color2  Green
#property  indicator_color3  Brown
#property indicator_level1 0
#property indicator_levelcolor Gray
//#property  indicator_width1  2
//---- indicator parameters
extern double weight_cci=0.1; // from 0 to 1
extern double weight_rsi=0.1; // from 0 to 1
extern int CCI = 21; // period
extern int RSI = 21; // period
extern int St_K=24; // Stochastic %K
extern int St_S=10; // Stochastic %K
extern int FastMA=3;
extern int SlowMA=7;
//---- indicator buffers
double     SumBuffer[];
double     FastMABuffer[];
double     SlowMABuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- drawing settings
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexStyle(2,DRAW_LINE);   
   SetIndexDrawBegin(1,SlowMA);
//---- indicator buffers mapping
   SetIndexBuffer(0,SumBuffer);
   SetIndexBuffer(1,FastMABuffer);
   SetIndexBuffer(2,SlowMABuffer);
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName(WindowExpertName());
   SetIndexLabel(0,WindowExpertName());
   SetIndexLabel(1,"Fast MA");
   SetIndexLabel(2,"Slow MA");
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
int start()
  {
   int limit;
   int counted_bars=IndicatorCounted();
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
//---- DeMarker counted in the 1-st buffer

   for(int i=0; i<limit; i++)
   {
      double rsi = iRSI(Symbol(),0,RSI,PRICE_TYPICAL,i)-50;
      double cci = iCCI(Symbol(),0,CCI,PRICE_TYPICAL,i);
      double St = iStochastic(NULL, 0, St_K, 3, St_S,  0, NULL, MODE_MAIN, i) - 50; 
      SumBuffer[i] = St*(1-weight_cci-weight_rsi) + rsi * weight_rsi + cci * weight_cci;
   }  
//---- signal line counted in the 2-nd buffer
   for(i=0; i<limit; i++)
    {  
      FastMABuffer[i]=iMAOnArray(SumBuffer,Bars,FastMA,0,MODE_LWMA,i);
      SlowMABuffer[i]=iMAOnArray(SumBuffer,Bars,SlowMA,0,MODE_LWMA,i);
    } 
//---- done
   return(0);
  }
//+------------------------------------------------------------------+