//+------------------------------------------------------------------+
//|                                                    AO-AC(AM).mq4 |
//|                                               Andrey Matvievskiy |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Andrey Matvievskiy"
#property link      ""

//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 7
#property  indicator_color1  Black
#property  indicator_color2  Black
#property  indicator_color3  Teal
#property  indicator_color4  Red
#property  indicator_color5  Teal
#property  indicator_color6  Red
#property  indicator_color7  Black

extern int AO_Period1 = 34;
extern int AO_Period2 = 5;
extern int AC_Period  = 5;

extern int AO_Mode1 = 0;
extern int AO_Mode2 = 0;
extern int AC_Mode  = 0;

extern int AO_Price1 = 4;
extern int AO_Price2 = 4;

extern int TF=0;
//---- indicator buffers
double     ExtBuffer0[];
double     ExtBuffer1[];
double     ExtBuffer2[];
double     ExtBuffer3[];
double     ExtBuffer4[];
double     ExtBuffer5[];
double     ExtBuffer6[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- 2 additional buffers are used for counting.
   IndicatorBuffers(7);
//---- drawing settings

   SetIndexStyle(0,DRAW_NONE);
   SetIndexStyle(1,DRAW_NONE);
   SetIndexStyle(2,DRAW_HISTOGRAM,0,2);
   SetIndexStyle(3,DRAW_HISTOGRAM,0,2);
   SetIndexStyle(4,DRAW_HISTOGRAM,0,1);
   SetIndexStyle(5,DRAW_HISTOGRAM,0,1);
   SetIndexStyle(6,DRAW_NONE);
   IndicatorDigits(Digits+2);

//---- 4 indicator buffers mapping
   SetIndexBuffer(0,ExtBuffer0);
   SetIndexBuffer(1,ExtBuffer1);
   SetIndexBuffer(2,ExtBuffer2);
   SetIndexBuffer(3,ExtBuffer3);
   SetIndexBuffer(4,ExtBuffer4);
   SetIndexBuffer(5,ExtBuffer5);
   SetIndexBuffer(6,ExtBuffer6);

//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("AO_AC (AM) (TF "+TF+")");

   SetIndexLabel(0,NULL);
   SetIndexLabel(1,NULL);

   SetIndexLabel(2,"AC+");
   SetIndexLabel(3,"AC-");
   SetIndexLabel(4,"AO+");
   SetIndexLabel(5,"AO-");

   SetIndexLabel(6,NULL);
   SetIndexLabel(7,NULL);

//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Accelerator/Decelerator Oscillator                               |
//+------------------------------------------------------------------+
int start()
  {
   double prev1,current1,prev2,current2; 
   int counted_bars = IndicatorCounted();
   if(counted_bars < 0)  return(-1);
   if(counted_bars > 0)   counted_bars--;
   int limit = Bars - counted_bars;
   if(counted_bars==0) limit-=2;   

   for(int i=0; i<limit; i++)
      ExtBuffer0[i]=iMA(NULL,TF,AO_Period2,0,AO_Mode2,AO_Price2,i)-iMA(NULL,TF,AO_Period1,0,AO_Mode1,AO_Price1,i);
   for(i=0; i<limit; i++)
      ExtBuffer1[i]=iMAOnArray(ExtBuffer0,Bars,AC_Period,0,AC_Mode,i);
   bool up1=true;
   bool up2=true;
   for(i=limit-1; i>=0; i--)
     {
      current1=ExtBuffer0[i];
      prev1=ExtBuffer0[i+1];
      if(current1>prev1) up1=true;
      if(current1<prev1) up1=false;
      if(!up1)
        {
         ExtBuffer5[i]=current1;
         ExtBuffer4[i]=0.0;
        }
      else
        {
         ExtBuffer4[i]=current1;
         ExtBuffer5[i]=0.0;
        }
      current2=ExtBuffer0[i]-ExtBuffer1[i];
      prev2=ExtBuffer0[i+1]-ExtBuffer1[i+1];
      if(current2>prev2) up2=true;
      if(current2<prev2) up2=false;
      if(!up2)
        {
         ExtBuffer3[i]=current2;
         ExtBuffer2[i]=0.0;
        }
      else
        {
         ExtBuffer2[i]=current2;
         ExtBuffer3[i]=0.0;
        }
      ExtBuffer6[i]=current2;
     }

//---- done
   return(0);
  }
//+------------------------------------------------------------------+
