#property show_inputs
#property copyright "expforex"
#property link      "http://expforex.at.ua"
//+------------------------------------------------------------------+
//| EX4 imports                                                      |
//+------------------------------------------------------------------+
#include <stdlib.mqh>
//+------------------------------------------------------------------+
//| global variables to program:                                     |
//+------------------------------------------------------------------+
double Price[2];
int    giSlippage;
bool   CloseOpenOrders = true;extern bool AllSymbols=true;
//+------------------------------------------------------------------+
//| script program start function                                    |
//+------------------------------------------------------------------+

void init()
{

Stamp();
start();
}
void start() {
  int iOrders=OrdersTotal()-1, i;
  if (AllSymbols==true){  
  if(CloseOpenOrders) {
    for(i=iOrders; i>=0; i--) {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES) && (OrderType()==OP_SELLSTOP)  && !OrderDelete(OrderTicket())) Print(OrderError());
    }
  }}
  
  
  
    if (AllSymbols==false){  
  if(CloseOpenOrders) {
    for(i=iOrders; i>=0; i--) {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)){
       if( OrderSymbol()!=Symbol())continue;
      if( OrderSymbol()==Symbol() && (OrderType()==OP_SELLSTOP)  && !OrderDelete(OrderTicket())) Print(OrderError());}
    }
  }}
  
  
  
  
}
//+------------------------------------------------------------------+
//| Function..: OrderError                                           |
//+------------------------------------------------------------------+
string OrderError() {
  int iError=GetLastError();
  return(StringConcatenate("Order:",OrderTicket()," GetLastError()=",iError," ",ErrorDescription(iError)));
}
//+------------------------------------------------------------------+
//| Function..: GetMarketInfo                                        |
//+------------------------------------------------------------------+
bool GetMarketInfo() {
  RefreshRates();
  Price[0]=MarketInfo(OrderSymbol(),MODE_ASK);
  Price[1]=MarketInfo(OrderSymbol(),MODE_BID);
  double dPoint=MarketInfo(OrderSymbol(),MODE_POINT);
  if(dPoint==0) return(false);
  giSlippage=(Price[0]-Price[1])/dPoint;
  return(Price[0]>0.0 && Price[1]>0.0);
}
//+------------------------------------------------------------------+

void Stamp(){

   ObjectCreate("Original", OBJ_LABEL, 0, 0, 0);
   ObjectSetText("Original", " ---http://Expforex.at.ua---", 10, "Arial Bold", Red);
   ObjectSet("Original", OBJPROP_CORNER, 2);
   ObjectSet("Original", OBJPROP_XDISTANCE, 200);
   ObjectSet("Original", OBJPROP_YDISTANCE, 10);


}