//+------------------------------------------------------------------+
//|                                            MorninFlat_Expert.mq4 |
//|                                                        Scriptong |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Scriptong"
#property link      ""

//---- input parameters
extern double    Lots        = 0.1;
extern int       StartHour   = 0;
extern int       EndHour     = 8;
extern double    TargetLevel = 200;
extern int       MagicNumber = 17589 ;

bool Activate, FreeMarginAlert;
double Tick, Spread, StopLevel, MinLot, MaxLot, LotStep;
double FUp, FDn;   //    (FUp -  , FDn -  )
int NUp, NDn;
datetime LastBar, LastBuyBar, LastSellBar, EuroLast, FrancLast;
int CurTrend, EuroTrend, FrancTrend;  //    (0 -  , 1 - , 2 - )
double EuroLowV, EuroHighV, EuroTargetU, EuroTargetD, FrancLowV, FrancHighV, FrancTargetU, FrancTargetD;

//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//----
   Activate = False;
   Tick = MarketInfo(Symbol(), MODE_TICKSIZE);
   Spread = ND(MarketInfo(Symbol(), MODE_SPREAD)*Point);
   StopLevel = ND(MarketInfo(Symbol(), MODE_STOPLEVEL)*Point+Tick);  
   MinLot = MarketInfo(Symbol(), MODE_MINLOT);
   MaxLot = MarketInfo(Symbol(), MODE_MAXLOT);
   LotStep = MarketInfo(Symbol(), MODE_LOTSTEP);

   //    
   if(Lots < MinLot || Lots > MaxLot)
     {
      Comment(" Lots     !  !");
      return(0);
     }
   Lots = MathRound(Lots/LotStep)*LotStep;

   if(StartHour < 0 || EndHour < 0 || StartHour > 23 || EndHour > 23 || StartHour >= EndHour)
     {
      Comment(" StartHour  EndHour      0  24  StartHour < EndHour.");
      return(0);
     } 
     
   LastBar = 0;
   LastBuyBar = 0;
   LastSellBar = 0;
   EuroLast = 0;
   FrancLast = 0;
   Activate = True;
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   Comment("");
//----
   return(0);
  }
  
//+------------------------------------------------------------------+
//|                             |
//+------------------------------------------------------------------+
double ND(double A)
{
 return(NormalizeDouble(A, Digits));
}  
  
//+------------------------------------------------------------------+
//|                                                   |
//| :                                                      |
//|   True -                                    |
//|   False -                                          |
//+------------------------------------------------------------------+
bool OpenOrder(int Type, double Price, double SL, double TP)
{
 //     
 if(AccountFreeMarginCheck(Symbol(), OP_BUY, Lots) <= 0 || GetLastError() == 134)
  {
   if(!FreeMarginAlert)
    {
     Print("    . Free Margin = ", AccountFreeMargin());
     FreeMarginAlert = True;
    } 
   return;  
  }
 FreeMarginAlert = False;  
 // ---------------------------------------------

 if(Type == OP_BUY)
   string S = "BUY";
  else
   S = "SELL"; 
 int ticket=OrderSend(Symbol(), Type, Lots, ND(Price), 3, SL, TP, NULL, MagicNumber, 0, CLR_NONE);
 if(ticket<0)
   {
    Print("   ", S, ": ",GetLastError()); 
    return(False);
   } 
 return(True); 
}   


//+----------------------------------------------------------------------------------------------------------------------+
//|     Type.        ,  False  |
//+----------------------------------------------------------------------------------------------------------------------+
bool CheckOrders(int Type)
{
 for(int i = OrdersTotal()-1; i >= 0; i--)
   if(OrderSelect(i, SELECT_BY_POS))
     if(OrderSymbol() == Symbol() && OrderMagicNumber() == MagicNumber && OrderType() < 2) 
       if(OrderType() == Type)
         {
          if(Type == OP_BUY)
            double Pr = ND(Bid);
           else
            Pr = ND(Ask); 
          if(!OrderClose(OrderTicket(), OrderLots(), Pr, 3))
            return(False);
           else
             RefreshRates();
         }
        else
         {
          if (OrderType() == OP_BUY)
            LastBuyBar = iTime(Symbol(), PERIOD_D1, 0);
           else
            LastSellBar = iTime(Symbol(), PERIOD_D1, 0); 
          return(False); 
         } 
 return(True);        
}
 
//+----------------------------------+
//|     .  |
//+----------------------------------+ 
void CheckBit(string Pair, double& LowV, double& HighV, double& TargetU, double& TargetD, int& Trend)
{
  datetime BeginDay = iTime(Pair, PERIOD_D1, 0);  //    
  int StartBar = iBarShift(Pair, PERIOD_H1, BeginDay+StartHour*3600);   // ,       
  int FinishBar = iBarShift(Pair, PERIOD_H1, BeginDay+(EndHour-1)*3600); // ,    " "
  LowV = iLow(Pair, PERIOD_H1, iLowest(Pair, PERIOD_H1, MODE_LOW, StartBar-FinishBar+1, FinishBar));  //  
  HighV = iHigh(Pair, PERIOD_H1, iHighest(Pair, PERIOD_H1, MODE_HIGH, StartBar-FinishBar+1, FinishBar)); //  
  TargetU = (HighV-LowV)*(TargetLevel-100)/100+HighV;
  TargetD = LowV-(HighV-LowV)*(TargetLevel-100)/100;
  // ------------------------
  
  //    
  Trend = 0;
        //   
        int FinishBarM1 = iBarShift(Pair, PERIOD_M1, BeginDay+EndHour*3600);   //   1,    EndHour
        for(int i = 0; i < FinishBarM1; i++)
          {
           if(iHigh(Pair, PERIOD_M1, i) > HighV)
             {
              Trend = 1;
              break;
             }
           if(iLow(Pair, PERIOD_M1, i) < LowV)
             {
              Trend = 2;
              break;
             }
          }
        // ---------------------  
}    
 
 
//+------------------------------+
//|   .  |
//+------------------------------+ 
void CheckLevels()
{
  //    
  if (EuroLast < iTime("EURUSD", PERIOD_D1, 0))
    {
     EuroTrend = 0;
     CheckBit("EURUSD", EuroLowV, EuroHighV, EuroTargetU, EuroTargetD, EuroTrend);
     EuroLast = iTime("EURUSD", PERIOD_D1, 0);
    }
   else
     if (iATR("EURUSD", PERIOD_D1, 24, 1) > 2*(EuroHighV - EuroLowV))
       {
        if (Symbol() == "EURUSD")
          double Price = ND(Bid);
        else
          Price = ND(iClose("EURUSD", PERIOD_M1, 1));
        if (Price > EuroHighV)
           EuroTrend = 1;
        if (Price < EuroLowV)
           EuroTrend = 2;     
       } 
      else
       EuroTrend = 0; 
  // -------------------------
  
  //    
  if (FrancLast < iTime("USDCHF", PERIOD_D1, 0))
    {
     FrancTrend = 0;
     CheckBit("USDCHF", FrancLowV, FrancHighV, FrancTargetU, FrancTargetD,  FrancTrend);
     FrancLast = iTime("USDCHF", PERIOD_D1, 0);
    } 
   else
     if (iATR("USDCHF", PERIOD_D1, 24, 1) > 2*(FrancHighV - FrancLowV))
       { 
        if (Symbol() == "USDCHF")
          Price = ND(Bid);
         else
          Price = ND(iClose("USDCHF", PERIOD_M1, 1));
        if (Price > FrancHighV)
          FrancTrend = 1;
        if (Price < FrancLowV)
          FrancTrend = 2;     
       }  
  // --------------------------
  
  CurTrend = 0;
  if(EuroTrend > 0 && FrancTrend > 0)
    {
     if(EuroTrend == 1 && FrancTrend == 2)
       {
        if(Symbol() == "EURUSD")
          CurTrend = 1;
        if(Symbol() == "USDCHF")  
          CurTrend = 2;
       }   
     if(EuroTrend == 2 && FrancTrend == 1)
       {
        if(Symbol() == "EURUSD")
          CurTrend = 2;
        if(Symbol() == "USDCHF")  
          CurTrend = 1;
       }   
    }
}

//+--------------------------------------------------------+
//|      .            |
//+--------------------------------------------------------+ 
void CheckBreakEven()
{
 for (int i = OrdersTotal()-1; i >= 0; i--)
   if (OrderSelect(i, SELECT_BY_POS))
     if (OrderSymbol() == Symbol() && OrderMagicNumber() == MagicNumber)
       {
        //   
           double Price = 0;
            //  
           if (Symbol() == "EURUSD")
             {
              if (EuroTargetD == 0)
                return;
              if (OrderType() == OP_BUY)
                {
                 if (ND(Bid - EuroTargetU) >= 0)
                   {
                    Price = ND(EuroHighV+Tick);
                    if (ND(Price - OrderOpenPrice() - Tick) < 0)
                      Price = ND(OrderOpenPrice() + Tick);
                    if (ND(Bid - Price - StopLevel) <= 0 || ND(Price-OrderStopLoss()) <= 0)  
                      Price = 0;
                   } 
                }
               else
                if (ND(EuroTargetD - Bid) >= 0)
                  {
                   Price = ND(EuroLowV-Tick);
                   if (ND(Price - OrderOpenPrice() + Tick) > 0)
                     Price = ND(OrderOpenPrice() - Tick);
                   if (ND(Price - StopLevel - Ask) <= 0 || ND(OrderStopLoss() - Price) <= 0)  
                     Price = 0;
                  } 
             }      
            // --------------
            
            //   
           if (Symbol() == "USDCHF")
             {
              if (FrancTargetD == 0)
                return;
              if (OrderType() == OP_BUY)
                {
                 if (ND(Bid - FrancTargetU) >= 0)
                   {
                    Price = ND(FrancHighV+Tick);
                    if (ND(Price - OrderOpenPrice() - Tick) < 0)
                      Price = ND(OrderOpenPrice() + Tick);
                    if (ND(Bid - Price - StopLevel) <= 0 || ND(Price-OrderStopLoss()) <= 0)  
                      Price = 0;
                   }   
                }
               else
                if (ND(FrancTargetD - Bid) >= 0)
                  {
                   Price = ND(FrancLowV-Tick);
                   if (ND(Price - OrderOpenPrice() + Tick) > 0)
                     Price = ND(OrderOpenPrice() - Tick);
                   if (ND(Price - StopLevel - Ask) <= 0 || ND(OrderStopLoss() - Price) <= 0)  
                     Price = 0;
                  }   
             }  
            // ------------
        // ----------------------------------  
      
        //  
        if (Price != 0)     
           OrderModify(OrderTicket(), 0, Price, 0, 0);
        return;
        // ---------------------------  
       }
}  
  
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
//----
   if(!Activate)
     return(0);

   CheckBreakEven();

   if(Hour() < EndHour)
     return(0);
     
   CheckLevels();
   
   if(CurTrend == 1)  
     if(CheckOrders(OP_SELL))
       if (LastBuyBar < iTime(Symbol(), PERIOD_D1, 0))
         {
          if(Symbol() == "EURUSD")
            {
             double TP = ND(EuroTargetU);
             double SL = ND(EuroTargetD);
            } 
           else
            {
             TP = ND(FrancTargetU); 
             SL = ND(FrancTargetD);
            } 
          if(ND(TP - Ask - StopLevel) > 0 && ND(Bid - SL - StopLevel) > 0)
            if (OpenOrder(OP_BUY, Ask, SL, 0))
              LastBuyBar = iTime(Symbol(), PERIOD_D1, 0);
         }   

   if(CurTrend == 2)  
     if(CheckOrders(OP_BUY))
       if (LastSellBar < iTime(Symbol(), PERIOD_D1, 0))
         {
          if(Symbol() == "EURUSD")
            {
             TP = ND(EuroTargetD + Spread);
             SL = ND(EuroTargetU + Spread);
            } 
           else
            {
             TP = ND(FrancTargetD + Spread); 
             SL = ND(FrancTargetU + Spread);
            } 
          if(ND(Bid - TP - StopLevel) > 0 && ND(SL - Ask - StopLevel) > 0)
            if (OpenOrder(OP_SELL, Bid, SL, 0))
              LastSellBar = iTime(Symbol(), PERIOD_D1, 0);
         }   
     
//----
   return(0);
  }
//+------------------------------------------------------------------+