//+------------------------------------------------------------------+
//|                                                  CrossArbitr.mq4 |
//|                                                        Scriptong |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Scriptong"
#property link      ""

#property indicator_chart_window
//---- input parameters
extern bool      ShowBid=false;
extern bool      ShowAsk=false;
extern color     BidColor = Lime;
extern color     AskColor = Yellow;
extern int       AlarmIfPointDifference = 10;
extern string    AlarmFile = "wait.wav"; 


bool Activate = False;
string FP, SP;
double Tick;
int WayForCross;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   string S = Symbol();
   if(StringFind(S, "USD", 0) != -1)
     {
      Comment("      (GBPJPY, EURJPY, EURGBP  . )!");
      return(0);
     }

   if(StringLen(S) != 6)
     {
      Comment("     ,       !");
      return(0);
     }
     
   //     
   FP = StringSubstr(S, 0, 3)+"USD";
   MarketInfo(FP, MODE_BID);
   if(GetLastError() > 0)
     {
      FP = "USD"+StringSubstr(S, 0, 3);
      MarketInfo(FP, MODE_BID);
      if(GetLastError() > 0)
        {
         Comment("   ", FP, "  ", StringSubstr(S, 0, 3)+"USD.         .");
         return(0);
        } 
     } 
   // --------------------------------------  
     
   // ""    
   SP = "USD"+StringSubstr(S, 3, 3);
   MarketInfo(SP, MODE_BID);
   if(GetLastError() > 0)
     {
      SP = StringSubstr(S, 3, 3)+"USD";
      MarketInfo(SP, MODE_BID);
      if(GetLastError() > 0)
        {
         Comment("   ", SP, "  ", StringSubstr(S, 3, 3)+"USD.         .");
         return(0);
        } 
     } 
   // --------------------------------------  

   //    
   if (StringFind(FP, "USD") == 3 && StringFind(SP, "USD") == 0)
     WayForCross = 1;
   if (StringFind(FP, "USD") == 0 && StringFind(SP, "USD") == 0)
     WayForCross = 2;
   if (StringFind(FP, "USD") == 3 && StringFind(SP, "USD") == 3)
     WayForCross = 3;
   if (StringFind(FP, "USD") == 0 && StringFind(SP, "USD") == 3)
     WayForCross = 4;
   // -------------------------------

   Tick = MarketInfo(Symbol(), MODE_TICKSIZE);
   
   Activate = True;  
//----
   return(0);
  }
  
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   Comment("");
   if(ObjectFind("CrossBid") == 0)
     ObjectDelete("CrossBid");
   if(ObjectFind("CrossAsk") == 0)
     ObjectDelete("CrossAsk");
   
//----
   return(0);
  }
  
//+------------------------------------------------------------------+
//|                             |
//+------------------------------------------------------------------+
double ND(double A)
{
 return(NormalizeDouble(A, Digits));
}  

//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+
double CalcBidWayForCross()
{
 switch (WayForCross)
   {
    case 1: return(ND(MarketInfo(FP, MODE_BID)*MarketInfo(SP, MODE_BID)));
    case 2: return(ND(MarketInfo(SP, MODE_BID)/MarketInfo(FP, MODE_ASK)));
    case 3: return(ND(MarketInfo(FP, MODE_BID)/MarketInfo(SP, MODE_ASK)));
    case 4: return(1/(ND(MarketInfo(FP, MODE_ASK)*MarketInfo(SP, MODE_BID))));
   }
}

//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+
double CalcAskWayForCross()
{
 switch (WayForCross)
   {
    case 1: return(ND(MarketInfo(FP, MODE_ASK)*MarketInfo(SP, MODE_ASK)));
    case 2: return(ND(MarketInfo(SP, MODE_ASK)/MarketInfo(FP, MODE_BID)));
    case 3: return(ND(MarketInfo(FP, MODE_ASK)/MarketInfo(SP, MODE_BID)));
    case 4: return(1/(ND(MarketInfo(FP, MODE_BID)*MarketInfo(SP, MODE_ASK))));
   }
}

  
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
//----
   if(!Activate)
    return(0);

   //   Bid  Ask
   double CalcBid = CalcBidWayForCross();  
   RefreshRates();
   double CalcAsk = CalcAskWayForCross();  
   // -------------------------------

   //    Bid
   if (ShowBid)
     {
      if(ObjectFind("CrossBid") == -1)
        {
         ObjectCreate("CrossBid", OBJ_HLINE, 0, 0, CalcBid); 
         ObjectSet("CrossBid", OBJPROP_COLOR, BidColor);
         ObjectSet("CrossBid", OBJPROP_STYLE, STYLE_DOT);
        } 
       else
        if(!ObjectMove("CrossBid", 0, 1, CalcBid))
           Print("  ", GetLastError());
     }
   // ----------------------------------        

   //    Ask
   if(ShowAsk)
    {
     if(ObjectFind("CrossAsk") == -1)
       {
        ObjectCreate("CrossAsk", OBJ_HLINE, 0, 0, CalcAsk); 
        ObjectSet("CrossAsk", OBJPROP_COLOR, AskColor);
        ObjectSet("CrossAsk", OBJPROP_STYLE, STYLE_DOT);
       } 
      else
       ObjectMove("CrossAsk", 0, 1, CalcAsk);
    }
   // ----------------------------------        

   Comment(" BID = ", DoubleToStr(Bid, Digits), ",  ASK = ", DoubleToStr(Ask, Digits), 
           "\n BID = ", DoubleToStr(CalcBid, Digits), ",  ASK = ", DoubleToStr(CalcAsk, Digits));

   //       
   if(ND(MathAbs(CalcBid-Bid)) >= ND(AlarmIfPointDifference*Point))
     PlaySound(AlarmFile);
   // --------------------------------------------------------  
    
//----
   return(0);
  }
//+------------------------------------------------------------------+