//+------------------------------------------------------------------+
//|                                            IncGUI_ColorInput.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "1.00"

#include <IncColors.mqh>
#include <IncGUI_v4.mqh>
//+------------------------------------------------------------------+
//| CCanvasSimple                                                    |
//+------------------------------------------------------------------+
class CCanvasSimple
  {
   string            m_name;
   string            m_rcname;
   int               m_width;
   int               m_height;
   uint              m_data[];
   int               m_x;
   int               m_y;
public:
   bool Create(string aName,int aSubWin,int aX,int aY,int aWidth,int aHeight)
     {
      m_x=aX;
      m_y=aY;
      Destroy();
      if(aWidth>0 && aHeight>0 && ArrayResize(m_data,aWidth*aHeight)>0)
        {
         if(ObjectCreate(0,aName,OBJ_BITMAP_LABEL,aSubWin,0,0))
           {
            m_rcname="::"+aName;//(string)GetTickCount();
            ArrayInitialize(m_data,0);
            if(ResourceCreate(m_rcname,m_data,aWidth,aHeight,0,0,0,COLOR_FORMAT_XRGB_NOALPHA))
              {
               if(ObjectSetInteger(0,aName,OBJPROP_XDISTANCE,aX) && ObjectSetInteger(0,aName,OBJPROP_YDISTANCE,aY) && ObjectSetString(0,aName,OBJPROP_BMPFILE,m_rcname))
                 {
                  m_width=aWidth;
                  m_height=aHeight;
                  m_name=aName;
                  return(true);
                 }
              }
           }
        }
      Destroy();
      return(false);
     }
   void Destroy(void)
     {
      ObjectDelete(0,m_name);
      ArrayFree(m_data);
      m_width=0;
      m_height=0;
      m_name=NULL;
      m_rcname=NULL;
     }
   void Update(void)
     {
      if(ResourceCreate(m_rcname,m_data,m_width,m_height,0,0,0,COLOR_FORMAT_XRGB_NOALPHA))
        {
         ChartRedraw();
        }
     }
   void SetPixel(int aX,int aY,double aR,double aG,double aB)
     {
      if(aX>=0 && aX<m_width && aY>=0 && aY<m_height)
        {
         m_data[aY*m_width+aX]=(0xFF000000|(uchar(aR)<<16)|(uchar(aG)<<8)|uchar(aB));
        }
     }
   void SetPixel(int aX,int aY,uint aValue)
     {
      if(aX>=0 && aX<m_width && aY>=0 && aY<m_height)
        {
         m_data[aY*m_width+aX]=aValue;
        }
     }
   uint GetPixel(int aX,int aY)
     {
      if(aX>=0 && aX<m_width && aY>=0 && aY<m_height)
        {
         return(m_data[aY*m_width+aX]);
        }
      return(0);
     }
   int PosX(){return(m_x);}
   int PosY(){return(m_y);}
  };
//+------------------------------------------------------------------+
//| CColorDialog                                                     |
//+------------------------------------------------------------------+
class CColorDialog
  {
protected:
   CIColors          m_colc;
   CCanvasSimple     m_can;
   CCanvasSimple     m_can2;
   CRadioGroup       m_std_rg;
   CRadioGroup       m_hsl_rg;
   CSpinInputBox     m_hsl_ih;
   CSpinInputBox     m_hsl_is;
   CSpinInputBox     m_hsl_ib;
   CRadioGroup       m_rgb_rg;
   CSpinInputBox     m_rgb_ir;
   CSpinInputBox     m_rgb_ig;
   CSpinInputBox     m_rgb_ib;
   CRadioGroup       m_lab_rg;
   CSpinInputBox     m_lab_il;
   CSpinInputBox     m_lab_ia;
   CSpinInputBox     m_lab_ib;
   CButton           m_ok;
   CButton           m_cancel;
   CFrame            m_fr;
   color             m_color;
   double            m_hsl_h;
   double            m_hsl_s;
   double            m_hsl_l;
   double            m_rgb_r;
   double            m_rgb_g;
   double            m_rgb_b;
   double            m_lab_l;
   double            m_lab_a;
   double            m_lab_b;
   string            m_bgid;
   double            m_xyz_x;
   double            m_xyz_y;
   double            m_zyz_z;
   double            m_dot_x;
   double            m_dot_y;
   double            m_dot_z;
   int               m_selected;
   string            m_name;
   bool              m_visible;
   int               m_left;
   int               m_top;
   int               m_canx1;
   int               m_cany1;
   color             m_lstcolor;
   string            m_tag;
   int               m_subwin;
   color             m_stcolor;
   bool              m_canexist;
   int               m_dx[24];
   int               m_dy[24];
   uint              m_dv[24];
   int               m_ssi;
   int               m_stci;
   void SetControls()
     {
      m_rgb_ir.SetValue(m_rgb_r);
      m_rgb_ig.SetValue(m_rgb_g);
      m_rgb_ib.SetValue(m_rgb_b);
      m_hsl_ih.SetValue(m_hsl_h);
      m_hsl_is.SetValue(m_hsl_s);
      m_hsl_ib.SetValue(m_hsl_l);
      m_lab_il.SetValue(m_lab_l);
      m_lab_ia.SetValue(m_lab_a);
      m_lab_ib.SetValue(m_lab_b);
      if(m_visible)
        {
         DrawColorPicker();
        }
     }
   color GetStdColor(int aIndex)
     {
      //color m_c2[]={clrBlack,clrDarkGreen,clrDarkSlateGray,clrOlive,clrGreen,clrTeal,clrNavy,clrPurple,clrMaroon,clrIndigo,clrMidnightBlue,clrDarkBlue,clrDarkOliveGreen,clrSaddleBrown,clrForestGreen,clrOliveDrab,clrSeaGreen,clrDarkGoldenrod,clrDarkSlateBlue,clrSienna,clrMediumBlue,clrBrown,clrDarkTurquoise,clrDimGray,clrLightSeaGreen,clrDarkViolet,clrFireBrick,clrMediumVioletRed,clrMediumSeaGreen,clrChocolate,clrCrimson,clrSteelBlue,clrGoldenrod,clrMediumSpringGreen,clrLawnGreen,clrCadetBlue,clrDarkOrchid,clrYellowGreen,clrLimeGreen,clrOrangeRed,clrDarkOrange,clrOrange,clrGold,clrYellow,clrChartreuse,clrLime,clrSpringGreen,clrAqua,clrDeepSkyBlue,clrBlue,clrFuchsia,clrRed,clrGray,clrSlateGray,clrPeru,clrBlueViolet,clrLightSlateGray,clrDeepPink,clrMediumTurquoise,clrDodgerBlue,clrTurquoise,clrRoyalBlue,clrSlateBlue,clrDarkKhaki,clrIndianRed,clrMediumOrchid,clrGreenYellow,clrMediumAquamarine,clrDarkSeaGreen,clrTomato,clrRosyBrown,clrOrchid,clrMediumPurple,clrPaleVioletRed,clrCoral,clrCornflowerBlue,clrDarkGray,clrSandyBrown,clrMediumSlateBlue,clrTan,clrDarkSalmon,clrBurlyWood,clrHotPink,clrSalmon,clrViolet,clrLightCoral,clrSkyBlue,clrLightSalmon,clrPlum,clrKhaki,clrLightGreen,clrAquamarine,clrSilver,clrLightSkyBlue,clrLightSteelBlue,clrLightBlue,clrPaleGreen,clrThistle,clrPowderBlue,clrPaleGoldenrod,clrPaleTurquoise,clrLightGray,clrWheat,clrNavajoWhite,clrMoccasin,clrLightPink,clrGainsboro,clrPeachPuff,clrPink,clrBisque,clrLightGoldenrod,clrBlanchedAlmond,clrLemonChiffon,clrBeige,clrAntiqueWhite,clrPapayaWhip,clrCornsilk,clrLightYellow,clrLightCyan,clrLinen,clrLavender,clrMistyRose,clrOldLace,clrWhiteSmoke,clrSeashell,clrIvory,clrHoneydew,clrAliceBlue,clrLavenderBlush,clrMintCream,clrSnow,clrWhite}; //   
      //color m_c[]={0,8388608,9109504,13434880,16711680,25600,32768,8421376,9145088,16760576,13749760,10156544,65280,8388352,16776960,7346457,16748574,11186720,2263842,5737262,5197615,3329330,7451452,13688896,14772545,11829830,9125192,13422920,8519755,3107669,10526303,15570276,11193702,6908265,13458026,2330219,9470064,10061943,15624315,64636,65407,13959039,128,8388736,32896,8421504,15453831,16436871,14822282,139,9109643,1262987,9419919,9498256,14381203,13828244,10025880,13382297,3329434,2970272,2763429,11119017,15128749,3145645,15658671,14599344,15130800,2237106,755384,13850042,9408444,7059389,12632256,8721863,6053069,4163021,1993170,9221330,13882323,14204888,14053594,2139610,9662683,3937500,14474460,14524637,8894686,16777184,16443110,8034025,15631086,11200750,8421616,9234160,16775408,15794160,16777200,6333684,11788021,14480885,16119285,16449525,16775416,7504122,14150650,15134970,13826810,15136253,255,16711935,9639167,17919,4678655,11823615,5275647,36095,8036607,42495,12695295,13353215,55295,12180223,11394815,11920639,12903679,14804223,13495295,14020607,16118015,15660543,14481663,13499135,15792895,16448255,65535,14745599,15794175,16777215}; //    rgb
      color m_c[]={clrBlack,clrDarkGreen,clrDarkSlateGray,clrOlive,clrGreen,clrTeal,clrNavy,clrPurple,clrMaroon,clrIndigo,clrMidnightBlue,clrDarkBlue,clrDarkOliveGreen,clrSaddleBrown,clrForestGreen,clrOliveDrab,clrSeaGreen,clrDarkGoldenrod,clrDarkSlateBlue,clrSienna,clrMediumBlue,clrBrown,clrDarkTurquoise,clrDimGray,clrLightSeaGreen,clrDarkViolet,clrFireBrick,clrMediumVioletRed,clrMediumSeaGreen,clrChocolate,clrCrimson,clrSteelBlue,clrGoldenrod,clrMediumSpringGreen,clrLawnGreen,clrCadetBlue,clrDarkOrchid,clrYellowGreen,clrLimeGreen,clrOrangeRed,clrDarkOrange,clrOrange,clrGold,clrYellow,clrChartreuse,clrLime,clrSpringGreen,clrAqua,clrDeepSkyBlue,clrBlue,clrFuchsia,clrRed,clrGray,clrSlateGray,clrPeru,clrBlueViolet,clrLightSlateGray,clrDeepPink,clrMediumTurquoise,clrDodgerBlue,clrTurquoise,clrRoyalBlue,clrSlateBlue,clrDarkKhaki,clrIndianRed,clrMediumOrchid,clrGreenYellow,clrMediumAquamarine,clrDarkSeaGreen,clrTomato,clrRosyBrown,clrOrchid,clrMediumPurple,clrPaleVioletRed,clrCoral,clrCornflowerBlue,clrDarkGray,clrSandyBrown,clrMediumSlateBlue,clrTan,clrDarkSalmon,clrBurlyWood,clrHotPink,clrSalmon,clrViolet,clrLightCoral,clrSkyBlue,clrLightSalmon,clrPlum,clrKhaki,clrLightGreen,clrAquamarine,clrSilver,clrLightSkyBlue,clrLightSteelBlue,clrLightBlue,clrPaleGreen,clrThistle,clrPowderBlue,clrPaleGoldenrod,clrPaleTurquoise,clrLightGray,clrWheat,clrNavajoWhite,clrMoccasin,clrLightPink,clrGainsboro,clrPeachPuff,clrPink,clrBisque,clrLightGoldenrod,clrBlanchedAlmond,clrLemonChiffon,clrBeige,clrAntiqueWhite,clrPapayaWhip,clrCornsilk,clrLightYellow,clrLightCyan,clrLinen,clrLavender,clrMistyRose,clrOldLace,clrWhiteSmoke,clrSeashell,clrIvory,clrHoneydew,clrAliceBlue,clrLavenderBlush,clrMintCream,clrSnow,clrWhite,clrDarkCyan,clrDarkRed,clrDarkMagenta,clrAzure,clrGhostWhite,clrFloralWhite};
      return(m_c[aIndex]);
     }
   void CreateSamples()
     {
      for(int i=0;i<138;i++)
        {
         int m_y=i/11;
         int m_x=i%11;
         string m_nm=m_name+"SetSamp("+IntegerToString(i)+")";
         w.Canvas(m_nm,m_subwin,m_can.PosX()+m_x*25+3,m_can.PosY()+m_y*20+3,20,12,GetStdColor(i),ClrScheme.Color(40));
         g.SetToolTip(m_nm,ColorToString(GetStdColor(i),true));
        }
     }
   void DrawColorPicker()
     {
      if(m_selected==9)
        {
         m_bgid="";
         if(m_canexist)
           {
            m_can.Destroy();
            m_can2.Destroy();
            m_canexist=false;
            w.Canvas(m_name+"Set",m_subwin,m_can.PosX(),m_can.PosY(),276,258,ClrScheme.Color(39),ClrScheme.Color(40));
            CreateSamples();
            w.Redraw();
           }
         g.SetBgColor(m_name+"Sample",m_color);
         g.SetBgColor(m_name+"Sample3",m_stcolor);
         g.SetToolTip(m_name+"Sample3",ColorToString(m_stcolor,true));
         g.SetStyle(m_name+"SetSamp("+IntegerToString(m_ssi)+")",STYLE_SOLID);
         g.SetStyle(m_name+"SetSamp("+IntegerToString(m_stci)+")",STYLE_DOT);
         m_ssi=m_stci;
         g.Redraw();
        }
      else
        {
         if(!m_canexist)
           {
            for(int i=0;i<138;i++)
              {
               w.Delete(m_name+"SetSamp("+IntegerToString(i)+")");
              }
            w.Delete(m_name+"Set");
            m_can.Create(m_name+"Can",m_subwin,m_canx1,m_cany1,258,258);
            m_can2.Create(m_name+"Can2",m_subwin,m_canx1+258+3,m_cany1,15,258);
            m_canexist=true;
           }
         DrawColorSlice();
         SolveDotXY();
         DrawDot();
         DrawBorder();
         g.SetBgColor(m_name+"Sample",m_color);
         g.SetBgColor(m_name+"Sample3",m_stcolor);
         g.SetToolTip(m_name+"Sample3",ColorToString(m_stcolor,true));
         g.Redraw();
         m_can.Update();
         m_can2.Update();
        }
     }
   void SolveDotXY()
     {
      switch(m_selected)
        {
         case 0:
            m_dot_x=m_hsl_s/100.0*255.0+1.0;
            m_dot_y=255.0-m_hsl_l/100.0*255.0+1.0;
            m_dot_z=255-m_hsl_h/360.0*255.0+1.0;
            break;
         case 1:
            m_dot_x=m_hsl_h/360.0*255.0+1.0;
            m_dot_y=255.0-m_hsl_l/100.0*255.0+1.0;
            m_dot_z=255.0-m_hsl_s/100.0*255.0+1.0;
            break;
         case 2:
            m_dot_x=m_hsl_h/360.0*255.0+1.0;
            m_dot_y=255.0-m_hsl_s/100.0*255.0+1.0;
            m_dot_z=255.0-m_hsl_l/100.0*255.0+1.0;
            break;
         case 3:
            m_dot_x=m_rgb_g+1.0;
            m_dot_y=255.0-m_rgb_b+1.0;
            m_dot_z=255.0-m_rgb_r+1.0;
            break;
         case 4:
            m_dot_x=m_rgb_r+1.0;
            m_dot_y=255.0-m_rgb_b+1.0;
            m_dot_z=255.0-m_rgb_g+1.0;
            break;
         case 5:
            m_dot_x=m_rgb_r+1;
            m_dot_y=255.0-m_rgb_g+1.0;
            m_dot_z=255.0-m_rgb_b+1.0;
            break;
         case 6:
            m_dot_x=m_lab_a+128.0+1.0;
            m_dot_y=255.0-(m_lab_b+128.0)+1.0;
            m_dot_z=255.0-(m_lab_l/100.0*255)+1.0;
            break;
         case 7:
            m_dot_x=m_lab_l/100.0*255+1.0;
            m_dot_y=255.0-(m_lab_b+128.0)+1.0;
            m_dot_z=255.0-(m_lab_a+128.0)+1.0;
            break;
         case 8:
            m_dot_x=m_lab_l/100.0*255.0+1.0;
            m_dot_y=255.0-(m_lab_a+128.0)+1.0;
            m_dot_z=255.0-(m_lab_b+128.0)+1.0;
            break;
        }
     }
   void DrawColorSlice()
     {
      double m_tmp_rgb_r;
      double m_tmp_rgb_g;
      double m_tmp_rgb_b;
      double m_tmp_hsl_h;
      double m_tmp_hsl_s;
      double m_tmp_hsl_l;
      double m_tmp_lab_l;
      double m_tmp_lab_a;
      double m_tmp_lab_b;
      double m_tmp_xyz_x;
      double m_tmp_xyz_y;
      double m_tmp_xyz_z;
      string m_id;
      m_id=IntegerToString(m_selected);
      switch(m_selected)
        {
         case 0:
            m_tmp_hsl_h=m_hsl_ih.Value()/360.0;
            m_id=m_id+"/"+DoubleToString(m_tmp_hsl_h);
            if(m_bgid!=m_id)
              {
               for(int y=0;y<256;y++)
                 {
                  m_tmp_hsl_l=y/255.0;
                  for(int x=0;x<256;x++)
                    {
                     m_tmp_hsl_s=x/255.0;
                     m_colc.HSLtoRGB(m_tmp_hsl_h,m_tmp_hsl_s,m_tmp_hsl_l,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                     m_can.SetPixel(x+1,255-y+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                    }
                 }
               m_bgid=m_id;
              }
            else
              {
               for(int i=0;i<24;i++)
                 {
                  m_can.SetPixel(m_dx[i],m_dy[i],m_dv[i]);
                 }
              }
            m_tmp_hsl_h=m_hsl_ih.Value()/360.0;
            m_tmp_hsl_s=m_hsl_is.Value()/100.0;
            m_tmp_hsl_l=m_hsl_ib.Value()/100.0;
            for(int i=0;i<256;i++)
              {
               m_tmp_hsl_h=i/255.0;
               m_colc.HSLtoRGB(m_tmp_hsl_h,m_tmp_hsl_s,m_tmp_hsl_l,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
               for(int j=1;j<14;j++)
                 {
                  m_can2.SetPixel(j,255-i+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                 }
              }
            break;
         case 1:
            m_tmp_hsl_s=m_hsl_is.Value()/100;
            m_id=m_id+"/"+DoubleToString(m_tmp_hsl_s);

            if(m_bgid!=m_id)
              {
               for(int y=0;y<256;y++)
                 {
                  m_tmp_hsl_l=y/255.0;
                  for(int x=0;x<256;x++)
                    {
                     m_tmp_hsl_h=x/255.0;
                     m_colc.HSLtoRGB(m_tmp_hsl_h,m_tmp_hsl_s,m_tmp_hsl_l,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                     m_can.SetPixel(x+1,255-y+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                    }
                 }
               m_bgid=m_id;
              }
            else
              {
               for(int i=0;i<24;i++)
                 {
                  m_can.SetPixel(m_dx[i],m_dy[i],m_dv[i]);
                 }
              }

            m_tmp_hsl_h=m_hsl_ih.Value()/360.0;
            m_tmp_hsl_s=m_hsl_is.Value()/100.0;
            m_tmp_hsl_l=m_hsl_ib.Value()/100.0;
            for(int i=0;i<256;i++)
              {
               m_tmp_hsl_s=i/255.0;
               m_colc.HSLtoRGB(m_tmp_hsl_h,m_tmp_hsl_s,m_tmp_hsl_l,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
               for(int j=1;j<14;j++)
                 {
                  m_can2.SetPixel(j,255-i+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                 }
              }
            break;
         case 2:
            m_tmp_hsl_l=m_hsl_ib.Value()/100;
            m_id=m_id+"/"+DoubleToString(m_tmp_hsl_l);

            if(m_bgid!=m_id)
              {
               for(int y=0;y<256;y++)
                 {
                  m_tmp_hsl_s=y/255.0;
                  for(int x=0;x<256;x++)
                    {
                     m_tmp_hsl_h=x/255.0;
                     m_colc.HSLtoRGB(m_tmp_hsl_h,m_tmp_hsl_s,m_tmp_hsl_l,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                     m_can.SetPixel(x+1,255-y+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                    }
                 }
               m_bgid=m_id;
              }
            else
              {
               for(int i=0;i<24;i++)
                 {
                  m_can.SetPixel(m_dx[i],m_dy[i],m_dv[i]);
                 }
              }

            m_tmp_hsl_h=m_hsl_ih.Value()/360.0;
            m_tmp_hsl_s=m_hsl_is.Value()/100.0;
            m_tmp_hsl_l=m_hsl_ib.Value()/100.0;
            for(int i=0;i<256;i++)
              {
               m_tmp_hsl_l=i/255.0;
               m_colc.HSLtoRGB(m_tmp_hsl_h,m_tmp_hsl_s,m_tmp_hsl_l,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
               for(int j=1;j<14;j++)
                 {
                  m_can2.SetPixel(j,255-i+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                 }
              }
            break;
         case 3:
            m_tmp_rgb_r=m_rgb_ir.Value();
            m_id=m_id+"/"+DoubleToString(m_tmp_rgb_r);
            if(m_bgid!=m_id)
              {
               for(int y=0;y<256;y++)
                 {
                  m_tmp_rgb_b=y;
                  for(int x=0;x<256;x++)
                    {
                     m_tmp_rgb_g=x;
                     m_can.SetPixel(x+1,255-y+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                    }
                 }
               m_bgid=m_id;
              }
            else
              {
               for(int i=0;i<24;i++)
                 {
                  m_can.SetPixel(m_dx[i],m_dy[i],m_dv[i]);
                 }
              }
            m_tmp_rgb_r=m_rgb_ir.Value();
            m_tmp_rgb_g=m_rgb_ig.Value();
            m_tmp_rgb_b=m_rgb_ib.Value();
            for(int i=0;i<256;i++)
              {
               m_tmp_rgb_r=i;
               for(int j=1;j<14;j++)
                 {
                  m_can2.SetPixel(j,255-i+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                 }
              }
            break;
         case 4:
            m_tmp_rgb_g=m_rgb_ig.Value();
            m_id=m_id+"/"+DoubleToString(m_tmp_rgb_g);
            if(m_bgid!=m_id)
              {
               for(int y=0;y<256;y++)
                 {
                  m_tmp_rgb_b=y;
                  for(int x=0;x<256;x++)
                    {
                     m_tmp_rgb_r=x;
                     m_can.SetPixel(x+1,255-y+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                    }
                 }
               m_bgid=m_id;
              }
            else
              {
               for(int i=0;i<24;i++)
                 {
                  m_can.SetPixel(m_dx[i],m_dy[i],m_dv[i]);
                 }
              }
            m_tmp_rgb_r=m_rgb_ir.Value();
            m_tmp_rgb_g=m_rgb_ig.Value();
            m_tmp_rgb_b=m_rgb_ib.Value();
            for(int i=0;i<256;i++)
              {
               m_tmp_rgb_g=i;
               for(int j=1;j<14;j++)
                 {
                  m_can2.SetPixel(j,255-i+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                 }
              }
            break;
         case 5:
            m_tmp_rgb_b=m_rgb_ib.Value();
            m_id=m_id+"/"+DoubleToString(m_tmp_rgb_b);
            if(m_bgid!=m_id)
              {
               for(int y=0;y<256;y++)
                 {
                  m_tmp_rgb_g=y;
                  for(int x=0;x<256;x++)
                    {
                     m_tmp_rgb_r=x;
                     m_can.SetPixel(x+1,255-y+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                    }
                 }
               m_bgid=m_id;
              }
            else
              {
               for(int i=0;i<24;i++)
                 {
                  m_can.SetPixel(m_dx[i],m_dy[i],m_dv[i]);
                 }
              }
            m_tmp_rgb_r=m_rgb_ir.Value();
            m_tmp_rgb_g=m_rgb_ig.Value();
            m_tmp_rgb_b=m_rgb_ib.Value();
            for(int i=0;i<256;i++)
              {
               m_tmp_rgb_b=i;
               for(int j=1;j<14;j++)
                 {
                  m_can2.SetPixel(j,255-i+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                 }
              }
            break;
         case 6:
            m_tmp_lab_l=m_lab_il.Value();
            m_id=m_id+"/"+DoubleToString(m_tmp_lab_l);
            if(m_bgid!=m_id)
              {
               for(int y=0;y<256;y++)
                 {
                  m_tmp_lab_b=y-128;
                  for(int x=0;x<256;x++)
                    {
                     m_tmp_lab_a=x-128;
                     m_colc.CIELabToXYZ(m_tmp_lab_l,m_tmp_lab_a,m_tmp_lab_b,m_tmp_xyz_x,m_tmp_xyz_y,m_tmp_xyz_z);
                     m_colc.XYZtoRGB(m_tmp_xyz_x,m_tmp_xyz_y,m_tmp_xyz_z,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                     m_tmp_rgb_r=MathMin(MathMax(m_tmp_rgb_r,0),255);
                     m_tmp_rgb_g=MathMin(MathMax(m_tmp_rgb_g,0),255);
                     m_tmp_rgb_b=MathMin(MathMax(m_tmp_rgb_b,0),255);
                     m_can.SetPixel(x+1,255-y+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                    }
                 }
               m_bgid=m_id;
              }
            else
              {
               for(int i=0;i<24;i++)
                 {
                  m_can.SetPixel(m_dx[i],m_dy[i],m_dv[i]);
                 }
              }
            m_tmp_lab_l=m_lab_il.Value();
            m_tmp_lab_a=m_lab_ia.Value();
            m_tmp_lab_b=m_lab_ib.Value();
            for(int i=0;i<256;i++)
              {
               m_tmp_lab_l=100.0*i/255.0;
               m_colc.CIELabToXYZ(m_tmp_lab_l,m_tmp_lab_a,m_tmp_lab_b,m_tmp_xyz_x,m_tmp_xyz_y,m_tmp_xyz_z);
               m_colc.XYZtoRGB(m_tmp_xyz_x,m_tmp_xyz_y,m_tmp_xyz_z,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
               m_tmp_rgb_r=MathMin(MathMax(m_tmp_rgb_r,0),255);
               m_tmp_rgb_g=MathMin(MathMax(m_tmp_rgb_g,0),255);
               m_tmp_rgb_b=MathMin(MathMax(m_tmp_rgb_b,0),255);
               for(int j=1;j<14;j++)
                 {
                  m_can2.SetPixel(j,255-i+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                 }
              }
            break;
         case 7:
            m_tmp_lab_a=m_lab_ia.Value();
            m_id=m_id+"/"+DoubleToString(m_tmp_lab_a);
            if(m_bgid!=m_id)
              {
               for(int y=0;y<256;y++)
                 {
                  m_tmp_lab_b=y-128;
                  for(int x=0;x<256;x++)
                    {
                     m_tmp_lab_l=100.0*x/255.0;
                     m_colc.CIELabToXYZ(m_tmp_lab_l,m_tmp_lab_a,m_tmp_lab_b,m_tmp_xyz_x,m_tmp_xyz_y,m_tmp_xyz_z);
                     m_colc.XYZtoRGB(m_tmp_xyz_x,m_tmp_xyz_y,m_tmp_xyz_z,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                     m_tmp_rgb_r=MathMin(MathMax(m_tmp_rgb_r,0),255);
                     m_tmp_rgb_g=MathMin(MathMax(m_tmp_rgb_g,0),255);
                     m_tmp_rgb_b=MathMin(MathMax(m_tmp_rgb_b,0),255);
                     m_can.SetPixel(x+1,255-y+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                    }
                 }
               m_bgid=m_id;
              }
            else
              {
               for(int i=0;i<24;i++)
                 {
                  m_can.SetPixel(m_dx[i],m_dy[i],m_dv[i]);
                 }
              }
            m_tmp_lab_l=m_lab_il.Value();
            m_tmp_lab_a=m_lab_ia.Value();
            m_tmp_lab_b=m_lab_ib.Value();
            for(int i=0;i<256;i++)
              {
               m_tmp_lab_a=i-128;
               m_colc.CIELabToXYZ(m_tmp_lab_l,m_tmp_lab_a,m_tmp_lab_b,m_tmp_xyz_x,m_tmp_xyz_y,m_tmp_xyz_z);
               m_colc.XYZtoRGB(m_tmp_xyz_x,m_tmp_xyz_y,m_tmp_xyz_z,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
               m_tmp_rgb_r=MathMin(MathMax(m_tmp_rgb_r,0),255);
               m_tmp_rgb_g=MathMin(MathMax(m_tmp_rgb_g,0),255);
               m_tmp_rgb_b=MathMin(MathMax(m_tmp_rgb_b,0),255);
               for(int j=1;j<14;j++)
                 {
                  m_can2.SetPixel(j,255-i+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                 }
              }
            break;
         case 8:
            m_tmp_lab_b=m_lab_ib.Value();
            m_id=m_id+"/"+DoubleToString(m_tmp_lab_b);
            if(m_bgid!=m_id)
              {
               for(int y=0;y<256;y++)
                 {
                  m_tmp_lab_a=y-128;
                  for(int x=0;x<256;x++)
                    {
                     m_tmp_lab_l=100.0*x/255.0;
                     m_colc.CIELabToXYZ(m_tmp_lab_l,m_tmp_lab_a,m_tmp_lab_b,m_tmp_xyz_x,m_tmp_xyz_y,m_tmp_xyz_z);
                     m_colc.XYZtoRGB(m_tmp_xyz_x,m_tmp_xyz_y,m_tmp_xyz_z,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                     m_tmp_rgb_r=MathMin(MathMax(m_tmp_rgb_r,0),255);
                     m_tmp_rgb_g=MathMin(MathMax(m_tmp_rgb_g,0),255);
                     m_tmp_rgb_b=MathMin(MathMax(m_tmp_rgb_b,0),255);
                     m_can.SetPixel(x+1,255-y+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                    }
                 }
               m_bgid=m_id;
              }
            else
              {
               for(int i=0;i<24;i++)
                 {
                  m_can.SetPixel(m_dx[i],m_dy[i],m_dv[i]);
                 }
              }
            m_tmp_lab_l=m_lab_il.Value();
            m_tmp_lab_a=m_lab_ia.Value();
            m_tmp_lab_b=m_lab_ib.Value();
            for(int i=0;i<256;i++)
              {
               m_tmp_lab_b=i-128;
               m_colc.CIELabToXYZ(m_tmp_lab_l,m_tmp_lab_a,m_tmp_lab_b,m_tmp_xyz_x,m_tmp_xyz_y,m_tmp_xyz_z);
               m_colc.XYZtoRGB(m_tmp_xyz_x,m_tmp_xyz_y,m_tmp_xyz_z,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
               m_tmp_rgb_r=MathMin(MathMax(m_tmp_rgb_r,0),255);
               m_tmp_rgb_g=MathMin(MathMax(m_tmp_rgb_g,0),255);
               m_tmp_rgb_b=MathMin(MathMax(m_tmp_rgb_b,0),255);
               for(int j=1;j<14;j++)
                 {
                  m_can2.SetPixel(j,255-i+1,m_tmp_rgb_r,m_tmp_rgb_g,m_tmp_rgb_b);
                 }
              }
            break;
        }
     }
   void DrawDot()
     {
      double m_bx[]={0,1,2,3,4,5,6,6,6,6,6,6,6,5,4,3,2,1,0,0,0,0,0,0};
      double m_by[]={0,0,0,0,0,0,0,1,2,3,4,5,6,6,6,6,6,6,6,5,4,3,2,1};
      for(int i=0;i<24;i++)
        {
         m_dx[i]=(int)(m_dot_x-3+m_bx[i]);
         m_dy[i]=(int)(m_dot_y-3+m_by[i]);
         m_dv[i]=m_can.GetPixel(m_dx[i],m_dy[i]);
         if(((i+1)/3)%2==0)
           {
            m_can.SetPixel(m_dx[i],m_dy[i],0,0,0);
           }
         else
           {
            m_can.SetPixel(m_dx[i],m_dy[i],255,255,255);
           }

        }
      double m_bx2[]={0,2,4,1,3,1,3,0,2,0,2,1,1,0,0};
      double m_by2[]={0,0,0,1,1,-1,-1,2,2,-2,-2,3,-3,4,-4};
      double m_wx2[]={1,3,0,2,0,2,1,1,0,0};
      double m_wy2[]={0,0,1,1,-1,-1,2,-2,3,-3};
      for(int i=0;i<15;i++)
        {
         m_can2.SetPixel((int)(1+m_bx2[i]),(int)(m_dot_z+m_by2[i]),0,0,0);
         m_can2.SetPixel((int)(13-m_bx2[i]),(int)(m_dot_z+m_by2[i]),0,0,0);
        }
      for(int i=0;i<10;i++)
        {
         m_can2.SetPixel((int)(1+m_wx2[i]),(int)(m_dot_z+m_wy2[i]),255,255,255);
         m_can2.SetPixel((int)(13-m_wx2[i]),(int)(m_dot_z+m_wy2[i]),255,255,255);
        }
     }
   void DrawBorder()
     {
      for(int i=0;i<258;i++)
        {
         if((i/3)%2==0)
           {
            m_can.SetPixel(0,i,0,0,0);
            m_can.SetPixel(257,i,0,0,0);
            m_can.SetPixel(i,0,0,0,0);
            m_can.SetPixel(i,257,0,0,0);
            m_can2.SetPixel(0,i,0,0,0);
            m_can2.SetPixel(14,i,0,0,0);
           }
         else
           {
            m_can.SetPixel(0,i,255,255,255);
            m_can.SetPixel(257,i,255,255,255);
            m_can.SetPixel(i,0,255,255,255);
            m_can.SetPixel(i,257,255,255,255);
            m_can2.SetPixel(0,i,255,255,255);
            m_can2.SetPixel(14,i,255,255,255);
           }
        }
      for(int i=0;i<14;i++)
        {
         if((i/3)%2==0)
           {
            m_can2.SetPixel(i,0,0,0,0);
            m_can2.SetPixel(i,257,0,0,0);
           }
         else
           {
            m_can2.SetPixel(i,0,255,255,255);
            m_can2.SetPixel(i,257,255,255,255);
           }
        }
     }
   void SetRGB(double aR,double aG,double aB)
     {
      m_rgb_r=aR;
      m_rgb_g=aG;
      m_rgb_b=aB;
      m_colc.RGBtoHSL(m_rgb_r,m_rgb_g,m_rgb_b,m_hsl_h,m_hsl_s,m_hsl_l);
      m_hsl_h*=360;
      m_hsl_s*=100;
      m_hsl_l*=100;
      m_colc.RGBtoXYZ(m_rgb_r,m_rgb_g,m_rgb_b,m_xyz_x,m_xyz_y,m_zyz_z);
      m_colc.XYZtoCIELab(m_xyz_x,m_xyz_y,m_zyz_z,m_lab_l,m_lab_a,m_lab_b);
      m_color=m_colc.RGBToColor(m_rgb_r,m_rgb_g,m_rgb_b);
      m_stcolor=m_colc.StandardColor(m_color,m_stci);
      SetControls();
     }
   void SetHSL(double aH,double aS,double aL)
     {
      m_hsl_h=aH;
      m_hsl_s=aS;
      m_hsl_l=aL;
      m_colc.HSLtoRGB(m_hsl_h/360,m_hsl_s/100,m_hsl_l/100,m_rgb_r,m_rgb_g,m_rgb_b);
      m_colc.RGBtoXYZ(m_rgb_r,m_rgb_g,m_rgb_b,m_xyz_x,m_xyz_y,m_zyz_z);
      m_colc.XYZtoCIELab(m_xyz_x,m_xyz_y,m_zyz_z,m_lab_l,m_lab_a,m_lab_b);
      m_color=m_colc.RGBToColor(m_rgb_r,m_rgb_g,m_rgb_b);
      m_stcolor=m_colc.StandardColor(m_color,m_stci);
      SetControls();
     }
   void SetLAB(double aL,double aA,double aB)
     {
      m_lab_l=aL;
      m_lab_a=aA;
      m_lab_b=aB;
      m_colc.CIELabToXYZ(m_lab_l,m_lab_a,m_lab_b,m_xyz_x,m_xyz_y,m_zyz_z);
      m_colc.XYZtoRGB(m_xyz_x,m_xyz_y,m_zyz_z,m_rgb_r,m_rgb_g,m_rgb_b);
      m_rgb_r=MathMin(MathMax(m_rgb_r,0),255);
      m_rgb_g=MathMin(MathMax(m_rgb_g,0),255);
      m_rgb_b=MathMin(MathMax(m_rgb_b,0),255);
      m_colc.RGBtoHSL(m_rgb_r,m_rgb_g,m_rgb_b,m_hsl_h,m_hsl_s,m_hsl_l);
      m_hsl_h*=360;
      m_hsl_s*=100;
      m_hsl_l*=100;
      m_color=m_colc.RGBToColor(m_rgb_r,m_rgb_g,m_rgb_b);
      m_stcolor=m_colc.StandardColor(m_color,m_stci);
      SetControls();
     }
   bool ColorPick(double ccx,double ccy)
     {
      if(ccx>0 && ccx<257)
        {
         if(ccy>0 && ccy<257)
           {
            ccx--;
            ccy--;
            ccy=255-ccy;
            switch(m_selected)
              {
               case 0:
                  SetHSL(m_hsl_h,ccx/255.0*100.0,ccy/255.0*100.0);
                  break;
               case 1:
                  SetHSL(ccx/255.0*360.0,m_hsl_s,ccy/255.0*100.0);
                  break;
               case 2:
                  SetHSL(ccx/255.0*360.0,ccy/255.0*100.0,m_hsl_l);
                  break;
               case 3:
                  SetRGB(m_rgb_r,ccx,ccy);
                  break;
               case 4:
                  SetRGB(ccx,m_rgb_g,ccy);
                  break;
               case 5:
                  SetRGB(ccx,ccy,m_rgb_b);
                  break;
               case 6:
                  SetLAB(m_lab_l,ccx-128,ccy-128);
                  break;
               case 7:
                  SetLAB(ccx/255.0*100.0,m_lab_a,ccy-128);
                  break;
               case 8:
                  SetLAB(ccx/255.0*100.0,ccy-128,m_lab_b);
                  break;
              }
            return(true);
           }
        }
      return(false);
     }
   bool ColorPick2(double ccx,double ccy)
     {
      if(ccx>0 && ccx<14)
        {
         if(ccy>0 && ccy<257)
           {
            ccy--;
            ccy=255-ccy;
            switch(m_selected)
              {
               case 0:
                  SetHSL(ccy/255.0*360.0,m_hsl_s,m_hsl_l);
                  break;
               case 1:
                  SetHSL(m_hsl_h,ccy/255.0*100.0,m_hsl_l);
                  break;
               case 2:
                  SetHSL(m_hsl_h,m_hsl_s,ccy/255.0*100.0);
                  break;
               case 3:
                  SetRGB(ccy,m_rgb_g,m_rgb_b);
                  break;
               case 4:
                  SetRGB(m_rgb_r,ccy,m_rgb_b);
                  break;
               case 5:
                  SetRGB(m_rgb_r,m_rgb_g,ccy);
                  break;
               case 6:
                  SetLAB(ccy/255.0*100.0,m_lab_a,m_lab_b);
                  break;
               case 7:
                  SetLAB(m_lab_l,ccy-128,m_lab_b);
                  break;
               case 8:
                  SetLAB(m_lab_l,m_lab_a,ccy-128);
                  break;
              }
            return(true);
           }
        }
      return(false);
     }
   void ChartClickY(double aDparam,int  &aY)
     {
      long m_wtop=0;
      for(int i=0;i<ChartGetInteger(0,CHART_WINDOWS_TOTAL);i++)
        {
         long m_swh=ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,i);
         if(m_wtop+m_swh>=aDparam)
           {
            aY=(int)(aDparam-m_wtop);
            break;
           }
         m_wtop=m_wtop+m_swh+2;
        }
     }
public:
   void Init(string aName="CD",color aColor=clrRed)
     {

      m_bgid="";
      m_name=aName+"_";
      m_visible=false;
      m_selected=1;
      m_tag="";
      m_subwin=0;
      m_fr.Init(m_name+"Frame",351,268,"",0);
      // standard colors radio button
      m_std_rg.Init(m_name+"STD_RG");
      m_std_rg.AddButton("",0,0);
      // HSL radio buttons
      m_hsl_rg.Init(m_name+"HSL_RG");
      m_hsl_rg.AddButton("H:",0,0);
      m_hsl_rg.AddButton("S:",0,15);
      m_hsl_rg.AddButton("L:",0,30);
      m_hsl_rg.SetValue(1);
      // HSB
      m_hsl_ih.Init(m_name+"HSL_IH",35,1,"");
      m_hsl_ih.SetMinValue(0);
      m_hsl_ih.SetMaxValue(360);
      m_hsl_ih.SetReadOnly(false);
      m_hsl_is.Init(m_name+"HSL_IS",35,1,"");
      m_hsl_is.SetMinValue(0);
      m_hsl_is.SetMaxValue(100);
      m_hsl_is.SetReadOnly(false);
      m_hsl_ib.Init(m_name+"HSL_IB",35,1,"");
      m_hsl_ib.SetMinValue(0);
      m_hsl_ib.SetMaxValue(100);
      m_hsl_ib.SetReadOnly(false);
      // RGB radio buttons
      m_rgb_rg.Init(m_name+"RGB_RG");
      m_rgb_rg.AddButton("R:",0,0);
      m_rgb_rg.AddButton("G:",0,15);
      m_rgb_rg.AddButton("B:",0,30);
      // RGB
      m_rgb_ir.Init(m_name+"RGB_IR",35,1,"");
      m_rgb_ir.SetMinValue(0);
      m_rgb_ir.SetMaxValue(255);
      m_rgb_ir.SetReadOnly(false);
      m_rgb_ig.Init(m_name+"RGB_IG",35,1,"");
      m_rgb_ig.SetMinValue(0);
      m_rgb_ig.SetMaxValue(255);
      m_rgb_ig.SetReadOnly(false);
      m_rgb_ib.Init(m_name+"RGB_IB",35,1,"");
      m_rgb_ib.SetMinValue(0);
      m_rgb_ib.SetMaxValue(255);
      m_rgb_ib.SetReadOnly(false);
      // Lab radio buttons
      m_lab_rg.Init(m_name+"Lab_RG");
      m_lab_rg.AddButton("L:",0,0);
      m_lab_rg.AddButton("a:",0,15);
      m_lab_rg.AddButton("b:",0,30);
      // RGB
      m_lab_il.Init(m_name+"Lab_IL",35,1,"");
      m_lab_il.SetMinValue(0);
      m_lab_il.SetMaxValue(100);
      m_lab_il.SetReadOnly(false);
      m_lab_ia.Init(m_name+"Lab_Ia",35,1,"");
      m_lab_ia.SetMinValue(-128);
      m_lab_ia.SetMaxValue(127);
      m_lab_ia.SetReadOnly(false);
      m_lab_ib.Init(m_name+"Lab_Ib",35,1,"");
      m_lab_ib.SetMinValue(-128);
      m_lab_ib.SetMaxValue(127);
      m_lab_ib.SetReadOnly(false);
      // buttons
      m_ok.Init(m_name+"B_OK",60,17,"OK");
      m_cancel.Init(m_name+"B_C",60,17,"Cancel");
      SetColor(aColor);
     }
   void SetColor(color aColor)
     {
      m_color=aColor;
      m_colc.ColorToRGB(m_color,m_rgb_r,m_rgb_g,m_rgb_b);
      SetRGB(m_rgb_r,m_rgb_g,m_rgb_b);
     }
   void SetPos(int aLeft,int aTop)
     {
      m_left=aLeft;
      m_top=aTop;
     }
   void SetPosLeft(int aLeft)
     {
      m_left=aLeft;
     }
   void SetPosTop(int aTop)
     {
      m_top=aTop;
     }
   void Show(int aLeft,int aTop)
     {
      SetPos(aLeft,aTop);
      Show();
     }
   void Show()
     {
      m_bgid="";
      m_lstcolor=m_color;
      m_visible=true;
      m_fr.Show(m_left,m_top);
      m_hsl_rg.Show(5+m_left,5+m_top);
      m_hsl_ih.Show(5+m_left+m_hsl_rg.Width()+10,5+m_top);
      m_hsl_is.Show(5+m_left+m_hsl_rg.Width()+10,5+m_top+15);
      m_hsl_ib.Show(5+m_left+m_hsl_rg.Width()+10,5+m_top+30);
      m_rgb_rg.Show(5+m_left,5+55+m_top);
      m_rgb_ir.Show(5+m_left+m_rgb_rg.Width()+10,5+55+m_top);
      m_rgb_ig.Show(5+m_left+m_rgb_rg.Width()+10,5+55+m_top+15);
      m_rgb_ib.Show(5+m_left+m_rgb_rg.Width()+10,5+55+m_top+30);
      m_lab_rg.Show(5+m_left,5+110+m_top);
      m_lab_il.Show(5+m_left+m_rgb_rg.Width()+10,5+110+m_top);
      m_lab_ia.Show(5+m_left+m_rgb_rg.Width()+10,5+110+m_top+15);
      m_lab_ib.Show(5+m_left+m_rgb_rg.Width()+10,5+110+m_top+30);
      w.Canvas(m_name+"Sample",m_subwin,5+m_left,m_top+170-3,60,30,clrWhite,ClrScheme.Color(40));
      w.Canvas(m_name+"Sample2",m_subwin,5+m_left+1,m_top+170+15-3,58,14,m_lstcolor,m_lstcolor);
      w.Canvas(m_name+"Sample3",m_subwin,5+m_left+15,m_top+170+33,45,15,clrWhite,ClrScheme.Color(40));
      m_std_rg.Show(5+m_left,m_top+170+33);
      m_canx1=5+m_left+65;
      m_cany1=5+m_top;
      if(m_selected!=9)
        {
         m_can.Create(m_name+"Can",m_subwin,m_canx1,m_cany1,258,258);
         m_can2.Create(m_name+"Can2",m_subwin,m_canx1+258+3,m_cany1,15,258);
         m_canexist=true;
        }
      else
        {
         m_canexist=false;
         w.Canvas(m_name+"Set",m_subwin,m_can.PosX(),m_can.PosY(),276,258,ClrScheme.Color(39),ClrScheme.Color(40));
         CreateSamples();
        }
      DrawColorPicker();
      m_ok.Show(m_left+5,m_top+246);
      m_cancel.Show(m_left+5,m_top+226);
     }
   void Hide()
     {
      m_visible=false;
      m_hsl_rg.Hide();
      m_hsl_ih.Hide();
      m_hsl_is.Hide();
      m_hsl_ib.Hide();
      m_rgb_rg.Hide();
      m_rgb_ir.Hide();
      m_rgb_ig.Hide();
      m_rgb_ib.Hide();
      m_lab_rg.Hide();
      m_lab_il.Hide();
      m_lab_ia.Hide();
      m_lab_ib.Hide();
      w.Delete(m_name+"Sample");
      w.Delete(m_name+"Sample2");
      w.Delete(m_name+"Sample3");
      w.Delete(m_name+"Set");
      for(int i=0;i<138;i++)
        {
         w.Delete(m_name+"SetSamp("+IntegerToString(i)+")");
        }
      m_std_rg.Hide();
      m_fr.Hide();
      m_ok.Hide();
      m_cancel.Hide();
      m_can.Destroy();
      m_can2.Destroy();
      ChartRedraw();
     }
   void Refresh()
     {
      if(m_visible)
        {
         Hide();
         Show();
        }
     }
   int Event(const int id,const long &lparam,const double &dparam,const string &sparam)
     {
      int m_event=0;
      if(m_hsl_ih.Event(id,lparam,dparam,sparam)!=0 || m_hsl_is.Event(id,lparam,dparam,sparam)!=0 || m_hsl_ib.Event(id,lparam,dparam,sparam)!=0)
        { // HSL
         SetHSL(m_hsl_ih.Value(),m_hsl_is.Value(),m_hsl_ib.Value());
        }
      if(m_rgb_ir.Event(id,lparam,dparam,sparam)!=0 || m_rgb_ig.Event(id,lparam,dparam,sparam)!=0 || m_rgb_ib.Event(id,lparam,dparam,sparam)!=0)
        { // RGB
         SetRGB(m_rgb_ir.Value(),m_rgb_ig.Value(),m_rgb_ib.Value());
        }
      if(m_lab_il.Event(id,lparam,dparam,sparam)!=0 || m_lab_ia.Event(id,lparam,dparam,sparam)!=0 || m_lab_ib.Event(id,lparam,dparam,sparam)!=0)
        { // Lab
         SetLAB(m_lab_il.Value(),m_lab_ia.Value(),m_lab_ib.Value());
        }
      if(id==CHARTEVENT_OBJECT_CLICK)
        {
         if(sparam==m_name+"Can")
           {
            int m_Y;
            ChartClickY(dparam,m_Y);
            ColorPick(lparam-m_can.PosX(),m_Y-m_can2.PosY());
           }
         if(sparam==m_name+"Sample2")
           {
            SetColor(m_lstcolor);
           }
         if(sparam==m_name+"Sample3")
           {
            SetColor(g.BgColor(m_name+"Sample3"));
           }
         if(StringFind(sparam,m_name+"SetSamp(",0)==0)
           {
            int m_p1=StringLen(m_name+"SetSamp(");
            int m_p2=StringFind(sparam,")",m_p1);
            int m_ind=(int)StringToInteger(StringSubstr(sparam,m_p1,m_p2-m_p1));
            SetColor(GetStdColor(m_ind));
           }
         if(sparam==m_name+"Can2")
           {
            int m_Y;
            ChartClickY(dparam,m_Y);
            ColorPick2(lparam-m_can2.PosX(),m_Y-m_can2.PosY());
           }
        }
      // change view processing
      if(m_hsl_rg.Event(id,lparam,dparam,sparam)!=0)
        {
         m_rgb_rg.SetValue(-1);
         m_lab_rg.SetValue(-1);
         m_std_rg.SetValue(-1);
         m_selected=m_hsl_rg.Value();
         DrawColorPicker();
        }
      if(m_rgb_rg.Event(id,lparam,dparam,sparam)!=0)
        {
         m_hsl_rg.SetValue(-1);
         m_lab_rg.SetValue(-1);
         m_std_rg.SetValue(-1);
         m_selected=m_rgb_rg.Value()+3;
         DrawColorPicker();
        }
      if(m_lab_rg.Event(id,lparam,dparam,sparam)!=0)
        {
         m_hsl_rg.SetValue(-1);
         m_rgb_rg.SetValue(-1);
         m_std_rg.SetValue(-1);
         m_selected=m_lab_rg.Value()+6;
         DrawColorPicker();
        }
      if(m_std_rg.Event(id,lparam,dparam,sparam)!=0)
        {
         m_rgb_rg.SetValue(-1);
         m_lab_rg.SetValue(-1);
         m_hsl_rg.SetValue(-1);
         m_selected=9;
         DrawColorPicker();
        }
      if(m_cancel.Event(id,lparam,dparam,sparam))
        {
         Hide();
         if(m_lstcolor!=m_color)
           {
            m_color=m_lstcolor;
            SetColor(m_color);
           }
        }
      if(m_ok.Event(id,lparam,dparam,sparam)==1)
        {
         m_event=1;
         Hide();
        }
      return(m_event);
     }
   void SetTag(string aTag)
     {
      m_tag=aTag;
     }
   string Tag()
     {
      return(m_tag);
     }
   int Left()
     {
      return(m_left);
     }
   int Top()
     {
      return(m_top);
     }
   int Width()
     {
      return(m_fr.Width());
     }
   int Height()
     {
      return(m_fr.Height());
     }
   bool Visible()
     {
      return(m_visible);
     }
   color Color()
     {
      return(m_color);
     }
   void SetSubWindow(int aNumber)
     {
      int m_itmp=(int)MathMax(aNumber,0);
      if(m_itmp!=m_subwin)
        {
         m_subwin=m_itmp;
         m_hsl_rg.SetSubWindow(m_subwin);
         m_hsl_ih.SetSubWindow(m_subwin);
         m_hsl_is.SetSubWindow(m_subwin);
         m_hsl_ib.SetSubWindow(m_subwin);
         m_rgb_rg.SetSubWindow(m_subwin);
         m_rgb_ir.SetSubWindow(m_subwin);
         m_rgb_ig.SetSubWindow(m_subwin);
         m_rgb_ib.SetSubWindow(m_subwin);
         m_lab_rg.SetSubWindow(m_subwin);
         m_lab_il.SetSubWindow(m_subwin);
         m_lab_ia.SetSubWindow(m_subwin);
         m_lab_ib.SetSubWindow(m_subwin);
         m_ok.SetSubWindow(m_subwin);
         m_cancel.SetSubWindow(m_subwin);
         m_fr.SetSubWindow(m_subwin);
         m_std_rg.SetSubWindow(m_subwin);
         Refresh();
        }
     }
   void SetSubWindow(string aName)
     {
      SetSubWindow(ChartWindowFind(0,aName));
     }
  };
//+------------------------------------------------------------------+
//| CColorInput                                                      |
//+------------------------------------------------------------------+
class CColorInput
  {
private:
   string            m_NameSample;
   string            m_NameLabel;
   int               m_Left;
   int               m_Top;
   int               m_Width;
   int               m_Height;
   bool              m_Visible;
   string            m_Caption;
   color             m_Color;
   int               m_SubWindow;
   color             m_BorderColor;
   color             m_LblColor;
   CColorDialog      m_cd;
   void Create()
     {
      w.Canvas(m_NameSample,m_SubWindow,m_Left,m_Top,m_Width,m_Height,m_Color,m_BorderColor);
      if(m_Caption!="")
        {
         w.Label(m_NameLabel,m_SubWindow,m_Left+m_Width+1,m_Top+2,m_Caption,m_LblColor,7,"Arial"); // label
        }
     }
   void Delete()
     {
      m_cd.Hide();
      ObjectDelete(0,m_NameSample);
      ObjectDelete(0,m_NameLabel);
     }
public:
   void Init(string aName="CColorInput",int aWidth=50,string aCaption="CInputBox",color aColor=clrRed)
     {
      m_NameSample=aName+"_S";
      m_NameLabel=aName+"_L";
      m_Left=0;
      m_Top=0;
      m_Width=aWidth;
      m_Height=15;
      m_Visible=false;
      m_Caption=aCaption;
      m_Color=aColor;
      m_LblColor=ClrScheme.Color(2);
      m_BorderColor=ClrScheme.Color(1);
      m_SubWindow=0;
      m_cd.Init(aName+"_CD",m_Color);
     }
   void SetPos(int aLeft,int aTop)
     {
      m_Left=aLeft;
      m_Top=aTop;
     }
   void SetPosLeft(int aLeft)
     {
      m_Left=aLeft;
     }
   void SetPosTop(int aTop)
     {
      m_Top=aTop;
     }
   void SetWidth(int aWidth)
     {
      m_Width=aWidth;
     }
   int Left()
     {
      return(m_Left);
     }
   int Top()
     {
      return(m_Top);
     }
   int Width()
     {
      return(m_Width);
     }
   int Height()
     {
      return(m_Height);
     }
   void Show()
     {
      m_Visible=true;
      Create();
      ChartRedraw();
     }
   void Show(int aLeft,int aTop)
     {
      SetPos(aLeft,aTop);
      Show();
     }
   void Hide()
     {
      m_Visible=false;
      Delete();
      ChartRedraw();
     }
   void Refresh()
     {
      if(m_Visible)
        {
         Delete();
         Create();
         ChartRedraw();
        }
     }
   int Event(const int id,const long  &lparam,const double  &dparam,const string  &sparam)
     { //  
      bool m_event=0;
      if(m_cd.Event(id,lparam,dparam,sparam)==1)
        {
         if(m_Color!=m_cd.Color())
           {
            m_Color=m_cd.Color();
            g.SetBgColor(m_NameSample,m_Color);
            g.Redraw();
            m_event=1;
           }
        }
      if(id==CHARTEVENT_OBJECT_CLICK)
        {
         if(sparam==m_NameSample)
           {
            if(m_cd.Visible())
              {
               m_cd.Hide();
              }
            else
              {
               int m_ocx=m_Left+m_Width/2;
               int m_ocy=m_Top+m_Height/2;
               int m_ch=(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,m_SubWindow);
               int m_cw=(int)ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,m_SubWindow);
               int m_ccx=m_cw/2;
               int m_ccy=m_ch/2;
               int m_sx,m_sy;
               if(m_ocx<=m_ccx)
                 {
                  if(m_ocy<=m_ccy)
                    {
                     m_sx=m_Left;
                     m_sy=m_Top+m_Height;
                     if(m_ch-m_sy<m_cd.Height())
                       {
                        m_sx=m_Left+m_Width;
                        m_sy=m_ch-m_cd.Height();
                        m_sy=MathMin(m_sy,m_Top);
                       }
                     if(m_cw-m_sy<m_cd.Width())
                       {
                        m_sx=m_cw-m_cd.Width();
                        if(m_sx<0)m_sx=0;
                       }
                    }
                  else
                    {
                     m_sx=m_Left;
                     m_sy=m_Top-m_cd.Height();
                     if(m_sy<0)
                       {
                        m_sx=m_Left+m_Width;
                        m_sy=0;
                        m_sy=MathMax(m_sy,m_Top+m_Height-m_cd.Height());
                       }
                     if(m_cw-m_sy<m_cd.Width())
                       {
                        m_sx=m_cw-m_cd.Width();
                        if(m_sx<0)m_sx=0;
                       }
                    }
                 }
               else
                 {
                  if(m_ocy<=m_ccy)
                    {
                     m_sx=m_Left+m_Width-m_cd.Width();
                     m_sy=m_Top+m_Height;
                     if(m_ch-m_sy<m_cd.Height())
                       {
                        m_sx=m_Left-m_cd.Width();
                        m_sy=m_ch-m_cd.Height();
                        m_sy=MathMin(m_sy,m_Top);
                       }
                     if(m_sx<0)
                       {
                        m_sx=0;
                       }
                    }
                  else
                    {
                     m_sx=m_Left+m_Width-m_cd.Width();
                     m_sy=m_sy=m_Top-m_cd.Height();
                     if(m_sy<0)
                       {
                        m_sx=m_Left-m_cd.Width();
                        m_sy=0;
                        m_sy=MathMax(m_sy,m_Top+m_Height-m_cd.Height());
                       }
                     if(m_sx<0)
                       {
                        m_sx=0;
                       }
                    }
                 }
               m_cd.Show(m_sx,m_sy);
              }
           }
        }
      return(m_event);
     }
   void SetSubWindow(int aNumber)
     {
      int m_itmp=(int)MathMax(aNumber,0);
      if(m_itmp!=m_SubWindow)
        {
         m_SubWindow=m_itmp;
         m_cd.SetSubWindow(m_itmp);
         Refresh();
        }
     }
   void SetSubWindow(string aName)
     {
      SetSubWindow(ChartWindowFind(0,aName));
     }
   void SetTag(string aValue)
     {
      m_cd.SetTag(aValue);
     }
   string Tag()
     {
      return(m_cd.Tag());
     }
   bool Visible()
     {
      return(m_Visible);
     }
   color Color()
     {
      return(m_Color);
     }
   void SetColor(color aColor)
     {
      m_Color=aColor;
      m_cd.SetColor(m_Color);
     }
  };
//+------------------------------------------------------------------+
