//+------------------------------------------------------------------+
//|                                         ytg_Def_RSI_3_Symbol.mq4 |
//|                                                     Yuriy Tokman |
//|                                            yuriytokman@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Yuriy Tokman"
#property link      "yuriytokman@gmail.com"

//           
//1 EUR-USD
//2 EURGBP
//3 EURJPY
//          

#property indicator_separate_window
#property  indicator_buffers 6
#property  indicator_color1  Green
#property  indicator_color2  Red
#property  indicator_color3  Yellow
#property indicator_level1 0
#property indicator_level2 5
#property indicator_level3 -5

extern string Symbol_1   = "EURUSD";
extern string Symbol_2   = "EURGBP";
extern string Symbol_3   = "EURJPY";

extern int RSI_1_Period  = 14;//   
extern int RSI_2_Period  = 28;//   
extern int applied_price = 0;//   0-6
extern int ma_period     = 14;// 
extern int ma_method     = 0;//   0-3

double       buf[];
double    MA_buf[];
double      buf2[];
double   MA_buf2[];
double      buf3[];
double   MA_buf3[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,2);
   SetIndexBuffer(0, buf);
   
   SetIndexStyle(4,DRAW_NONE);
   SetIndexBuffer(4,MA_buf); 
   
   SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,2);
   SetIndexBuffer(1, buf2);
   
   SetIndexStyle(3,DRAW_NONE);
   SetIndexBuffer(3,MA_buf2);   
     
   SetIndexStyle(2,DRAW_LINE,STYLE_SOLID,2);
   SetIndexBuffer(2, buf3);
   
   SetIndexStyle(5,DRAW_NONE);
   SetIndexBuffer(5,MA_buf3); 
   
   IndicatorShortName("ytg_Def_RSI_3_Symbol");
   Comment("yuriytokman@gmail.com");   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   Comment("");  
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
//----
   double RSI_1, RSI_2, RSI_12, RSI_22, RSI_13, RSI_23;
   
   int counted_bars = IndicatorCounted();
   if(counted_bars < 0)  return(-1);
   if(counted_bars > 0)   counted_bars--;
   int limit = Bars - counted_bars;
   if(counted_bars==0) limit--;

   for(int i=limit; i>=0; i--)
   {
     RSI_1 = iRSI(Symbol_1,0,RSI_1_Period,applied_price,i);
     RSI_2 = iRSI(Symbol_1,0,RSI_2_Period,applied_price,i);

     MA_buf[i] = (RSI_1-RSI_2);
     
     
     RSI_12 = iRSI(Symbol_2,0,RSI_1_Period,applied_price,i);
     RSI_22 = iRSI(Symbol_2,0,RSI_2_Period,applied_price,i);

     MA_buf2[i] = (RSI_12-RSI_22);
     
     
     RSI_13 = iRSI(Symbol_3,0,RSI_1_Period,applied_price,i);
     RSI_23 = iRSI(Symbol_3,0,RSI_2_Period,applied_price,i);

     MA_buf3[i] = (RSI_13-RSI_23);          
   }
   for(i=limit; i>=0; i--)
   {
     buf[i] = iMAOnArray(MA_buf,0,ma_period,0,ma_method,i);
     
     buf2[i] = iMAOnArray(MA_buf2,0,ma_period,0,ma_method,i);     
     
     buf3[i] = iMAOnArray(MA_buf3,0,ma_period,0,ma_method,i);    
   }   
   
   
//----
   return(0);
  }
//+------------------------------------------------------------------+