#property copyright "TheXpert"
#property link      "theforexpert@gmail.com"

#property indicator_separate_window

#property indicator_maximum 100
#property indicator_minimum 0

#property indicator_buffers 3

#property indicator_color1 DeepSkyBlue
#property indicator_color2 Red
#property indicator_color3 Khaki

//---- input parameters
extern string  RSIPeriod_Desc    =  " RSI";
extern int     RSIPeriod         =  14;
extern string  RSIPrice_Desc     =  " RSI: 0-Close, 1-Open, 2-High, 3-Low, 4-Median, 5-Typical, 6-Weighted";
extern int     RSIPrice          =  0;
extern string  HighLevel_Desc    =  "  RSI";
extern int     HighLevel         =  70;
extern string  LowLevel_Desc     =  "  RSI";
extern int     LowLevel          =  30;
extern string  MarkFalse_Desc    =  "   ,      ";
extern bool    MarkFalse         =  false;
extern string  Transparent_Desc  =  " RSI   ";
extern bool    Transparent       =  true;
extern string  Width_Desc        =  "  ";
extern int     Width             =  3;
      
//---- buffers
double RSI[];
double Inner[];
double Higher[];
double Lower[];


/// \brief Equal to ternar operator 
/// needed = Condition ? IfTrue : IfFalse;
/// \param IfTrue
/// \param IfFalse
/// \return matching value from parameters
double DoubleIf(bool Condition, double IfTrue, double IfFalse)
{
   if (Condition) return (IfTrue);
   else           return (IfFalse);
}

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   IndicatorBuffers(4);

   SetIndexBuffer(0, Higher);
   SetIndexBuffer(1, Lower);
   SetIndexBuffer(2, Inner);

   SetIndexBuffer(3, RSI);
   
   SetLevelValue(0, HighLevel);
   SetLevelValue(1, LowLevel);
   
   SetIndexLabel(0, "RSI");
   SetIndexLabel(1, " ");
   SetIndexLabel(2, " ");
   
   SetIndexStyle(0, DRAW_LINE, EMPTY, Width);
   SetIndexStyle(1, DRAW_LINE, EMPTY, Width);

   SetIndexDrawBegin(0, RSIPeriod + 1);
   SetIndexDrawBegin(1, RSIPeriod + 1);
   SetIndexDrawBegin(2, RSIPeriod + 1);   
   
   IndicatorShortName(" RSI");
   
   IndicatorDigits(2);

   return(0);
}

int start()
{
  int counted_bars = IndicatorCounted();
  if(counted_bars < 0)  return(-1);
  if(counted_bars > 0)   counted_bars--;
  int ToCount = Bars - counted_bars;
  if(counted_bars==0) ToCount-=2;
   
   for (int cnt = ToCount - 1; cnt >= 0; cnt--)
   {
      RSI[cnt] = iRSI(NULL, 0, RSIPeriod, RSIPrice, cnt);

      int depth = 2;
      if (MarkFalse)
      {
         depth = 1;
      }
      
      for (int i = cnt + depth - 1; i >= cnt; i--)
      {
         Higher[i] = EMPTY_VALUE;
         Lower[i] = EMPTY_VALUE;
      
         Inner[i] = RSI[i];
   
         if (!Transparent)
         {
            if (RSI[i] <= LowLevel)
            {
               Inner[i] = DoubleIf(RSI[i + 1] > LowLevel, LowLevel, EMPTY_VALUE);
            }
            else
            {
               Inner[i] = DoubleIf(RSI[i + 1] <= LowLevel, LowLevel, RSI[i]);
            }
   
   
            if (RSI[i] >= HighLevel)
            {
               Inner[i] = DoubleIf(RSI[i + 1] < HighLevel, HighLevel, EMPTY_VALUE);
            }
            else 
            {
               Inner[i] = DoubleIf(RSI[i + 1] >= HighLevel, HighLevel, Inner[i]);
            }
         }
         
         if(RSI[i] >= HighLevel)
         {
            Higher[i] = RSI[i];
            Higher[i + 1] = DoubleIf(RSI[i + 1] >= HighLevel, RSI[i + 1], HighLevel);
         }
         else if(RSI[i + 1] >= HighLevel)
         {
            Higher[i] = HighLevel;
            Higher[i + 1] = RSI[i + 1];
         }   


         if(RSI[i] <= LowLevel)
         {
            Lower[i] = RSI[i];
            Lower[i + 1] = DoubleIf(RSI[i + 1] <= LowLevel, RSI[i + 1], LowLevel);
         }
         else if(RSI[i + 1] <= LowLevel)
         {
            Lower[i] = LowLevel;
            Lower[i + 1] = RSI[i + 1];
         }   
      }
   }
   
   return(0);
}