//+------------------------------------------------------------------+
//|                                              iK_exp_stat_v01.mq4 |
//|                                                      Ivan Katsko |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Ivan Katsko"
#property link      ""
//--------------------------------------------------------------- 1 --
#define NONE 0

extern int ShiftMode = 0;            //    : 0 -  ; 1 - 
extern double Lots   = 0;            //   .  ("0" -   )
extern int Level     = 10;           //     
extern datetime StartDateTime = D'01.01.2009';  // 
extern datetime FinishDateTime = D'31.12.2009'; // 
extern double Prots  = 0.07;         //   
extern int SlipPage     = 3;         //   -  
 
bool 
     New_Bar=false,                  //    
     End_Bar=false,                  //   
     Cls=false,                      //   
     Work=true,                      //   .
     Opn_R=false,                    //     
     Shift_U=false,                  //    
     Shift_D=false,                  //    
     Shift_I=false,                  //    index_1
     Tag_msg1=false,                 //   1
     Tag_msg2=false,                 //   2
     Tag_msg3=true;

string Symb;                         //  . 

static datetime New_Time;

int MaxLength    = 30;               // -  

double TakeProfit =20,               //    
       StopLoss   =30,               // SL   
       algoritm      = NONE,         // : ">0" - "  "; "<0" - "   "
       sum_TP,                       //     
       direction     = NONE,         //   : ">0" - ; "<0" - 
       now_direction = NONE,         //  : ">0" - ; "<0" - 
//       Level,                        //   SL/TP
       Discret,                      //  : 1 -  ; 2 -    ..
       New_Open,                     //   
       New_SL,                       //   
       index_1=2,                    //  1  
       index_2;                      //  2  

//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
   Tag_msg1=true;                                  //   1
   New_Time=Time[0];                               //   

   switch (Period())                               //  index_2
      {
       case    5: index_2 = 0.1; break;            //  5-  
       case   15: index_2 = 0.2; break;            //  15- 
       case   30: index_2 = 0.3; break;            //  30- 
       case   60: index_2 = 0.4; break;            //  
       case  240: index_2 = 0.5; break;            //  4- 
       case 1440: index_2 = 0.6; break;            //  
       default: break; // 
      }
      
      //    
   int 
      Total,                                       //     
      Ticket,
      Tip=-1;                                      //  .  (B=0,S=1)
   double 
      TP,
      SL,
      Price;                                       //   
      Symb=Symbol();                               //  ..

   for(int i=1; i<=OrdersTotal(); i++)             //   
     {
      if (OrderSelect(i-1,SELECT_BY_POS)==true)    //   
        {                                          //  :
         if (OrderSymbol()!=Symb)continue;         //   . 
         if (OrderType()>1)                        //  
           {
            Alert("  .   .",": ",Symb,", ",Period());
            return;                                //   start()
           }
         Total++;                                  //  . 
         if (Total>1)                              //    
           {
            Alert("  .   .",": ",Symb,", ",Period());
            return;                                //   start()
           }
         Ticket =OrderTicket();                    //  . .
         Tip    =OrderType();                      //   .
         Price  =OrderOpenPrice();                 //  . .
         SL     =OrderStopLoss();                  // SL  .
         TP     =OrderTakeProfit();                // TP  .
        }
     }
     
   if (Level<MarketInfo(Symb,MODE_STOPLEVEL)) 
      Level=MarketInfo(Symb,MODE_STOPLEVEL);       //   SL/TP
   Discret=1;                                      //   
   
   if (Total==0) Opn_R=false;                      //      

   if (Ticket>0                                    //    
       && ShiftMode==0)                            //    
     {
      New_Open=Price;                              //     
      New_SL=SL;                                   //     SL
      Alert(".   . TP=",TP,", SL=",SL,": ",Symb,", ",Period());
     } 
   if (Ticket>0                                    //    
       && ShiftMode==1)                            //   
     {
         //    
      if (MathAbs(Price-TP)/Point < 500
          && Tip==0)
        TP=Price + New_Stop(TakeProfit+1000)*Point;
         
      if (MathAbs(Price-TP)/Point < 500
          && Tip==1)
        TP=Price - New_Stop(TakeProfit+1000)*Point;
         
      if (OrderModify(Ticket,Price,SL,TP,0))
        {
         Alert(".  . TP=",TP,", SL=",SL,": ",Symb,", ",Period());
        }
        else
        {
         Alert(".   ,  ",GetLastError(),": ",Symb,", ",Period());
        }
        
         //  New_Open  New_SL  
      New_Open=0;
      New_SL=0;
       
      if (Tip==0)                                           //    
        {                                                   //  
         New_Open=Price + New_Stop(TakeProfit)*Point;       //     
         New_SL=SL;                                         //     SL
         if (Bid>New_Open)                                  //     
           {
           New_Open=Bid;                                    //    
           New_SL=New_Open                                  //    
                  -(3*MarketInfo(Symb,MODE_SPREAD)*Point    //     2  
                  +index_2*(New_Open-(Price+(TakeProfit     //  0.1 ()
                  -MarketInfo(Symb, MODE_SPREAD))*Point))); //   
           }
        }
      if (Tip==1)                                           //    
        {                                                   //  
         New_Open=Price - New_Stop(TakeProfit)*Point;       //     
         New_SL=SL;                                         //     SL
         if (Ask<New_Open)                                  //      
           {
            New_Open=Ask;                                   //    
            New_SL=New_Open                                 //    
                   +(3*MarketInfo(Symb,MODE_SPREAD)*Point   //     2  
                   -index_2*(New_Open-(Price-(TakeProfit    //   ()
                   +MarketInfo(Symb, MODE_SPREAD))*Point)));//   
           }
        }
      Alert("  New_Open=",New_Open,", New_SL=",New_SL,": ",Symb,", ",Period());
       
            //      
      ObjectDelete("New_Open"); 
      ObjectCreate("New_Open", OBJ_HLINE, 0 , 0, New_Open);
      ObjectDelete("New_SL"); 
      ObjectCreate("New_SL", OBJ_HLINE, 0 , 0, New_SL);
     }                                                      //   
  }
  
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
      //    
   int 
      Total,                                       //     
      Tip=-1,                                      //  .  (B=0,S=1)
      Ticket;
   double 
      TP,
      SL,
      Price;                                       //   
      Symb=Symbol();                               //  ..

   for(int i=1; i<=OrdersTotal(); i++)             //   
     {
      if (OrderSelect(i-1,SELECT_BY_POS)==true)    //   
        {                                          //  :
         if (OrderSymbol()!=Symb)continue;         //   . 
         if (OrderType()>1)                        //  
           {
            Alert("  .   .",": ",Symb,", ",Period());
            return;                                //   start()
           }
         Total++;                                  //  . 
         if (Total>1)                              //    
           {
            Alert("  .   .",": ",Symb,", ",Period());
            return;                                //   start()
           }
         Ticket =OrderTicket();                    //  . .
         Tip    =OrderType();                      //   .
         Price  =OrderOpenPrice();                 //  . .
         SL     =OrderStopLoss();                  // SL  .
        }
     }
        
   if (Ticket>0                        //    
       && ShiftMode==1)                //   
     {
      //----      
      if (Tip==0                       //     ,
          && !(Shift_U||Shift_D))      //   ,
         TP=Ask + New_Stop(TakeProfit)*Point;
         
      if (Tip==1                       //     ,
          && !(Shift_U||Shift_D))      //   ,
         TP=Bid -  New_Stop(TakeProfit)*Point;
        
      //----      
      if (Tip==0                       //     ,
          && (Shift_U||Shift_D))       //  ,
        {
         TP=New_Open + New_Stop(TakeProfit)*Point;
         SL=New_SL;
        }
      if (Tip==1                       //     ,
          && (Shift_U||Shift_D))       //  ,
        {
         TP=New_Open -  New_Stop(TakeProfit)*Point;
         SL=New_SL;
        }
        
      //----      
      if (OrderModify(Ticket,Price,SL,TP,0))
        {
         Alert(".  . TP=",TP,", SL=",SL,": ",Symb,", ",Period());
         return;
        }
         else
        {
         Alert(".   ,  ",GetLastError(),": ",Symb,", ",Period());
        }
     }                                 //   
   ObjectDelete("New_Open"); 
   ObjectDelete("New_SL"); 
   return(0);
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
   Fun_New_Bar();                      //    
//----
   int
      Total,                           //     
      Tip=-1,                          //  .  (B=0,S=1)
      Ticket;                          //  
   datetime 
      Time_Begin,                      //    
      Op_Time;                         //   
   double
      Lot,                             // .    
      Lts,                             // .    
      Min_Lot,                         //   
      Step,                            //    
      Free,                            //   
      One_Lot,                         //   
      Price,                           //   
      SL,                              // SL   
      TP;                              // TP  
   bool
      Ans  =false,                     //    
      Opn_B=false,                     //     Buy
      Opn_S=false;                     //     Sell
      
   Cls  =false;                        //   
   Time_Begin=GetTickCount();          //     

//-------------------      --
   if (New_Bar)                        //      
     {
      Tag_msg1=true;
      End_Bar=false;
//      Opn_R=true;
      
      // .
      if(TimeCurrent()<StartDateTime)            //    
        { 
        Alert("   .   .",": ",Symb,", ",Period());
        return;                                  //   start()
        }            
      if (TimeCurrent()>=FinishDateTime)         //  
        { 
        Alert("  .   .",": ",Symb,", ",Period());
        return;                                  //   start()
        }            
      if(Bars < MaxLength)                       //  
        {
         Alert("   .   .",": ",Symb,", ",Period());
         return;                                 //   start()
        }
      if(Work==false)                            //  
        {
         Alert(" .   .",": ",Symb,", ",Period());
         return;                                 //   start()
        }
     }
//-------------------       --
   
   if ((TimeCurrent()-Time[0]-50)>(Period()-1)*60 // 10    
       && Tag_msg1
       ) 
     { 
      Alert("!   !",": ",Symb,", ",Period());
      Tag_msg1=false;
      End_Bar=true;
     }

//-----------------------  
   Symb=Symbol();                               //  ..
   Total=0;                                     //  
   for(int i=1; i<=OrdersTotal(); i++)          //   
     {
      if (OrderSelect(i-1,SELECT_BY_POS)==true) //   
        {                                       //  :
         if (OrderSymbol()!=Symb)continue;      //   . 
         if (OrderType()>1)                     //  
           {
            Alert("  .   .",": ",Symb,", ",Period());
            return;                             //   start()
           }
         Total++;                               //  . 
         if (Total>1)                           //    
           {
            Alert("  .   .",": ",Symb,", ",Period());
            return;                             //   start()
           }
         Ticket =OrderTicket();                 //  . .
         Op_Time=OrderOpenTime();               //   ..
         Tip    =OrderType();                   //   .
         Price  =OrderOpenPrice();              //  . .
         SL     =OrderStopLoss();               // SL  .
         TP     =OrderTakeProfit();             // TP  .
         Lot    =OrderLots();                   //  
        }
     }
     
                     //  
   TakeProfit = iCustom(0, 0, "iK_tay_v01",Discret, Level, 0, 1)/Point;  //  
   StopLoss   = iCustom(0, 0, "iK_tay_v01",Discret, Level, 1, 1)/Point;  //  
   algoritm   = iCustom(0, 0, "iK_tay_v01",Discret, Level, 4, 1);        //  
   sum_TP     = iCustom(0, 0, "iK_tay_v01",Discret, Level, 2, 1);        
   direction  = iCustom(0, 0, "iK_tay_v01",Discret, Level, 3, 1);        //  
   now_direction = iCustom(0, 0, "iK_tay_v01",Discret, Level, 3, 0);     //  
      
   if (New_Bar)                                  //    
     {
      if (Total==0)                              //    
         Opn_R=true;                             //   
        else                                     //    
         Opn_R=false;                            //   (  )
     }
      
   if (Total==0)                                 //    
     {
      Cls=false;                                 //   
      Shift_U=false;                             //     
      Shift_D=false;                             //     
      ObjectDelete("New_Open");                  //  
      ObjectDelete("New_SL"); 
     }
        
   if (direction==NONE && New_Bar)               //   
     {
      Cls = true;                                //   
      Alert("   ",": ",Symb,", ",Period());
     }
   if ((direction==NONE && Total==0) ||          //     
       (sum_TP<=0 && Total==0))                  //    
     { 
      Opn_R=false;                               //      
      return;                                    //  start()
     }            
         //   
   if (Total==0                                    //   ,
       && direction!=0                             //  ,
       && Opn_R)                                   //       
     {
      if (direction>0)                             //   , 
        {
         Opn_B=true;                               //     Buy
        }
       else                                        //   -
        {                             
         Opn_S=true;                               //  Sell
        }
     }
   
         //      
   if (Total>0                                  //   ,
       && End_Bar                               //   
//       && Op_Time<Time[0]                     //     
       && !(Shift_U||Shift_D)                   //   
       && ((direction!=now_direction)           //     
         || (direction==0 && now_direction==0)))//   
     {
      Cls = true;                               //   
     }

         //      
   if (Total>0                                  //    ,
       && ShiftMode==1)                         //   
     {
      if (Tip==0                                //    
          && Bid>New_Open)                      //  
        {                                       //    
         index_1=3; 
         switch (Period())                               //  index_2
            {
             case    5: index_2 = 0.1; break;            //  5-  
             case   15: index_2 = 0.2; break;            //  15- 
             case   30: index_2 = 0.3; break;            //  30- 
             case   60: index_2 = 0.4; break;            //  
             case  240: index_2 = 0.5; break;            //  4- 
             case 1440: index_2 = 0.6; break;            //  
             default: break; // 
            }
         New_Open=Bid;                          //    
         New_SL=New_Open                        //    
               -(index_1*MarketInfo(Symb,MODE_SPREAD)*Point   //     2  
               +index_2*(New_Open-(Price+(TakeProfit          //  0.1 ()
               -MarketInfo(Symb, MODE_SPREAD))*Point)));      //   
         Shift_U=true;
         Alert("    ",New_Open,", New_SL=",New_SL,": ",Symb,", ",Period());
        }
      if (Tip==1                               //    
          && Ask<New_Open)                     //  
        {                                      //    
         index_1=3; 
         switch (Period())                               //  index_2
            {
             case    5: index_2 = 0.1; break;            //  5-  
             case   15: index_2 = 0.2; break;            //  15- 
             case   30: index_2 = 0.3; break;            //  30- 
             case   60: index_2 = 0.4; break;            //  
             case  240: index_2 = 0.5; break;            //  4- 
             case 1440: index_2 = 0.6; break;            //  
             default: break; // 
            }
         New_Open=Ask;                                        //    
         New_SL=New_Open                                      //    
               +(index_1*MarketInfo(Symb,MODE_SPREAD)*Point   //     2  
               -index_2*(New_Open-(Price-(TakeProfit          //  0.1 ()
               +MarketInfo(Symb, MODE_SPREAD))*Point)));      //   
         Shift_D=true;
         Alert("    ",New_Open,", New_SL=",New_SL,": ",Symb,", ",Period());
        }
               //     
      index_1=0.99*index_1;
      index_2=0.99*index_2;
      if (Tip==0                                           //    
          && (Shift_D || Shift_U))                         //   
        {                                                  //    
         New_SL=New_Open                                   //    
               -(index_1*MarketInfo(Symb,MODE_SPREAD)*Point//     2  
               +index_2*(New_Open-(Price+(TakeProfit       //  0.1 ()
               -MarketInfo(Symb, MODE_SPREAD))*Point)));   //   
        }
      if (Tip==1                                           //    
          && (Shift_D || Shift_U))                         //   
        {                                                  //    
         New_SL=New_Open                                   //    
               +(index_1*MarketInfo(Symb,MODE_SPREAD)*Point//     2  
               -index_2*(New_Open-(Price-(TakeProfit       //  0.1 ()
               -MarketInfo(Symb, MODE_SPREAD))*Point)));   //   
        }
        
            //      
      ObjectDelete("New_Open"); 
      ObjectCreate("New_Open", OBJ_HLINE, 0 , 0, New_Open);
      ObjectDelete("New_SL"); 
      ObjectCreate("New_SL", OBJ_HLINE, 0 , 0, New_SL);
     }

//--------------------------------------------------------------- 7 --
   //  
   RefreshRates();                              //  
   Min_Lot=MarketInfo(Symb,MODE_MINLOT);        // . .  
   Free   =AccountFreeMargin();                 //  
   One_Lot=MarketInfo(Symb,MODE_MARGINREQUIRED);//  1 
   Step   =MarketInfo(Symb,MODE_LOTSTEP);       //   
 
   if (Lots > 0)                                //   , 
      Lts =Lots;                                //     
   else                                         // %  
      Lts=MathFloor(Free*Prots/One_Lot/Step)*Step;//  
 
   if(Lts < Min_Lot) Lts=Min_Lot;               //   
   
   if (Lts*One_Lot > Free &&                    //   .
      TimeCurrent()<(Time[0] + 2*60) &&         //     2- 
      Total==0)                                 //    
     {
      Alert("     ", Lts," ",": ",Symb,", ",Period());
      return;                                   //   start()
     }

   //     
   if (((Tip==0)                                //    
       && Shift_U                               //   
       && (Bid<New_SL)) ||                      //       
       ((Tip==1)                                //    
       && Shift_D                               //   
       && (Ask>New_SL)))                        //      
     {                                          
      Cls = true;                               //   
      Opn_R=false;                              //       
     }

//--------------------------------------------------------------- 6 --
   //  
   while(Ticket>0)                              //   .
     {
      if (Tip==0 && Cls==true)                  //   Buy..
        {                                       //    
         Alert("  Buy ",Ticket,".  ..",": ",Symb,", ",Period());
         RefreshRates();                        //  
         Ans=OrderClose(Ticket,Lot,Bid,2);      //  Buy
         if (Ans==true)                         //  :)
           {
            Alert ("  Buy ",Ticket,": ",Symb,", ",Period());
            break;                              //    
           }
         if (Fun_Error(GetLastError())==1)      //  
           {
            Opn_R=false;                        //       
            continue;                           //  
           }
         return;                                //   start()
        }
 
      if (Tip==1 && Cls==true)                  //   Sell..
        {                                       //    
         Alert("  Sell ",Ticket,".  ..",": ",Symb,", ",Period());
         RefreshRates();                        //  
         Ans=OrderClose(Ticket,Lot,Ask,2);      //  Sell
         if (Ans==true)                         //  :)
           {
            Alert ("  Sell ",Ticket,": ",Symb,", ",Period());
            break;                              //    
           }
         if (Fun_Error(GetLastError())==1)      //  
           {
            Opn_R=false;                        //       
            continue;                           //  
           }
         return;                                //   start()
        }
      break;                                    //   while
     }
   
//--------------------------------------------------------------- 8 --
   //  
   while(Opn_R)                                 //   .
     {
      if (Total==0 && Opn_B==true)              //  .  +
        {                                       //  . Buy
         RefreshRates();                        //  
         SL=Ask - New_Stop(StopLoss)*Point;     //  SL .
         if (ShiftMode==0)                      //  TP .
           {TP=Ask + New_Stop(TakeProfit)*Point;}
           else
           {TP=Ask + New_Stop(TakeProfit+1000)*Point;}
         Alert("  Buy.  ..",": ",Symb,", ",Period());
         Ticket=OrderSend(Symb,OP_BUY,Lts,Ask,2,SL,TP);// Buy
         if (Ticket > 0)                        //  :)
           {
            New_Open=Ask + New_Stop(TakeProfit)*Point; //   
            New_SL=SL;                          //   
            Opn_R=false;                        //       
            Alert ("  Buy ",Ticket,": ",Symb,", ",Period());
            return;                             //   start()
           }
         if (Fun_Error(GetLastError())==1)      //  
            continue;                           //  
         return;                                //   start()
        }
      if (Total==0 && Opn_S==true)              //  .  +
        {                                       //  . Sell
         RefreshRates();                        //  
         SL=Bid + New_Stop(StopLoss)*Point;     //  SL .
         if (ShiftMode==0)                      //  TP .
           {TP=Bid -  New_Stop(TakeProfit)*Point;}
           else
           {TP=Bid -  New_Stop(TakeProfit+1000)*Point;}
         Alert("  Sell.  ..",": ",Symb,", ",Period());
         Ticket=OrderSend(Symb,OP_SELL,Lts,Bid,2,SL,TP);// Sel
         if (Ticket > 0)                        //  :)
           {
            New_Open=Bid -  New_Stop(TakeProfit)*Point; //   
            New_SL=SL;                          //   
            Opn_R=false;                        //       
            Alert ("  Sell ",Ticket,": ",Symb,", ",Period());
            return;                             //   start()
           }
         if (Fun_Error(GetLastError())==1)      //  
            continue;                           //  
         return;                                //   start()
        }
      break;                                    //   while
     }   
//----
   return;                                      //   start()
  }
//-------------------------------------------------------------- 10 --
int Fun_Error(int Error)                        // -  
  {
   switch(Error)
     {                                          //              
      case  4: Alert("  .   ..",": ",Symb,", ",Period());
         Sleep(3000);                           //  
         return(1);                             //   
      case 130:Alert("  ",": ",Symb,", ",Period());
         Level++;                               //    SL/TP
         Opn_R=false;                           //      
//         Sleep(5000);                           //  
         return(1);                             //   
      case 135:Alert(" .   ..",": ",Symb,", ",Period());
         RefreshRates();                        //  
         return(1);                             //   
      case 136:Alert(" .   ..",": ",Symb,", ",Period());
         while(RefreshRates()==false)           //   
            Sleep(1);                           //   
         return(1);                             //   
      case 137:Alert(" .   ..",": ",Symb,", ",Period());
         Sleep(3000);                           //  
         return(1);                             //   
      case 138:Alert("  ..",": ",Symb,", ",Period());
         return(1);                             //   
      case 145:Alert("     .   15.",": ",Symb,", ",Period());
         Cls = false;
//         Sleep(15000);                        //  
         return(1);                             //   
      case 146:Alert("  .  ..",": ",Symb,", ",Period());
         Sleep(500);                            //  
         return(1);                             //   
         //  
      case  2: Alert(" .",": ",Symb,", ",Period());
         return(0);                             //   
      case  5: Alert("  .",": ",Symb,", ",Period());
         Work=false;                            //   
         return(0);                             //   
      case 64: Alert(" .",": ",Symb,", ",Period());
         Work=false;                            //   
         return(0);                             //   
      case 133:Alert(" .",": ",Symb,", ",Period());
         return(0);                             //   
      case 134:Alert("    .",": ",Symb,", ",Period());
         return(0);                             //   
      default: Alert("  ",Error,": ",Symb,", ",Period()); //     
         return(0);                             //   
     }
  }
//-------------------------------------------------------------- 11 --
int New_Stop(int Parametr)                      //  -.
  {
   int Min_Dist=MarketInfo(Symb,MODE_STOPLEVEL);// . 
   if (Parametr < Min_Dist)                     //   .
     {
      Parametr=Min_Dist;                        //  .
     }
   return(Parametr);                            //  
  }
//+------------------------------------------------------------------+
void Fun_New_Bar()                              // -   
  {                                             
   New_Bar=false;                               //   
   if(New_Time!=Time[0])                        //  
     {
      New_Time=Time[0];                         //   
      New_Bar=true;                             //     
     }
  }
//-------------------------------------------------------------- 12 --

