//Test_dlnn.mq4

#include <dlnn.mqh>

#define LayerCount  	3 //  (    )
#define InputCount  	2 //    
#define OutputCount  1 //    
#define PatternCount 4 // 
//      
//   XOR
//  -----------------------------------
//     1  |    2   |  
//  -----------------------------------
//      1           1            0
//      1           0            1
//      0           1            1
//      0           0            0
//  -----------------------------------
//  
double InMatrix[PatternCount][InputCount]={1, 1, 1, 0, 0, 1, 0, 0}; 
//  
double OutMatrix[PatternCount] = {0, 1, 1, 0};
//     
int LayersStruct[LayerCount] = {InputCount, 2, OutputCount}; 

int start()
{
//----
	int r, nn, e, l, ns;
	string sn1="\n", sn="\n";
	string sf="net_for_example";
	double q;
	double Alpha = 1;
	double Moment = 0.9;
	double StartSpeed = 0.5;
	double FinishSpeed = 0.1;
	int EpohCount=100000;	
	double Kerror = 0.005;
//----
	nn=-1;
	nn=CreateNN(LayerCount, LayersStruct, Alpha, Moment, StartSpeed, FinishSpeed);
	if(nn<0){Comment(" "+nn+"   "); return(0);}
	sn=sn+"    "+nn+"\n";
	r=TrainNN(nn, PatternCount, InMatrix, OutMatrix, EpohCount, Kerror);
	if(r<0){Comment(sn," "+r+"   "); return(0);}
	sn=sn+"  (="+GetEpohNN(nn)+"; ="+DoubleToStr(GetErrorNN(nn),3)+")\n: ";
	
	double OutputM[1];
	double InputM[InputCount];

	InputM[0] = 1;
	InputM[1] = 1;//  
	RunNN(nn, InputM, OutputM);//
	// 
	sn=sn+DoubleToStr(InputM[0],0)+"  "+DoubleToStr(InputM[1],0)+" = "+DoubleToStr(OutputM[0],2);

	InputM[0] = 0;
	InputM[1] = 1;//  
	RunNN(nn, InputM, OutputM);//
	// 
	sn=sn+" //  "+DoubleToStr(InputM[0],0)+"  "+DoubleToStr(InputM[1],0)+" = "+DoubleToStr(OutputM[0],2);

	InputM[0] = 1;
	InputM[1] = 0;//  
	RunNN(nn, InputM, OutputM);//
	// 
	sn=sn+" //  "+DoubleToStr(InputM[0],0)+"  "+DoubleToStr(InputM[1],0)+" = "+DoubleToStr(OutputM[0],2);
			
	InputM[0] = 0;
	InputM[1] = 0;//  
	RunNN(nn, InputM, OutputM);//
	// 
	sn=sn+" //  "+DoubleToStr(InputM[0],0)+"  "+DoubleToStr(InputM[1],0)+" = "+DoubleToStr(OutputM[0],2)+"\n";
//----
	r=SaveNN(nn,sf);
	if(r<0)	{Comment(sn," "+r+"   "); return(0);}
	sn=sn+"    "+sf+"\n";
	r=DestroyNN(nn);
	if(r<0)	{Comment(sn," "+r+"   "); return(0);}
	sn=sn+" \n";
//----
	nn=LoadNN(sf);	
	if(nn<0) {Comment(sn," "+nn+"     "); return(0);}
	sn1=sn1+"    "+sf+".   "+nn+"\n";
	l=GetLayersNN(nn);
	sn1=sn1+" : = "+l+";   =";
	for(int i=0; i<l; i++) sn1=sn1+" "+GetNeuronsNN(nn,i);
	sn1=sn1+"\n: ";
	
	InputM[0] = 1;
	InputM[1] = 1;//  
	RunNN(nn, InputM, OutputM);//
	// 
	sn1=sn1+DoubleToStr(InputM[0],0)+"  "+DoubleToStr(InputM[1],0)+" = "+DoubleToStr(OutputM[0],2);

	InputM[0] = 0;
	InputM[1] = 1;//  
	RunNN(nn, InputM, OutputM);	//
	// 
	sn1=sn1+" //  "+DoubleToStr(InputM[0],0)+"  "+DoubleToStr(InputM[1],0)+" = "+DoubleToStr(OutputM[0],2);

	InputM[0] = 1;
	InputM[1] = 0;//  
	RunNN(nn, InputM, OutputM);	//
	// 
	sn1=sn1+" //  "+DoubleToStr(InputM[0],0)+"  "+DoubleToStr(InputM[1],0)+" = "+DoubleToStr(OutputM[0],2);
			
	InputM[0] = 0;
	InputM[1] = 0;//  
	RunNN(nn, InputM, OutputM);//
	// 
	sn1=sn1+" //  "+DoubleToStr(InputM[0],0)+"  "+DoubleToStr(InputM[1],0)+" = "+DoubleToStr(OutputM[0],2)+"\n";
//----
	r=DestroyNN(nn);
	Comment(sn, sn1, "\nFinish...");	
   return(0);
}

