//-------------------------------------------------------------------------//
//               //
//  neuronet.dll                                                           //
//      -      //
//      -   1/(1+exp(-alpha*NET))       //
//                 //
//-------------------------------------------------------------------------//
//       ,           //
//    .      .   //
//-------------------------------------------------------------------------//
//   :  . .  E-mail: gra12@mail.ru                            //
//-------------------------------------------------------------------------//
#ifndef neuronetH
#define neuronetH

//  
#define NoNetError              0
#define ErrorPatternCount       1
#define ErrorLayersStructure    2
#define ErrorInPattern          3
#define ErrorOutPattern         4
#define ErrorInput              5
#define ErrorOutput             6
#define ErrorOnCalculation      7
#define ErrorOnTeach            8
#define ErrorOnSave             9
#define ErrorOnLoad             10
#define TeachStopped            31

//  
struct TNeuron
 {
 float* Weight;                 //    ()
 float* prevDWeight;            //    
 int countW;                    // 
 float K;                       //
 float Out;                     //
 float Q;                       // 
 float prevDQ;                  //  
 int N;                         // 
 };

//  
struct TNeuroNet
 {
 TNeuron* Neurons;
 float Alpha;                   // ( )
 float Moment;                  // ()
 float StartSpeed;              //  
 float FinishSpeed;             //  
 int* LayersStructure;          //   
 //LayersStructure -   ,        ,
 //    
 int SizeLayersStructure;       // 
 //SizeLayersStructure -   (  LayersStructure)
 };

typedef bool (__stdcall *TCallbackFunction) (int Epoh, float QError, TNeuroNet* Net);

//      
typedef int ( __stdcall *TTeach)(TNeuroNet* Net, float* InPattern,
        float* OutPattern, int PatternCount, int EpohCount, TCallbackFunction CallbackFunction);

//:
//Net -    TNeuroNet.
//!!!      Neurons      NULL !!!
//InPattern -      
//OutPattern -      
//!!!           0  1 ()!!!
//PatternCount -   
//EpohCount -   
//CallbackFunction -   ,        ,
//      ,       NULL
  // :
// 0 (NoNetError) -   ,
// 31 (TeachStopped) -    
//   -      


//  
typedef int ( __stdcall *TCalculate)(TNeuroNet* Net, float* In, float* Out);
//__declspec(dllimport)  int Calculate(TNeuroNet* Net, float* In, float* Out);
//:
//Net -    TNeuroNet
//Input -     
//Output -     
//!!!    In  Out         !!!
  // :
// 0 -     
//   -      


//   
typedef void ( __stdcall *TDeleteNet)(TNeuroNet* Net);
//:
//Net -    TNeuroNet


//  
typedef int ( __stdcall *TSaveNet)(TNeuroNet* Net, char* FileName);
//:
//Net -    TNeuroNet
//FileName -  
  // :
// 0 -   
//   -      


//  
typedef int ( __stdcall *TLoadNet)(TNeuroNet* Net, char* FileName);
//:
//Net -    TNeuroNet
//FileName -  
  // :
// 0 -   
//   -      


//   
//*/
bool __stdcall CallbackFunction(int Epoh, float QError, TNeuroNet* Net);
//
//  :
//Epoh -   
//QError -    
//Net -    TNeuroNet
  // :
// true -  
// false -  
#endif
