// dlnn.cpp:      DLL.

#include "stdafx.h"
#include "dlnn.h"
#include "stdlib.h"
#include "stdio.h"
#include <time.h>

#pragma hdrstop
//----
#include "neuronet.h"

HINSTANCE Hneuronetdll;
bool LoadedDLL=false;
int LoadLibraryError=0;
TDeleteNet fDeleteNet=NULL;
TCalculate fCalculate=NULL;
TTeach fTeach=NULL;
TSaveNet fSaveNet=NULL;
TLoadNet fLoadNet=NULL;

BOOL APIENTRY DllMain( HMODULE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		{
			if(LoadedDLL)return true;
			Hneuronetdll=LoadLibraryA("neuronet.dll");
			if(Hneuronetdll!=NULL)
			{
				LoadedDLL=true;
				fDeleteNet=(TDeleteNet)GetProcAddress((HMODULE)Hneuronetdll,"DeleteNet");
				fCalculate=(TCalculate)GetProcAddress((HMODULE)Hneuronetdll,"Calculate");
				fTeach=(TTeach)GetProcAddress((HMODULE)Hneuronetdll,"Teach");
				fSaveNet=(TSaveNet)GetProcAddress((HMODULE)Hneuronetdll,"SaveNet");
				fLoadNet=(TLoadNet)GetProcAddress((HMODULE)Hneuronetdll,"LoadNet");
			}else LoadLibraryError=GetLastError();
		}
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
			break;
		case DLL_PROCESS_DETACH:
		{
			FreeLibrary(Hneuronetdll);
			LoadedDLL=false;
			break;
		}
	}
	return true;
}
//-----
#define MAX_LAYER 4				//  
#define MAX_IN 50				//     
#define MAX_OUT 4				//   
#define MAX_NET	10				// - 
//  
struct Network
{
 TNeuroNet Net;
 int State;						//0 -  ; 1 -  ; 2 -   3-  
 float Kerror;					//  
 int CntEpoh;					//    
 float Qerror;					//  
 time_t Etime;					//  
 float* In;						// 
 float* Out;					// 
};
//-----
Network mn[MAX_NET];
int ce, cn;
float qe;

//C  
//    0  MAX_NET-1  -Error       
// -(    )
NNFORMQL_API int __stdcall  CreateNN(const int Layers, const int *Neurons, 
									 const double Alpha, const double Moment,
									 const double StartSpeed, const double FinishSpeed)
{
	int nn, i;
	if(!LoadedDLL)return -LoadLibraryError;
	if(Neurons==NULL || Layers<2 || Layers>MAX_LAYER 
		|| Neurons[Layers-1]>MAX_OUT) return ErrorIncorrectParam;
	for(i=0; i<Layers-1; i++) if(Neurons[i]>MAX_IN) return ErrorIncorrectParam;
	nn=ErrorNetNotFound;//     
	for(i=0; i<MAX_NET; i++) if(mn[i].State==0){nn=i; break;}
	if(nn>=0)
	{	// 
		mn[nn].Net.Neurons=NULL;
		mn[nn].Net.SizeLayersStructure=Layers;
		mn[nn].Net.LayersStructure=new int[Layers];
		for(i=0; i<Layers; i++) mn[nn].Net.LayersStructure[i]=Neurons[i];
		mn[nn].Net.Alpha=(float)Alpha;
		mn[nn].Net.Moment=(float)Moment;
		mn[nn].Net.StartSpeed=(float)StartSpeed;
		mn[nn].Net.FinishSpeed=(float)FinishSpeed;
		mn[nn].Kerror=(float)0;
		mn[nn].State=1;
		mn[nn].In=new float[mn[nn].Net.LayersStructure[0]];
		mn[nn].Out=new float[mn[nn].Net.LayersStructure[mn[nn].Net.SizeLayersStructure-1]];
	}
	return nn;
}
//  -  
NNFORMQL_API int __stdcall  GetEpohNN(const int nn)
{
	if(nn<0 || nn>MAX_NET-1) return ErrorIncorrectParam;
	int r=ErrorNetNotFound;
	if(mn[nn].State>0) r=mn[nn].CntEpoh;
	return r;
}
//   
NNFORMQL_API double __stdcall  GetErrorNN(const int nn)
{
	if(nn<0 || nn>MAX_NET-1) return ErrorIncorrectParam;
	double r=ErrorNetNotFound;
	if(mn[nn].State>0) r=(double)mn[nn].Qerror;
	return r;
}
//  -   
NNFORMQL_API int __stdcall  GetLayersNN(const int nn)
{
	if(nn<0 || nn>MAX_NET-1) return ErrorIncorrectParam;
	int r=ErrorNetNotFound;
	if(mn[nn].State>0) r=mn[nn].Net.SizeLayersStructure;
	return r;
}
//  -     
NNFORMQL_API int __stdcall  GetNeuronsNN(const int nn, const int Layers)
{
	if(nn<0 || nn>MAX_NET-1) return ErrorIncorrectParam;
	if(Layers<0 || Layers>mn[nn].Net.SizeLayersStructure-1) return ErrorIncorrectParam;
	int r=ErrorNetNotFound;
	if(mn[nn].State>0) r=mn[nn].Net.LayersStructure[Layers];
	return r;
}
//    nn
NNFORMQL_API int __stdcall  DestroyNN(const int nn)
{
	if(nn<0 || nn>MAX_NET-1) return ErrorIncorrectParam;
	int r=ErrorNetNotFound;
	if(mn[nn].State>0)
		{
			r=0;
			if(LoadedDLL)(*fDeleteNet)(&mn[nn].Net);
			else r=-LoadLibraryError;
			delete[]mn[nn].In;
			delete[]mn[nn].Out;
			if(mn[nn].State<3)delete[]mn[nn].Net.LayersStructure;
			mn[nn].State=0;
		}
	return r;
}
//   
NNFORMQL_API int __stdcall  SaveNN(const int nn, char *FileName)
{
	if(nn<0 || nn>MAX_NET-1) return ErrorIncorrectParam;
	int r=-ErrorNetNotFound;
	if(mn[nn].State==2) 
		if(LoadedDLL) r=(*fSaveNet)(&mn[nn].Net, FileName); 
		else r=LoadLibraryError;
	return -r;
}
//   
NNFORMQL_API int __stdcall  LoadNN(char *FileName)
{
	if(!LoadedDLL)return -LoadLibraryError;
	int nn, i, r;
	nn=ErrorNetNotFound;
	//     
	for(i=0; i<MAX_NET; i++) if(mn[i].State==0){nn=i; break;}
	if(nn>=0)
	{
		r=(*fLoadNet)(&mn[nn].Net, FileName);
		if(r==0)
		{
			mn[nn].State=3;
			mn[nn].Kerror=(float)0;
			mn[nn].In=new float[mn[nn].Net.LayersStructure[0]];
			mn[nn].Out=new float[mn[nn].Net.LayersStructure[mn[nn].Net.SizeLayersStructure-1]];
		}else nn=-r;
	}
	return nn;
}
//  
NNFORMQL_API int __stdcall  RunNN(const int nn, const double *Input, double *Output)
{
	int i, r;	
	if(Input==NULL || Output==NULL
		|| nn<0 || nn>MAX_NET-1) return ErrorIncorrectParam;
	if(mn[nn].State<2) return ErrorNetNotTrain;
	for(i=0; i<mn[nn].Net.LayersStructure[0]; i++) mn[nn].In[i]=(float)Input[i];
	if(LoadedDLL) r=(*fCalculate)(&mn[nn].Net, mn[nn].In, &mn[nn].Out[0]);
	else r=LoadLibraryError;
	for(i=0; i<mn[nn].Net.LayersStructure[mn[nn].Net.SizeLayersStructure-1]; i++)
		Output[i]=(double)mn[nn].Out[i];
	return -r;
}
// 
NNFORMQL_API int __stdcall  TrainNN(const int nn, const int CountPattern, const double *InPattern, 
							  const double *OutPattern, const int EpohCount, const double Kerror)
{
	if(InPattern==NULL || OutPattern==NULL
		|| nn<0 || nn>MAX_NET-1 || CountPattern<1 || EpohCount<1) return ErrorIncorrectParam;
	if(mn[nn].State!=1) return ErrorIncorrectParam;	//    
	int r=1, ip, op, i, j, ki=0, ko=0;
	ip=mn[nn].Net.LayersStructure[0];
	op=mn[nn].Net.LayersStructure[mn[nn].Net.SizeLayersStructure-1];
//      
	float* InPat=new float[CountPattern*ip];
	float* OutPat=new float[CountPattern*ip];
//    
	for(i=0; i<CountPattern; i++)
	{
		for(j=0; j<ip; j++) InPat[ki+j]=(float)InPattern[ki+j];
		ki=ki+ip;
		for(j=0; j<op; j++) OutPat[ko+j]=(float)OutPattern[ko+j];
		ko=ko+op;
	}
//----
	cn=nn;
	mn[nn].Kerror=(float)Kerror;
	if(LoadedDLL) 
		r=(*fTeach)(&mn[nn].Net, &InPat[0], &OutPat[0], CountPattern, EpohCount, CallbackFunction);
	else r=LoadLibraryError;
	if(r==0 || r==31) 
	{
		mn[nn].State=2;
		if(r==0)mn[nn].CntEpoh=ce+1; else mn[nn].CntEpoh=ce;
		mn[nn].Qerror=qe;
		time(&mn[nn].Etime);
		r=0;
	}
//  
	delete[]InPat;
	delete[]OutPat;
	return -r;
}//*/
//---------------------------------------------------------------------------
bool __stdcall CallbackFunction(int Epoh, float QError, TNeuroNet* Net)
{
	ce=Epoh;
	qe=QError;
	if(mn[cn].Kerror>(float)0.0000001 && QError<mn[cn].Kerror)return false;// 
	return true; //  
}
