//+------------------------------------------------------------------+
//|                                  IndicatorPropertyFromWindow.mq4 |
//|                                        (C)opyright  2008, Ilnur |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+

//       ,    . 
//          DLL:
//  ->   ->  ->   DLL.

#property copyright "(C)opyright  2008, Ilnur"
#property link      "http://www.metaquotes.net"

#include <WinUser32.mqh>

#import "user32.dll"
	int GetAncestor(int hWnd, int gaFlags);
	int GetLastActivePopup(int hWnd);
	int GetDlgItem(int hDlg, int nIDDlgItem);
#import

#define PAUSE 100

#define VK_HOME 0x24
#define VK_DOWN 0x28

#define GA_ROOT 2

#define TVM_GETNEXTITEM 0x110A

//+------------------------------------------------------------------+
//|   " "       |
//+------------------------------------------------------------------+
int GetListDialog(int hOwnedWnd)
{
	PostMessageA(hOwnedWnd,WM_COMMAND,35419,0);
	Sleep(PAUSE);
//----
	return(GetLastActivePopup(hOwnedWnd));
}

//+------------------------------------------------------------------+
//|             |
//+------------------------------------------------------------------+
int GetPropertyDialog(int hOwnedWnd, int hListDlg)
{
	PostMessageA(hListDlg,WM_COMMAND,0x48B,GetDlgItem(hListDlg,0x48B));
	Sleep(PAUSE);
//----
	return(GetLastActivePopup(hOwnedWnd));
}

//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+
int GetTreeViewCount(int hWndControl)
{
	int hItem, nTreeViewCount = 0;
//----
	hItem = SendMessageA(hWndControl,TVM_GETNEXTITEM,0,0);
	while(hItem!=0)
	{
		hItem = SendMessageA(hWndControl,TVM_GETNEXTITEM,1,hItem);
		nTreeViewCount++;
	}
//----
	return(nTreeViewCount);
}

//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
int start()
{
	int i = 0, hParentWnd, hListDlg, hTreeView, hPropDlg;
	int nTreeViewCount, nWindowIndex;
//----     
	hParentWnd = GetAncestor(WindowHandle(Symbol(),Period()),GA_ROOT);
//----
	if(hParentWnd!=0)
	{
	//----   " "
		hListDlg = GetListDialog(hParentWnd);
	//----   
		hTreeView = GetDlgItem(hListDlg,0x48C);
	//----       
		nTreeViewCount = GetTreeViewCount(hTreeView);
	//----
		nWindowIndex = WindowOnDropped()-(WindowsTotal()-nTreeViewCount);
		if(nWindowIndex<0) return(0);
	//----      
		PostMessageA(hTreeView,WM_KEYDOWN,VK_HOME,0);
	//----      
		while(i<nTreeViewCount)
		{
			if(IsWindowEnabled(GetDlgItem(hListDlg,0x48B))==0)
			{
				if(i==nWindowIndex)
				{
				//----      
					PostMessageA(hTreeView,WM_KEYDOWN,VK_DOWN,0);
				//----     
					GetPropertyDialog(hParentWnd,hListDlg);
					break;
				}
				else i++;
			}
			PostMessageA(hTreeView,WM_KEYDOWN,VK_DOWN,0);
		}
	}

	return(0);
}

