//+------------------------------------------------------------------+
//|                                                      AMA_STL.mq5 |
//|                      Copyright  2006, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    1
#property indicator_buffers 1 
//----    
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       SlateBlue 
#property indicator_color1 clrSlateBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "AMA_STL"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint FastMA=3;
input uint SlowMA=100;
input uint Range=160;
input uint filter=25;
input uint Level=100;
//+-----------------------------------+
//----   ,    
//      
double ExtBuffer[];
//----
double k1,k2,dLevel;
//----      
int  min_rates_total;
//----   
int Count[];
double mAMA[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//----
   int numb,Max1,Max2;
   static int count=1;

   Max2=Size;
   Max1=Max2-1;

   count--;
   if(count<0) count=Max1;

   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//----     
   min_rates_total=int(Range+1);
   k1=2.0/(SlowMA+1);
   k2=2.0/(FastMA+1)-k1;
   dLevel=Level*_Point;

//----       
   if(ArrayResize(Count,Range)<int(Range))
     {
      Print("      Count[]");
      return(INIT_FAILED);
     }
   if(ArrayResize(mAMA,Range)<int(Range))
     {
      Print("      mAMA[]");
      return(INIT_FAILED);
     }
   ArrayInitialize(Count,0);

//----      
   SetIndexBuffer(0,ExtBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtBuffer,true);

//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"AMA_STL");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(RESET);

//----    
   int limit,bar;
   double Noise,ER,SSC,AMA,sdAMA,dAMA,HH,LL,Res;
   static double AMA_;

//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);

//----      
//  limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      AMA_=close[limit+1];
      ArrayInitialize(mAMA,close[limit+1]);
     }
   else limit=rates_total-prev_calculated; //      
//----  
   AMA=AMA_;

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      Noise=0;
      for(int i=bar+int(Range)-1; i>=bar; i--) Noise+=MathAbs(close[i]-close[i+1]);
      if(Noise) ER=MathAbs(close[bar]-close[bar+Range])/Noise;
      else ER=0;
      SSC=(ER*k2+k1);
      AMA+=NormalizeDouble(SSC*SSC*(close[bar]-AMA),_Digits);
      mAMA[Count[0]]=AMA;
      //----
      if(filter<1) ExtBuffer[bar]=mAMA[Count[0]];
      else
        {
         sdAMA=0.0;
         for(int i=bar+int(SlowMA)-1; i>=bar; i--) sdAMA+=MathAbs(mAMA[Count[0]]-mAMA[Count[1]]);

         dAMA=mAMA[Count[0]]-mAMA[Count[1]];
         Res=NormalizeDouble(filter*sdAMA/(100*SlowMA),_Digits);
         //----
         if(dAMA>=0)
           {
            HH=high[ArrayMaximum(high,bar,Range)];;
            if(+dAMA<Res && high[bar]<=HH+dLevel) ExtBuffer[bar]=ExtBuffer[bar+1];
            else ExtBuffer[bar]=mAMA[Count[0]];
           }
         else
           {
            LL=low[ArrayMinimum(low,bar,Range)];
            if(-dAMA<Res && low[bar]>LL-dLevel) ExtBuffer[bar]=ExtBuffer[bar+1];
            else ExtBuffer[bar]=mAMA[Count[0]];
           }
        }
      
      if(bar)
        {
         Recount_ArrayZeroPos(Count,Range);
         AMA_=AMA;
        }
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
