#define __MEMORY__

// #define MEMORY_DEBUG_MAX // DebugBreak при увеличении Max-показателя.
// #define MEMORY_DEBUG_MIN // DebugBreak при уменьшении Max-показателя.

// #define MEMORY_TYPE MQL_MEMORY_USED  // Какой показатель замерять.
// #define MEMORY_TESTER_OPTIMIZATION   // Работа в режиме оптимизации Тестера.

class MEMORY
{
private:
  const int MemoryType;
  const int Type;

  int Min;
  int Max;
  int Last;

  static bool IsCorrect( const ENUM_MQL_INFO_INTEGER eMemoryType )
  {
    return((eMemoryType == MQL_HANDLES_USED) ||
           (eMemoryType == MQL_MEMORY_LIMIT) ||
           (eMemoryType == MQL_MEMORY_USED));
  }

  static bool IsCorrect( const ENUM_TERMINAL_INFO_INTEGER eMemoryType )
  {
    return(/*(eMemoryType == TERMINAL_DISK_SPACE) ||*/
           (eMemoryType == TERMINAL_MEMORY_PHYSICAL) ||
           (eMemoryType == TERMINAL_MEMORY_TOTAL) ||
           (eMemoryType == TERMINAL_MEMORY_AVAILABLE) ||
           (eMemoryType == TERMINAL_MEMORY_USED));
  }

  template <typename T>
  static T Bench( const bool, const T Value, const bool )
  {
    return(Value);
  }

public:
  MEMORY( const ENUM_MQL_INFO_INTEGER eMemoryType = MQL_MEMORY_USED ) : MemoryType(eMemoryType),
                                                                        Type(MEMORY::IsCorrect(eMemoryType)),
                                                                        Min(INT_MAX), Max(0), Last(0)
  {
    this.Update();
  }

  MEMORY( const ENUM_TERMINAL_INFO_INTEGER eMemoryType ) : MemoryType(eMemoryType),
                                                           Type(-MEMORY::IsCorrect(eMemoryType)),
                                                           Min(INT_MAX), Max(0), Last(0)
  {
    this.Update();
  }

  ~MEMORY( void )
  {
    this.Update();

    if (!::MQLInfoInteger(MQL_OPTIMIZATION))
      ::Print(this.ToString());
  }

  int GetValue() const
  {
    return(this.Type ? ((this.Type > 0) ? (int)::MQLInfoInteger((ENUM_MQL_INFO_INTEGER)this.MemoryType)
                                        : (int)::TerminalInfoInteger((ENUM_TERMINAL_INFO_INTEGER)this.MemoryType))
                     : 0);
  }

  bool Update( void )
  {
  #ifndef MEMORY_TESTER_OPTIMIZATION
    static const bool IsOptimization = ::MQLInfoInteger(MQL_OPTIMIZATION);


    if (!IsOptimization)
  #endif // #ifndef MEMORY_TESTER_OPTIMIZATION
    {
      this.Last = this.GetValue();

      if (this.Last > this.Max)
      {
      #ifdef _DEBUG
        #ifdef MEMORY_DEBUG_MAX
          ::DebugBreak();
        #endif // #ifdef MEMORY_DEBUG_MAX
      #endif //#ifdef _DEBUG

        this.Max = this.Last;
      }

      if (this.Last < this.Min)
      {
      #ifdef _DEBUG
        #ifdef MEMORY_DEBUG_MIN
          ::DebugBreak();
        #endif // #ifdef MEMORY_DEBUG_MIN
      #endif //#ifdef _DEBUG

        this.Min = this.Last;
      }
    }

    return(true);
  }

#define BENCH(A) { return(MEMORY::Bench(this.Update(), A, this.Update())); }
#define BENCH2(A) {this.Update(); A; this.Update(); }

// Array Functions.

  template <typename T, typename T2>
  int  ArrayCopy(
     T&         dst_array[],         // destination array
     const T2&  src_array[],         // source array
     int        dst_start=0,         // index starting from which write into destination array
     int        src_start=0,         // first index of a source array
     int        count=WHOLE_ARRAY    // number of elements
     )
    BENCH(::ArrayCopy(dst_array, src_array, dst_start, src_start, count))

  template <typename T>
  int  ArrayResize(
     T&  array[],           // array passed by reference
     int new_size,          // new array size
     int reserve_size=0     // reserve size value (excess)
     )
    BENCH(::ArrayResize(array, new_size, reserve_size))

  template <typename T>
  int  ArrayResize(
     T&  array[][],         // array passed by reference
     int new_size,          // new array size
     int reserve_size=0     // reserve size value (excess)
     )
    BENCH(::ArrayResize(array, new_size, reserve_size))

  template <typename T>
  bool  ArrayInsert(
     T&        dst_array[],          // receiving array
     const T&  src_array[],          // source array
     uint      dst_start,            // receiver array index to be inserted
     uint      src_start=0,          // source array index to be copied
     uint      count=WHOLE_ARRAY     // number of elements to insert
     )
    BENCH(::ArrayInsert(dst_array, src_array, dst_start, src_start, count));

  template <typename T>
  bool  ArrayRemove(
     T&        array[],            // array of any type
     uint      start,              // index the removal starts from
     uint      count=WHOLE_ARRAY   // number of elements
     )
    BENCH(::ArrayRemove(array, start, count));

  template <typename T>
  void ArrayFree( T &Array[] )
    BENCH2(::ArrayFree(Array))

  template <typename T>
  void ArrayFree( T &Array[][] )
    BENCH2(::ArrayFree(Array))

// Custom Symbols.

  int  CustomRatesDelete(
     const string     symbol,       // symbol name
     datetime         from,         // start date
     datetime         to            // end date
     )
    BENCH(::CustomRatesDelete(symbol, from, to))

  int  CustomRatesReplace(
     const string     symbol,             // symbol name
     datetime         from,               // start date
     datetime         to,                 // end date
     const MqlRates&  rates[],            // array for the data to be applied to a custom symbol
     uint             count=WHOLE_ARRAY   // number of the rates[] array elements to be used
     )
    BENCH(::CustomRatesReplace(symbol, from, to, rates, count))

  int  CustomRatesUpdate(
     const string     symbol,             // custom symbol name
     const MqlRates&  rates[],            // array for the data to be applied to a custom symbol
     uint             count=WHOLE_ARRAY   // number of the rates[] array elements to be used
     )
    BENCH(::CustomRatesUpdate(symbol, rates, count))

  int  CustomTicksAdd(
     const string     symbol,             // Symbol name
     const MqlTick&   ticks[],            // The array with tick data that should be applied to the custom symbol
     uint             count=WHOLE_ARRAY   // number of the ticks[] array elements to be used
     )
    BENCH(::CustomTicksAdd(symbol, ticks, count))

  int  CustomTicksDelete(
     const string     symbol,            // symbol name
     long             from_msc,          // start date
     long             to_msc             // end date
     )
    BENCH(::CustomTicksDelete(symbol, from_msc, to_msc));

  int  CustomTicksReplace(
     const string     symbol,            // symbol name
     long             from_msc,          // start date
     long             to_msc,            // end date
     const MqlTick&   ticks[],           // array for the data to be applied to a custom symbol
     uint             count=WHOLE_ARRAY  // number of the ticks[] array elements to be used
     )
    BENCH(::CustomTicksReplace(symbol, from_msc, to_msc, ticks, count))

// Market Info.

  bool  MarketBookAdd(
     string  symbol      // symbol
     )
    BENCH(::MarketBookAdd(symbol))

  bool  MarketBookRelease(
     string  symbol      // symbol
     )
    BENCH(::MarketBookRelease(symbol))

// Trade Functions.

  bool  HistorySelect(
     datetime  from_date,     // From date
     datetime  to_date        // To date
     )
    BENCH(::HistorySelect(from_date, to_date));

  bool  HistoryOrderSelect(
     ulong  ticket      // Order ticket
     )
    BENCH(::HistoryOrderSelect(ticket))

  bool  HistoryDealSelect(
     ulong  ticket      // Deal ticket
     )
    BENCH(::HistoryDealSelect(ticket))

// File Functions.

  template <typename T>
  uint  FileReadArray(
     int file_handle,               // File handle
     T&  array[],                   // Array to record
     int start=0,                   // start array position to write
     int count=WHOLE_ARRAY          // count to read
     )
    BENCH(::FileReadArray(file_handle, array, start, count))

  template <typename T>
  long  FileLoad(
     const string  file_name,         // File name
     T&            buffer[],          // An array of numeric types or simple structures
     int           common_flag=0      // A file flag, is searched in <data_folder>\MQL5\Files\ by default
     )
    BENCH(::FileLoad(file_name, buffer, common_flag))

  void  FileClose(
     int  file_handle      // File handle
     )
    BENCH2(::FileClose(file_handle))

  void  FileFlush(
     int  file_handle      // File handle
     )
    BENCH2(::FileFlush(file_handle))

// Economic Calendar.

  int  CalendarEventByCountry(
     string               country_code,     // country code name (ISO 3166-1 alpha-2)
     MqlCalendarEvent&    events[]          // variable for receiving the description array
     )
    BENCH(::CalendarEventByCountry(country_code, events))

  int  CalendarEventByCurrency(
     const string         currency,     // country currency code name
     MqlCalendarEvent&    events[]      // variable for receiving the description array
     )
    BENCH(::CalendarEventByCurrency(currency, events))

  int  CalendarValueHistoryByEvent(
     ulong              event_id,          // event ID
     MqlCalendarValue&  values[],          // array for value descriptions
     datetime           datetime_from,     // left border of a time range
     datetime           datetime_to=0      // right border of a time range
     )
    BENCH(::CalendarValueHistoryByEvent(event_id, values, datetime_from, datetime_to))

  int  CalendarValueHistory(
     MqlCalendarValue&  values[],              // array for value descriptions
     datetime           datetime_from,         // left border of a time range
     datetime           datetime_to=0,         // right border of a time range
     const string       country_code=NULL,     // country code name (ISO 3166-1 alpha-2)
     const string       currency=NULL          // country currency code name
     )
    BENCH(::CalendarValueHistory(values, datetime_from, datetime_to, country_code, currency))

  int  CalendarValueLastByEvent(
     ulong                event_id,      // event ID
     ulong&               change_id,     // Calendar change ID
     MqlCalendarValue&    values[]       // array for value descriptions
     )
    BENCH(::CalendarValueLastByEvent(event_id, change_id, values))

  int  CalendarValueLast(
     ulong&               change_id,             // change ID
     MqlCalendarValue&    values[],              // array for value descriptions
     const string         country_code=NULL,     // country code name (ISO 3166-1 alpha-2)
     const string         currency=NULL          // country currency code name
     )
    BENCH(::CalendarValueLast(change_id, values, country_code, currency))

// Indicators Access.

  int  IndicatorCreate(
     string           symbol,                            // symbol name
     ENUM_TIMEFRAMES  period,                            // timeframe
     ENUM_INDICATOR   indicator_type,                    // indicator type from the enumeration ENUM_INDICATOR
     int              parameters_cnt=0                   // number of parameters
     )
    BENCH(::IndicatorCreate(symbol, period, indicator_type, parameters_cnt))

  int  IndicatorCreate(
     string           symbol,                            // symbol name
     ENUM_TIMEFRAMES  period,                            // timeframe
     ENUM_INDICATOR   indicator_type,                    // indicator type from the enumeration ENUM_INDICATOR
     int              parameters_cnt,                    // number of parameters
     const MqlParam&  parameters_array[]                 // array of parameters
     )
    BENCH(::IndicatorCreate(symbol, period, indicator_type, parameters_cnt, parameters_array))

  bool  IndicatorRelease(
     int       indicator_handle     // indicator handle
     )
    BENCH(::IndicatorRelease(indicator_handle))

  int  iCustom(
     string           symbol,     // symbol name
     ENUM_TIMEFRAMES  period,     // period
     string           name        // folder/custom_indicator_name
     )
    BENCH(::iCustom(symbol, period, name))

  template <typename T1>
  int  iCustom(
     string           symbol,     // symbol name
     ENUM_TIMEFRAMES  period,     // period
     string           name,       // folder/custom_indicator_name
     T1               Value1      // list of indicator input parameters
     )
    BENCH(::iCustom(symbol, period, name, Value1))

  template <typename T1, typename T2>
  int  iCustom(
     string           symbol,     // symbol name
     ENUM_TIMEFRAMES  period,     // period
     string           name,       // folder/custom_indicator_name
     T1               Value1,     // list of indicator input parameters
     T2               Value2      // list of indicator input parameters
     )
    BENCH(::iCustom(symbol, period, name, Value1, Value2))

  template <typename T1, typename T2, typename T3>
  int  iCustom(
     string           symbol,     // symbol name
     ENUM_TIMEFRAMES  period,     // period
     string           name,       // folder/custom_indicator_name
     T1               Value1,     // list of indicator input parameters
     T2               Value2,     // list of indicator input parameters
     T3               Value3      // list of indicator input parameters
     )
    BENCH(::iCustom(symbol, period, name, Value1, Value2, Value3))

  template <typename T1, typename T2, typename T3, typename T4>
  int  iCustom(
     string           symbol,     // symbol name
     ENUM_TIMEFRAMES  period,     // period
     string           name,       // folder/custom_indicator_name
     T1               Value1,     // list of indicator input parameters
     T2               Value2,     // list of indicator input parameters
     T3               Value3,     // list of indicator input parameters
     T4               Value4      // list of indicator input parameters
     )
    BENCH(::iCustom(symbol, period, name, Value1, Value2, Value3, Value4))

  template <typename T1, typename T2, typename T3, typename T4, typename T5>
  int  iCustom(
     string           symbol,     // symbol name
     ENUM_TIMEFRAMES  period,     // period
     string           name,       // folder/custom_indicator_name
     T1               Value1,     // list of indicator input parameters
     T2               Value2,     // list of indicator input parameters
     T3               Value3,     // list of indicator input parameters
     T4               Value4,     // list of indicator input parameters
     T5               Value5      // list of indicator input parameters
     )
    BENCH(::iCustom(symbol, period, name, Value1, Value2, Value3, Value4, Value5))

// Chart Operations.

  bool  ChartApplyTemplate(
     long          chart_id,     // Chart ID
     const string  filename      // Template file name
     )
    BENCH(::ChartApplyTemplate(chart_id, filename))

// Timeseries Access.

  int  CopyBuffer(
     int       indicator_handle,     // indicator handle
     int       buffer_num,           // indicator buffer number
     int       start_pos,            // start position
     int       count,                // amount to copy
     double&   buffer[]              // target array to copy
     )
    BENCH(::CopyBuffer(indicator_handle, buffer_num, start_pos, count, buffer))

  int  CopyBuffer(
     int       indicator_handle,     // indicator handle
     int       buffer_num,           // indicator buffer number
     datetime  start_time,           // start date and time
     int       count,                // amount to copy
     double&   buffer[]              // target array to copy
     )
    BENCH(::CopyBuffer(indicator_handle, buffer_num, start_time, count, buffer))

  int  CopyBuffer(
     int       indicator_handle,     // indicator handle
     int       buffer_num,           // indicator buffer number
     datetime  start_time,           // start date and time
     datetime  stop_time,            // end date and time
     double&   buffer[]              // target array to copy
     )
    BENCH(::CopyBuffer(indicator_handle, buffer_num, start_time, stop_time, buffer))

  template <typename T1, typename T2>
  int  CopySeries(
     string           symbol_name,       // symbol name
     ENUM_TIMEFRAMES  timeframe,         // period
     int              start_pos,         // start position
     int              count,             // amount to copy
     ulong            rates_mask,        // combination of flags to specify the requested series
     T1&              array1[],          // array to receive the data of the first copies timeseries
     T2&              array2[]           // array to receive the data of the second copied timeseries
     )
    BENCH(::CopySeries(symbol_name, timeframe, start_pos, count, rates_mask, array1, array2))

  template <typename T1, typename T2, typename T3>
  int  CopySeries(
     string           symbol_name,       // symbol name
     ENUM_TIMEFRAMES  timeframe,         // period
     int              start_pos,         // start position
     int              count,             // amount to copy
     ulong            rates_mask,        // combination of flags to specify the requested series
     T1&              array1[],          // array to receive the data of the first copies timeseries
     T2&              array2[],          // array to receive the data of the second copied timeseries
     T3&              array3[]
     )
    BENCH(::CopySeries(symbol_name, timeframe, start_pos, count, rates_mask, array1, array2, array3))

  template <typename T1, typename T2, typename T3, typename T4>
  int  CopySeries(
     string           symbol_name,       // symbol name
     ENUM_TIMEFRAMES  timeframe,         // period
     int              start_pos,         // start position
     int              count,             // amount to copy
     ulong            rates_mask,        // combination of flags to specify the requested series
     T1&              array1[],          // array to receive the data of the first copies timeseries
     T2&              array2[],          // array to receive the data of the second copied timeseries
     T3&              array3[],
     T4&              array4[]
     )
    BENCH(::CopySeries(symbol_name, timeframe, start_pos, count, rates_mask, array1, array2, array3, array4))

  template <typename T1, typename T2, typename T3, typename T4, typename T5>
  int  CopySeries(
     string           symbol_name,       // symbol name
     ENUM_TIMEFRAMES  timeframe,         // period
     int              start_pos,         // start position
     int              count,             // amount to copy
     ulong            rates_mask,        // combination of flags to specify the requested series
     T1&              array1[],          // array to receive the data of the first copies timeseries
     T2&              array2[],          // array to receive the data of the second copied timeseries
     T3&              array3[],
     T4&              array4[],
     T5&              array5[]
     )
    BENCH(::CopySeries(symbol_name, timeframe, start_pos, count, rates_mask, array1, array2, array3, array4, array5))

#define MACROS_COPY(A, B)                                            \
                                                                     \
  int  A(                                                            \
     string           symbol_name,                                   \
     ENUM_TIMEFRAMES  timeframe,                                     \
     int              start_pos,                                     \
     int              count,                                         \
     B&               array[]                                        \
     )                                                               \
    BENCH(::A(symbol_name, timeframe, start_pos, count, array))      \
                                                                     \
  int  A(                                                            \
     string           symbol_name,                                   \
     ENUM_TIMEFRAMES  timeframe,                                     \
     datetime         start_time,                                    \
     int              count,                                         \
     B&               array[]                                        \
     )                                                               \
    BENCH(::A(symbol_name, timeframe, start_time, count, array))     \
                                                                     \
  int  A(                                                            \
     string           symbol_name,                                   \
     ENUM_TIMEFRAMES  timeframe,                                     \
     datetime         start_time,                                    \
     datetime         stop_time,                                     \
     B&               array[]                                        \
     )                                                               \
    BENCH(::A(symbol_name, timeframe, start_time, stop_time, array))

  MACROS_COPY(CopyRates, MqlRates)
  MACROS_COPY(CopyTime, datetime)
  MACROS_COPY(CopyOpen, double)
  MACROS_COPY(CopyHigh, double)
  MACROS_COPY(CopyLow, double)
  MACROS_COPY(CopyClose, double)
  MACROS_COPY(CopyTickVolume, long)
  MACROS_COPY(CopyRealVolume, long)
  MACROS_COPY(CopySpread, int)

#undef MACROS_COPY

  int  CopyTicks(
     string           symbol_name,           // Symbol name
     MqlTick&         ticks_array[],         // Tick receiving array
     uint             flags=COPY_TICKS_ALL,  // The flag that determines the type of received ticks
     ulong            from=0,                // The date from which you want to request ticks
     uint             count=0                // The number of ticks that you want to receive
     )
    BENCH(::CopyTicks(symbol_name, ticks_array, flags, from, count))

  int  CopyTicksRange(
     const string     symbol_name,           // symbol name
     MqlTick&         ticks_array[],         // tick receiving array
     uint             flags=COPY_TICKS_ALL,  // flag that defines the type of the ticks that are received
     ulong            from_msc=0,            // date, starting from which ticks are requested
     ulong            to_msc=0               // date, up to which ticks are requested
     )
    BENCH(::CopyTicksRange(symbol_name, ticks_array, flags, from_msc, to_msc))

#undef BENCH2
#undef BENCH

#define MACROS(A) int Get##A( void ) const { return(this.A); }
  MACROS(Min)
  MACROS(Max)
  MACROS(Last)
#undef MACROS

  string ToString( void ) const
  {
  #define TOSTRING(A) " " + #A + " = " + (string)(A)
    return((this.Type ? ((this.Type > 0) ? ::EnumToString((ENUM_MQL_INFO_INTEGER)this.MemoryType)
                                         : ::EnumToString((ENUM_TERMINAL_INFO_INTEGER)this.MemoryType))
                      : NULL) + ":" + TOSTRING(Min) + TOSTRING(Max) + TOSTRING(Last));
  #undef TOSTRING
  }
};

#ifdef MEMORY_TYPE
  MEMORY gMemory(MEMORY_TYPE);
#else // #ifdef MEMORY_TYPE
  MEMORY gMemory;
#endif // #ifdef MEMORY_TYPE #else

// #include <fxsaber\HistoryTicks\ArrayResize.mqh> // https://www.mql5.com/ru/code/20298
#ifdef ArrayCopy
  #undef ArrayCopy
#endif // #ifdef ArrayCopy

#ifdef ArrayResize
  #undef ArrayResize
#endif // #ifdef ArrayResize

// Array Functions.
#define ArrayCopy   gMemory.ArrayCopy
#define ArrayFree   gMemory.ArrayFree
#define ArrayResize gMemory.ArrayResize
#define ArrayInsert gMemory.ArrayInsert
#define ArrayRemove gMemory.ArrayRemove

// Custom Symbols.
#define CustomRatesDelete  gMemory.CustomRatesDelete
#define CustomRatesReplace gMemory.CustomRatesReplace
#define CustomRatesUpdate  gMemory.CustomRatesUpdate
#define CustomTicksAdd     gMemory.CustomTicksAdd
#define CustomTicksDelete  gMemory.CustomTicksDelete
//#define CustomTicksReplace gMemory.CustomTicksReplace // #include <fxsaber\TicksShort\LotsTicks.mqh> // https://www.mql5.com/ru/code/61126

// Market Info.
#define MarketBookAdd     gMemory.MarketBookAdd
#define MarketBookRelease gMemory.MarketBookRelease

// Indicators Access.
#define IndicatorCreate  gMemory.IndicatorCreate
#define IndicatorRelease gMemory.IndicatorRelease
#define iCustom          gMemory.iCustom

// Chart Operations.
#define ChartApplyTemplate gMemory.ChartApplyTemplate

// Timeseries Access.
#define CopyBuffer     gMemory.CopyBuffer
#define CopySeries     gMemory.CopySeries
#define CopyRates      gMemory.CopyRates // #include <fxsaber\MultiTester\MTTester.mqh> // https://www.mql5.com/ru/code/26132
#define CopyTime       gMemory.CopyTime
#define CopyOpen       gMemory.CopyOpen
#define CopyHigh       gMemory.CopyHigh
#define CopyLow        gMemory.CopyLow
#define CopyClose      gMemory.CopyClose
#define CopyTickVolume gMemory.CopyTickVolume
#define CopyRealVolume gMemory.CopyRealVolume
#define CopySpread     gMemory.CopySpread

#define CopyTicks      gMemory.CopyTicks      // #include <fxsaber\MultiTester\MTTester.mqh> // https://www.mql5.com/ru/code/26132
#define CopyTicksRange gMemory.CopyTicksRange // #include <fxsaber\TicksShort\LotsTicks.mqh> // https://www.mql5.com/ru/code/61126