//+------------------------------------------------------------------+
//|                                              IncVidyaOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int      VidCMOPeriod=9;
   input int      VidMAPeriod=12;

   Declaration:
   #include <IncOnArray/IncVidyaOnArray.mqh>
   CVidyaOnArray vid;

   In OnInit:
   vid.Init(VidCMOPeriod,VidMAPeriod);

   In OnCalculate:
   vid.Solve(rates_total,prev_calculated,data,VBuffer);

*/
//+------------------------------------------------------------------+
//|  CVidyaOnArray                                                   |
//+------------------------------------------------------------------+
class CVidyaOnArray
  {
private:
   int               m_CMOPeriod;
   int               m_MAPeriod;
   string            m_Name;
   int               m_br;
   double            m_k1;
   double            m_k2;
   int               m_m;
   double            m_cmo;
public:
   void Init(int aCMOPeriod=9,int aMAPeriod=12)
     {
      m_m=10;
      m_CMOPeriod=aCMOPeriod;
      m_MAPeriod=aMAPeriod;
      m_Name="VIDYA("+IntegerToString(m_CMOPeriod)+","+IntegerToString(m_MAPeriod)+")";
      m_br=m_CMOPeriod+1+m_MAPeriod*m_m;
      m_k1=2.0/(m_MAPeriod+1.0);
      m_k2=1.0-m_k1;
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aData[],
              double  &aVIDYA[]
              )
     {
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aData[i]!=0 && aData[i]!=EMPTY_VALUE)
              {
               Start=i+m_CMOPeriod;
               break;
              }
           }
         aVIDYA[Start-1]=aData[Start-1];
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         double UpSum=0.0,DownSum=0.0;
         for(int j=0;j<m_CMOPeriod;j++)
           {
            double diff=aData[i-j]-aData[i-j-1];
            if(diff>0.0)
              {
               UpSum+=diff;
              }
            else
              {
               DownSum+=(-diff);
              }
           }
         if(UpSum+DownSum!=0.0)
           {
            m_cmo=MathAbs((UpSum-DownSum)/(UpSum+DownSum));
           }
         aVIDYA[i]=aData[i]*m_k1*m_cmo+aVIDYA[i-1]*(1.0-m_k1*m_cmo);
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's VIDYAOnArray class. https://login.mql5.com/ru/users/Integer");
     }
  };
//+------------------------------------------------------------------+
