//+------------------------------------------------------------------+
//|                                                IncAMAOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int   AMAPeriod      =  9; 
   input int   AMAFastPeriod  =  2;
   input int   AMASlowPeriod  =  30;

   Declaration:
   #include <IncOnArray/IncAMAOnArray.mqh>
   CAMAOnArray ama;

   In OnInit:  
   ama.Init(AMAPeriod,AMAFastPeriod,AMASlowPeriod);

   In OnCalculate:
   ama.Solve(rates_total,prev_calculated,data,AMABuffer);
*/
//+------------------------------------------------------------------+
//| CAMAOnArray                                                      |
//+------------------------------------------------------------------+
class CAMAOnArray
  {
private:
   int               m_Period;
   int               m_FastPeriod;
   int               m_SlowPeriod;
   double            m_fc;
   double            m_sc;
   int               m_m;
   int               m_br;
   string            m_Name;
   double CalculateER(const int nPosition,const double &PriceData[])
     {
      double dSignal=fabs(PriceData[nPosition]-PriceData[nPosition-m_Period]);
      double dNoise=0.0;
      for(int delta=0;delta<m_Period;delta++)
        {
         dNoise+=fabs(PriceData[nPosition-delta]-PriceData[nPosition-delta-1]);
        }
      if(dNoise!=0.0)
        {
         return(dSignal/dNoise);
        }
      return(0.0);
     }
public:
   void Init(int aPeriod=9,int aFastPeriod=2,int aSlowPeriod=30)
     {
      m_Period=aPeriod;
      m_FastPeriod=aFastPeriod;
      m_SlowPeriod=aSlowPeriod;
      m_m=10;
      m_br=m_m*MathMax(m_FastPeriod,m_SlowPeriod);
      m_br+=aPeriod-1;
      m_fc=2.0/(m_FastPeriod+1.0);
      m_sc=2.0/(m_SlowPeriod+1.0);
      m_Name="AMA("+IntegerToString(m_Period)+","+IntegerToString(m_FastPeriod)+","+IntegerToString(m_SlowPeriod)+")";
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aData[],
              double  &aAMA[])
     {
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aData[i]!=0 && aData[i]!=EMPTY_VALUE)
              {
               Start=i+m_Period-1;
               break;
              }
           }
         aAMA[Start]=aData[Start];
         Start++;
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         double dCurrentSSC=(CalculateER(i,aData)*(m_fc-m_sc))+m_sc;
         double dPrevAMA=aAMA[i-1];
         aAMA[i]=pow(dCurrentSSC,2)*(aData[i]-dPrevAMA)+dPrevAMA;
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's AMAOnArray class. https://login.mql5.com/en/users/Integer");
     }
  };
//+------------------------------------------------------------------+
