//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Binance Data Loader - by Transcendreamer"
#property script_show_inputs

input bool tickmode=true;
input string symbol="BTCUSD_TEST";
input double threshold=1.5;
input double ticksize=0.01;
input int timeframe=1;
input int barvolume=100;
input bool cleanup=false;

char delimeter=',';
bool unicode=false;

datetime time1=D'1984.01.01 00:00';
datetime time2=D'2077.01.01 00:00';

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnStart(void)
  {
   if(tickmode)
      LoadTicks();
   else
      LoadBars();
  }

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void LoadBars()
  {

   Print("#########################################");
   Print("SCRIPT STARTING");

   if(cleanup)
     {
      int k=CustomRatesDelete(symbol,time1,time2);
      if(k!=-1)
         Print("CLEARED BARS: ",k);
     }

   string filenames[];

   FileSelectDialog("SELECT BINANCE KLINES CSV FILES",NULL,
                    "CSV files (*.csv)|*.csv|All files (*.*)|*.*",
                    FSD_ALLOW_MULTISELECT,filenames);

   int total=ArraySize(filenames);

   if(!SymbolSelect(symbol,true))
     {
      Alert("CAN NOT FIND SYMBOL: ",symbol);
      return;
     }

   for(int i=0; i<total; i++)
     {

      int handle;

      if(unicode)
         handle=FileOpen(filenames[i],FILE_READ|FILE_IS_TEXT|FILE_UNICODE);
      else
         handle=FileOpen(filenames[i],FILE_READ|FILE_IS_TEXT|FILE_ANSI);

      if(handle==INVALID_HANDLE)
        {
         Alert("CAN NOT OPEN FILE: ",filenames[i]);
         continue;
        }

      ulong filesize=FileSize(handle);
      ulong percent=ulong(filesize/100);
      ulong trigger=0;

      MqlRates rates[];
      int count=0;

      long starting=LONG_MAX;
      long ending=LONG_MIN;

      while(!FileIsEnding(handle))
        {
         string parts[];
         string text=FileReadString(handle);
         StringSplit(text,delimeter,parts);

         long opentime=StringToInteger(parts[0]);
         datetime time=datetime(opentime/1000);
         double open=StringToDouble(parts[1]);
         double high=StringToDouble(parts[2]);
         double low=StringToDouble(parts[3]);
         double close=StringToDouble(parts[4]);
         double volume=StringToDouble(parts[5]);
         long closetime=StringToInteger(parts[6]);
         double assetvolume=StringToDouble(parts[7]);
         long trades=StringToInteger(parts[8]);
         double basevolume=StringToDouble(parts[9]);
         double quotevolume=StringToDouble(parts[10]);
         double ignore=StringToDouble(parts[11]);

         if(barvolume>0)
            trades=barvolume;

         if(time>ending)
            ending=time;

         if(time<starting)
            starting=time;

         count++;
         ArrayResize(rates,count,65536);

         rates[count-1].time=time;
         rates[count-1].open=open;
         rates[count-1].high=high;
         rates[count-1].low=low;
         rates[count-1].close=close;
         rates[count-1].real_volume=(long)volume;
         rates[count-1].spread=0;
         rates[count-1].tick_volume=trades;

         ulong progress=FileTell(handle);
         if(progress>=trigger)
           {
            Comment("PROGRESS:   ",i+1,"/",total,"   ",progress,"/",filesize);
            trigger+=percent;
           }
        }

      int n=CustomRatesReplace(symbol,starting,ending,rates);

      Comment("");
      Print("BARS LOADED: ",n);
      PlaySound("ok.wav");

      if(n==-1)
        {
         Alert("ERROR: ",GetLastError());
        }

      FileClose(handle);

     }

   Alert("ALL FILES WERE PROCESSED");

  }

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void LoadTicks()
  {

   Print("#########################################");
   Print("SCRIPT STARTING");

   if(cleanup)
     {
      int k=CustomTicksDelete(symbol,time1*1000,time2*1000);
      if(k!=-1)
         Print("CLEARED TICKS: ",k);
     }

   string filenames[];

   FileSelectDialog("SELECT BINANCE TRADES CSV FILES",NULL,
                    "CSV files (*.csv)|*.csv|All files (*.*)|*.*",
                    FSD_ALLOW_MULTISELECT,filenames);

   int total=ArraySize(filenames);

   if(!SymbolSelect(symbol,true))
     {
      Alert("CAN NOT FIND SYMBOL: ",symbol);
      return;
     }

   for(int i=0; i<total; i++)
     {

      int handle;

      if(unicode)
         handle=FileOpen(filenames[i],FILE_READ|FILE_IS_TEXT|FILE_UNICODE);
      else
         handle=FileOpen(filenames[i],FILE_READ|FILE_IS_TEXT|FILE_ANSI);

      if(handle==INVALID_HANDLE)
        {
         Alert("CAN NOT OPEN FILE: ",filenames[i]);
         continue;
        }

      ulong filesize=FileSize(handle);
      ulong percent=ulong(filesize/100);
      ulong trigger=0;

      MqlTick ticks[];
      int count=0;

      long starting=LONG_MAX;
      long ending=LONG_MIN;

      double last_ask=0;
      double last_bid=0;
      double cum_volume=0;
      double prev_price=0;

      while(!FileIsEnding(handle))
        {
         string parts[];
         string text=FileReadString(handle);
         StringSplit(text,delimeter,parts);

         long time=StringToInteger(parts[4]);
         double price=StringToDouble(parts[1]);
         double volume=StringToDouble(parts[2]);
         bool buyer=(parts[5]=="true");

         if(time>ending)
            ending=time;

         if(time<starting)
            starting=time;

         if(buyer)
            last_bid=price;
         else
            last_ask=price;

         cum_volume+=volume;

         if(last_ask!=0 && last_bid!=0)
            if(MathAbs(price-prev_price)>=threshold)
              {
               count++;
               ArrayResize(ticks,count,65536);

               ticks[count-1].time_msc=time;
               ticks[count-1].time=datetime(time/1000);
               ticks[count-1].flags=TICK_FLAG_LAST|TICK_FLAG_VOLUME|TICK_FLAG_ASK|TICK_FLAG_BID;
               ticks[count-1].volume_real=cum_volume;

               if(buyer)
                 {
                  ticks[count-1].last=price;
                  ticks[count-1].bid=price;
                  ticks[count-1].ask=(last_ask>price)?last_ask:price+ticksize;
                 }
               else
                 {
                  ticks[count-1].last=price;
                  ticks[count-1].ask=price;
                  ticks[count-1].bid=(last_bid<price)?last_bid:price-ticksize;
                 }

               cum_volume=0;
               prev_price=price;
              }

         ulong progress=FileTell(handle);
         if(progress>=trigger)
           {
            Comment("PROGRESS:   ",i+1,"/",total,"   ",progress,"/",filesize);
            trigger+=percent;
           }
        }

      int n=CustomTicksReplace(symbol,starting,ending,ticks);

      Comment("");
      Print("TICKS LOADED: ",n);
      PlaySound("ok.wav");

      if(n==-1)
        {
         Alert("ERROR: ",GetLastError());
        }

      FileClose(handle);

     }

   Alert("ALL FILES WERE PROCESSED");

  }
//+------------------------------------------------------------------+
