#include "DataBase_String.mqh"

class EVENT_MESSAGE
{
private:
  static ushort EventID;
  static DATABASE_STRING Messages;

  struct MESSAGE_STAT
  {
    struct MESSAGE_STAT_BASE
    {
      int Full;
      int Ready;

      MESSAGE_STAT_BASE( void ) : Full(0), Ready(0)
      {
      }

      void Add( const int Value, const bool FlagReady )
      {
        this.Full += Value;

        if (FlagReady)
          this.Ready += Value;

        return;
      }

      string ToString( void ) const
      {
        return(this.Full ? (string)this.Ready + "/" + (string)this.Full + " (" + ::DoubleToString(100.0 * this.Ready / this.Full, 1) + "%)"
                         : "0/0 (100%)");
      }
    };

    MESSAGE_STAT_BASE Amount;
    MESSAGE_STAT_BASE Length;

    void Add( const int iLength, const bool FlagReady = false )
    {
      if (iLength)
      {
        this.Amount.Add(1, FlagReady);
        this.Length.Add(iLength, FlagReady);
      }

      return;
    }

    string ToString( void ) const
    {
      return("Messages: " + this.Amount.ToString() + ", Characters = " + this.Length.ToString());
    }
  };

  static MESSAGE_STAT Stat_Sended;
  static MESSAGE_STAT Stat_Received;

  static int StringSplit( const string &Str, string &StrArray[], const int MaxLength = 63 )
  {
    const int Size = ::ArrayResize(StrArray, ::StringLen(Str) / MaxLength + (bool)(::StringLen(Str) % MaxLength));

    for (int i = 0; i < Size; i++)
      StrArray[i] = ::StringSubstr(Str, i * MaxLength, MaxLength);

    return(Size);
  }

public:
  static void SetEventID( const ushort iEventID )
  {
    EVENT_MESSAGE::EventID = iEventID;

    return;
  }

  static bool Send( const string Str, const long chartID )
  {
    bool Res = true;

    string StrArray[];
    const int Size = EVENT_MESSAGE::StringSplit(Str, StrArray);

    const long ID = ::MathRand() + ::ChartID();
    const int Length = ::StringLen(Str);

    for (int i = 0; Res && (i < Size); i++)
      Res &= ::EventChartCustom(chartID, EVENT_MESSAGE::EventID, ID, (i == Size - 1) ? Length + 1 : 0, StrArray[i]);

    if (Size)
      EVENT_MESSAGE::Stat_Sended.Add(Length, Res);

    return(Res);
  }

  static bool OnChartEvent( const int id, const long &lparam, const double &dparam, const string& sparam )
  {
    bool Res = false;

    if (id == CHARTEVENT_CUSTOM + EVENT_MESSAGE::EventID)
    {
      const int Length = EVENT_MESSAGE::Messages.Add(lparam, sparam);

      Res = dparam;

      if (Res)
      {
        if ((int)dparam != Length + 1)
        {
          ::Alert("Loss on message delivery!");

          EVENT_MESSAGE::Stat_Received.Add(Length);
        }
        else
          EVENT_MESSAGE::Stat_Received.Add(Length, true);
      }
    }

    EVENT_MESSAGE::Stat_Received.Add(EVENT_MESSAGE::Messages.IsTimeOut());

    return(Res);
  }

  static string Receive( const long &lparam )
  {
    const string Str = EVENT_MESSAGE::Messages.Get(lparam);

    EVENT_MESSAGE::Messages.Delete(lparam);

    return(Str);
  }

  static string StatSended( void )
  {
    return(EVENT_MESSAGE::Stat_Sended.ToString());
  }

  static string StatReceived( void )
  {
    return(EVENT_MESSAGE::Stat_Received.ToString());
  }
};

static ushort EVENT_MESSAGE::EventID = 0;
static DATABASE_STRING EVENT_MESSAGE::Messages;

static EVENT_MESSAGE::MESSAGE_STAT EVENT_MESSAGE::Stat_Sended;
static EVENT_MESSAGE::MESSAGE_STAT EVENT_MESSAGE::Stat_Received;
