struct DATABASE_STRING
{
private:
  struct STRING_DATA
  {
    long ID;
    ulong FirstTime;

    string Str;

    void Init( const long iID )
    {
      this.ID = iID;
      this.FirstTime = ::GetMicrosecondCount();

      this.Str = NULL;

      return;
    }

  #define TOSTR(A) "\n" + #A + " = " + (string)(A)
    string ToString( void ) const
    {
      return(/*TOSTR(ID) + TOSTR(FirstTime) + */TOSTR(Str) + TOSTR(::StringLen(Str)));
    }
  #undef TOSTR
  } Data[];

  int GetPos( const long ID ) const
  {
    int Pos = this.GetAmount() - 1;

    while ((Pos >= 0) && (this.Data[Pos].ID != ID))
      Pos--;

    return(Pos);
  }

public:
  int Add( const long ID, const string Str )
  {
    int Pos = this.GetPos(ID);

    if (Pos < 0)
      this.Data[Pos = ::ArrayResize(this.Data, this.GetAmount() + 1) - 1].Init(ID);

    return(::StringLen(this.Data[Pos].Str += Str));
  }

  bool Delete( const long ID )
  {
    const int Pos = this.GetPos(ID);

    if (Pos >= 0)
    {
      const int Size = this.GetAmount() - 1;

      for (int i = Pos; i < Size; i++)
        this.Data[i] = this.Data[i + 1];

      ::ArrayResize(this.Data, Size);
    }

    return(Pos >= 0);
  }

  int GetAmount( void ) const
  {
    return(::ArraySize(this.Data));
  }

  string Get( const long ID ) const
  {
    const int Pos = this.GetPos(ID);

    return((Pos < 0) ? NULL : this.Data[Pos].Str);
  }

  int IsTimeOut( const ulong TimeOut = 5e6 )
  {
    int Res = 0;
    int Pos = this.GetAmount();

    if (Pos)
    {
      const ulong time = ::GetMicrosecondCount();

      while (--Pos >= 0)
        if ((time - this.Data[Pos].FirstTime > TimeOut))
        {
          ::Alert("Delete timeout-message:" + this.Data[Pos].ToString());

          const int Length = ::StringLen(this.Data[Pos].Str);

          Res = this.Delete(this.Data[Pos].ID) ? Length : 0;

          break;
        }
    }

    return(Res);
  }
};