#include "Event_Message.mqh"

// Idea: https://www.mql5.com/ru/forum/337991/page2#comment_52727283
class CHARTSINFO
{
private:
  int AmountRequests;
  const int TimeOut;

  long ChartReceiver;

  string StrReceived[];

  template <typename T>
  static void AddElement( T &Array[], const T Value )
  {
    Array[::ArrayResize(Array, ::ArraySize(Array) + 1) - 1] = Value;

    return;
  }

public:
  const int EventCustom;

  CHARTSINFO( const int iEventCustom = (ushort)23451 + CHARTEVENT_CUSTOM,
              const int iTimeOut = 1e6 ) : AmountRequests(0), TimeOut(iTimeOut),
                                           ChartReceiver(0),
                                           EventCustom((ushort)(iEventCustom - CHARTEVENT_CUSTOM) + CHARTEVENT_CUSTOM)
  {
  }

  bool OnChartEvent( const int id, const long& lparam, const double& dparam, const string& sparam )
  {
    bool Res = false;

    if (dparam)
    {
      if (this.AmountRequests)
      {
        if (id == this.EventCustom)
        {
          const int WaitTime = (int)(::GetMicrosecondCount() - (ulong)lparam);

          if (WaitTime > this.TimeOut)
          {
            ::Print("EVENT_WAIT_INFORMATION(" + (string)this.EventCustom + ") - TimeOut: " + (string)WaitTime + " mcs. " +
                    (string)this.AmountRequests + "/" + (string)(int)dparam + " requests without answer.");

            this.AmountRequests = 0;
          }
          else
          {
            ::Sleep(0);
            ::EventChartCustom(0, (ushort)(this.EventCustom - CHARTEVENT_CUSTOM), lparam, dparam, NULL);
          }
        }
        else if (EVENT_MESSAGE::OnChartEvent(id, lparam, dparam, sparam))
        {
          CHARTSINFO::AddElement(this.StrReceived, EVENT_MESSAGE::Receive(lparam));

          this.AmountRequests--;
        }

        Res = !this.AmountRequests;
      }

      this.ChartReceiver = 0;
    }
    else
    {
      if (this.AmountRequests && EVENT_MESSAGE::OnChartEvent(id, lparam, dparam, sparam))
      {
        CHARTSINFO::AddElement(this.StrReceived, EVENT_MESSAGE::Receive(lparam));

        ;

        Res = !--this.AmountRequests;
      }

      this.ChartReceiver = ((id == this.EventCustom) && (!AmountRequests || (lparam == ::ChartID()))) ? lparam : 0;
    }

    return(Res);
  }

  bool IsStateToSend( void ) const
  {
    return((bool)this.ChartReceiver);
  }

  bool Send( const string Str )
  {
    return(this.ChartReceiver && EVENT_MESSAGE::Send(Str, this.ChartReceiver));
  }

  int Receive( string &sStrReceived[] )
  {
    const int Res = this.AmountRequests ? 0 : ::ArrayCopy(sStrReceived, this.StrReceived);

    if (::ArrayResize(sStrReceived, Res))
      ::ArrayFree(this.StrReceived);

    return(Res);
  }

  int Request( const long &Charts[] )
  {
    if (!this.AmountRequests)
    {
      ::ArrayFree(this.StrReceived);
      this.ChartReceiver = 0;

      for (uint i = ::ArraySize(Charts); (bool)i--;)
        this.AmountRequests += ::EventChartCustom(Charts[i], (ushort)(this.EventCustom - CHARTEVENT_CUSTOM), ::ChartID(), 0, NULL);

      if (this.AmountRequests)
      {
        ::Print("EVENT_REQUEST_INFORMATION(" + (string)this.EventCustom + ") - " + (string)this.AmountRequests + " requests.");

        ::EventChartCustom(0, (ushort)(this.EventCustom - CHARTEVENT_CUSTOM), ::GetMicrosecondCount(), AmountRequests, NULL);
      }
    }

    return(this.AmountRequests);
  }

  virtual int Request( void )
  {
    long Charts[];

    for (long Chart = ::ChartFirst(); Chart != -1; Chart = ::ChartNext(Chart))
      CHARTSINFO::AddElement(Charts, Chart);

    return(this.Request(Charts));
  }
};