#property copyright "Copyright 2017, trend_lab"
#property link      "https://www.trend-lab.ru"
#property strict

struct InternalIndexer;

class ICustom
{
public:
   virtual double Value(int buffer, int index) = 0;
   
   InternalIndexer operator [] (int buffer)
   {
      InternalIndexer res(GetPointer(this), buffer);
      return res;
   }
};

struct InternalIndexer
{
   InternalIndexer(ICustom* handler, int buffer)
      : handler_(handler)
      , buffer_(buffer)
   {}
   
   InternalIndexer(const InternalIndexer& other)
      : handler_(other.handler_)
      , buffer_(other.buffer_)
   {}
   
   ICustom* handler_;
   int buffer_;
   
   double operator [] (int i)
   {
      return handler_.Value(buffer_, i);
   }
};

class Custom : public ICustom
{
public:
  Custom(string symbol, ENUM_TIMEFRAMES tf, string name)
    : m_name(name)
    , m_symbol(symbol)
    , m_tf(tf)
  {}
  
  string Name() const {return m_name;}
  string Instrument() const {return m_symbol;}
  ENUM_TIMEFRAMES TF() const {return m_tf;}

  virtual double Value(int buffer, int index) = 0;
  
protected:
  string m_name;
  string m_symbol;
  ENUM_TIMEFRAMES m_tf;
};

template <typename t1>
class CustomImpl1 : public Custom
{
public:
  CustomImpl1(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1)
    : Custom(symbol, tf, name)
    , m_v1(v1)
  {}
  
  double Value(int buffer, int index)
  {
    return iCustom(m_symbol, m_tf, m_name, m_v1, buffer, index);
  }

private:
  t1 m_v1;
};

template <typename t1, typename t2>
class CustomImpl2 : public Custom
{
public:
  CustomImpl2(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2)
    : Custom(symbol, tf, name)
    , m_v1(v1)
    , m_v2(v2)
  {}
  
  double Value(int buffer, int index)
  {
    return iCustom(m_symbol, m_tf, m_name, m_v1, m_v2, buffer, index);
  }

private:
  t1 m_v1;
  t2 m_v2;
};

template <typename t1, typename t2, typename t3>
class CustomImpl3 : public Custom
{
public:
  CustomImpl3(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2, t3 v3)
    : Custom(symbol, tf, name)
    , m_v1(v1)
    , m_v2(v2)
    , m_v3(v3)
  {}
  
  double Value(int buffer, int index)
  {
    return iCustom(m_symbol, m_tf, m_name, m_v1, m_v2, m_v3, buffer, index);
  }

private:
  t1 m_v1;
  t2 m_v2;
  t3 m_v3;
};

template <typename t1, typename t2, typename t3, typename t4>
class CustomImpl4 : public Custom
{
public:
  CustomImpl4(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2, t3 v3, t4 v4)
    : Custom(symbol, tf, name)
    , m_v1(v1)
    , m_v2(v2)
    , m_v3(v3)
    , m_v4(v4)
  {}
  
  double Value(int buffer, int index)
  {
    return iCustom(m_symbol, m_tf, m_name, m_v1, m_v2, m_v3, m_v4, buffer, index);
  }

private:
  t1 m_v1;
  t2 m_v2;
  t3 m_v3;
  t4 m_v4;
};

template <typename t1, typename t2, typename t3, typename t4, typename t5>
class CustomImpl5 : public Custom
{
public:
  CustomImpl5(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5)
    : Custom(symbol, tf, name)
    , m_v1(v1)
    , m_v2(v2)
    , m_v3(v3)
    , m_v4(v4)
    , m_v5(v5)
  {}
  
  double Value(int buffer, int index)
  {
    return iCustom(m_symbol, m_tf, m_name, m_v1, m_v2, m_v3, m_v4, m_v5, buffer, index);
  }

private:
  t1 m_v1;
  t2 m_v2;
  t3 m_v3;
  t4 m_v4;
  t5 m_v5;
};

template <typename t1, typename t2, typename t3, typename t4, typename t5, typename t6>
class CustomImpl6 : public Custom
{
public:
  CustomImpl6(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5, t6 v6)
    : Custom(symbol, tf, name)
    , m_v1(v1)
    , m_v2(v2)
    , m_v3(v3)
    , m_v4(v4)
    , m_v5(v5)
    , m_v6(v6)
  {}
  
  double Value(int buffer, int index)
  {
    return iCustom(m_symbol, m_tf, m_name, m_v1, m_v2, m_v3, m_v4, m_v5, m_v6, buffer, index);
  }

private:
  t1 m_v1;
  t2 m_v2;
  t3 m_v3;
  t4 m_v4;
  t5 m_v5;
  t6 m_v6;
};

template <typename t1, typename t2, typename t3, typename t4, typename t5, typename t6, typename t7>
class CustomImpl7 : public Custom
{
public:
  CustomImpl7(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5, t6 v6, t7 v7)
    : Custom(symbol, tf, name)
    , m_v1(v1)
    , m_v2(v2)
    , m_v3(v3)
    , m_v4(v4)
    , m_v5(v5)
    , m_v6(v6)
    , m_v7(v7)
  {}
  
  double Value(int buffer, int index)
  {
    return iCustom(m_symbol, m_tf, m_name, m_v1, m_v2, m_v3, m_v4, m_v5, m_v6, m_v7, buffer, index);
  }

private:
  t1 m_v1;
  t2 m_v2;
  t3 m_v3;
  t4 m_v4;
  t5 m_v5;
  t6 m_v6;
  t7 m_v7;
};

template <typename t1, typename t2, typename t3, typename t4, typename t5, typename t6, typename t7, typename t8>
class CustomImpl8 : public Custom
{
public:
  CustomImpl8(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5, t6 v6, t7 v7, t8 v8)
    : Custom(symbol, tf, name)
    , m_v1(v1)
    , m_v2(v2)
    , m_v3(v3)
    , m_v4(v4)
    , m_v5(v5)
    , m_v6(v6)
    , m_v7(v7)
    , m_v8(v8)
  {}
  
  double Value(int buffer, int index)
  {
    return iCustom(m_symbol, m_tf, m_name, m_v1, m_v2, m_v3, m_v4, m_v5, m_v6, m_v7, m_v8, buffer, index);
  }

private:
  t1 m_v1;
  t2 m_v2;
  t3 m_v3;
  t4 m_v4;
  t5 m_v5;
  t6 m_v6;
  t7 m_v7;
  t8 m_v8;
};

template <typename t1, typename t2, typename t3, typename t4, typename t5, typename t6, typename t7, typename t8, typename t9>
class CustomImpl9 : public Custom
{
public:
  CustomImpl9(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5, t6 v6, t7 v7, t8 v8, t9 v9)
    : Custom(symbol, tf, name)
    , m_v1(v1)
    , m_v2(v2)
    , m_v3(v3)
    , m_v4(v4)
    , m_v5(v5)
    , m_v6(v6)
    , m_v7(v7)
    , m_v8(v8)
    , m_v9(v9)
  {}
  
  double Value(int buffer, int index)
  {
    return iCustom(m_symbol, m_tf, m_name, m_v1, m_v2, m_v3, m_v4, m_v5, m_v6, m_v7, m_v8, m_v9, buffer, index);
  }

private:
  t1 m_v1;
  t2 m_v2;
  t3 m_v3;
  t4 m_v4;
  t5 m_v5;
  t6 m_v6;
  t7 m_v7;
  t8 m_v8;
  t9 m_v9;
};

template <typename t1, typename t2, typename t3, typename t4, typename t5, typename t6, typename t7, typename t8, typename t9, typename t10>
class CustomImpl10 : public Custom
{
public:
  CustomImpl10(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5, t6 v6, t7 v7, t8 v8, t9 v9, t10 v10)
    : Custom(symbol, tf, name)
    , m_v1(v1)
    , m_v2(v2)
    , m_v3(v3)
    , m_v4(v4)
    , m_v5(v5)
    , m_v6(v6)
    , m_v7(v7)
    , m_v8(v8)
    , m_v9(v9)
    , m_v10(v10)
  {}
  
  double Value(int buffer, int index)
  {
    return iCustom(m_symbol, m_tf, m_name, m_v1, m_v2, m_v3, m_v4, m_v5, m_v6, m_v7, m_v8, m_v9, m_v10, buffer, index);
  }

private:
  t1 m_v1;
  t2 m_v2;
  t3 m_v3;
  t4 m_v4;
  t5 m_v5;
  t6 m_v6;
  t7 m_v7;
  t8 m_v8;
  t9 m_v9;
  t10 m_v10;
};

// 1
template <typename t1>
ICustom* CreateCustom(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1)
{return new CustomImpl1<t1>(symbol, tf, name, v1);}
template <typename t1>
ICustom* CreateCustom(string symbol, int tf, string name, t1 v1)
{return new CustomImpl1<t1>(symbol, (ENUM_TIMEFRAMES)tf, name, v1);}

// 2
template <typename t1, typename t2>
ICustom* CreateCustom(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2)
{return new CustomImpl2<t1, t2>(symbol, tf, name, v1, v2);}
template <typename t1, typename t2>
ICustom* CreateCustom(string symbol, int tf, string name, t1 v1, t2 v2)
{return new CustomImpl2<t1, t2>(symbol, (ENUM_TIMEFRAMES)tf, name, v1, v2);}

// 3
template <typename t1, typename t2, typename t3>
ICustom* CreateCustom(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2, t3 v3)
{return new CustomImpl3<t1, t2, t3>(symbol, tf, name, v1, v2, v3);}
template <typename t1, typename t2, typename t3>
ICustom* CreateCustom(string symbol, int tf, string name, t1 v1, t2 v2, t3 v3)
{return new CustomImpl3<t1, t2, t3>(symbol, (ENUM_TIMEFRAMES)tf, name, v1, v2, v3);}

// 4
template <typename t1, typename t2, typename t3, typename t4>
ICustom* CreateCustom(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2, t3 v3, t4 v4)
{return new CustomImpl4<t1, t2, t3, t4>(symbol, tf, name, v1, v2, v3, v4);}
template <typename t1, typename t2, typename t3, typename t4>
ICustom* CreateCustom(string symbol, int tf, string name, t1 v1, t2 v2, t3 v3, t4 v4)
{return new CustomImpl4<t1, t2, t3, t4>(symbol, (ENUM_TIMEFRAMES)tf, name, v1, v2, v3, v4);}

// 5
template <typename t1, typename t2, typename t3, typename t4, typename t5>
ICustom* CreateCustom(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5)
{return new CustomImpl5<t1, t2, t3, t4, t5>(symbol, tf, name, v1, v2, v3, v4, v5);}
template <typename t1, typename t2, typename t3, typename t4, typename t5>
ICustom* CreateCustom(string symbol, int tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5)
{return new CustomImpl5<t1, t2, t3, t4, t5>(symbol, (ENUM_TIMEFRAMES)tf, name, v1, v2, v3, v4, v5);}

// 6
template <typename t1, typename t2, typename t3, typename t4, typename t5, typename t6>
ICustom* CreateCustom(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5, t6 v6)
{return new CustomImpl6<t1, t2, t3, t4, t5, t6>(symbol, tf, name, v1, v2, v3, v4, v5, v6);}
template <typename t1, typename t2, typename t3, typename t4, typename t5, typename t6>
ICustom* CreateCustom(string symbol, int tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5, t6 v6)
{return new CustomImpl6<t1, t2, t3, t4, t5, t6>(symbol, (ENUM_TIMEFRAMES)tf, name, v1, v2, v3, v4, v5, v6);}

// 7
template <typename t1, typename t2, typename t3, typename t4, typename t5, typename t6, typename t7>
ICustom* CreateCustom(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5, t6 v6, t7 v7)
{return new CustomImpl7<t1, t2, t3, t4, t5, t6, t7>(symbol, tf, name, v1, v2, v3, v4, v5, v6, v7);}
template <typename t1, typename t2, typename t3, typename t4, typename t5, typename t6, typename t7>
ICustom* CreateCustom(string symbol, int tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5, t6 v6, t7 v7)
{return new CustomImpl7<t1, t2, t3, t4, t5, t6, t7>(symbol, (ENUM_TIMEFRAMES)tf, name, v1, v2, v3, v4, v5, v6, v7);}

// 8
template <typename t1, typename t2, typename t3, typename t4, typename t5, typename t6, typename t7, typename t8>
ICustom* CreateCustom(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5, t6 v6, t7 v7, t8 v8)
{return new CustomImpl8<t1, t2, t3, t4, t5, t6, t7, t8>(symbol, tf, name, v1, v2, v3, v4, v5, v6, v7, v8);}
template <typename t1, typename t2, typename t3, typename t4, typename t5, typename t6, typename t7, typename t8>
ICustom* CreateCustom(string symbol, int tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5, t6 v6, t7 v7, t8 v8)
{return new CustomImpl8<t1, t2, t3, t4, t5, t6, t7, t8>(symbol, (ENUM_TIMEFRAMES)tf, name, v1, v2, v3, v4, v5, v6, v7, v8);}

// 9
template <typename t1, typename t2, typename t3, typename t4, typename t5, typename t6, typename t7, typename t8, typename t9>
ICustom* CreateCustom(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5, t6 v6, t7 v7, t8 v8, t9 v9)
{return new CustomImpl9<t1, t2, t3, t4, t5, t6, t7, t8, t9>(symbol, tf, name, v1, v2, v3, v4, v5, v6, v7, v8, v9);}
template <typename t1, typename t2, typename t3, typename t4, typename t5, typename t6, typename t7, typename t8, typename t9>
ICustom* CreateCustom(string symbol, int tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5, t6 v6, t7 v7, t8 v8, t9 v9)
{return new CustomImpl9<t1, t2, t3, t4, t5, t6, t7, t8, t9>(symbol, (ENUM_TIMEFRAMES)tf, name, v1, v2, v3, v4, v5, v6, v7, v8, v9);}

// 10
template <typename t1, typename t2, typename t3, typename t4, typename t5, typename t6, typename t7, typename t8, typename t9, typename t10>
ICustom* CreateCustom(string symbol, ENUM_TIMEFRAMES tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5, t6 v6, t7 v7, t8 v8, t9 v9, t10 v10)
{return new CustomImpl10<t1, t2, t3, t4, t5, t6, t7, t8, t9, t10>(symbol, tf, name, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10);}
template <typename t1, typename t2, typename t3, typename t4, typename t5, typename t6, typename t7, typename t8, typename t9, typename t10>
ICustom* CreateCustom(string symbol, int tf, string name, t1 v1, t2 v2, t3 v3, t4 v4, t5 v5, t6 v6, t7 v7, t8 v8, t9 v9, t10 v10)
{return new CustomImpl10<t1, t2, t3, t4, t5, t6, t7, t8, t9, t10>(symbol, (ENUM_TIMEFRAMES)tf, name, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10);}
