//+------------------------------------------------------------------+
//|                                        Middle Moving Average.mq4 |
//|                                   "Copyright 2016, DLim0n4IK.DK" |
//|                       https://www.mql5.com/ru/users/dlim0n4ik.dk |
//+------------------------------------------------------------------+
#property copyright "Copyright 2016, DLim0n4IK.DK"
#property link      "https://www.mql5.com/ru/users/dlim0n4ik.dk"
#property version   "161.015"
#property description "    Moving Average"
#property strict
#define MAGICMA  20161015
extern double  Lots           =0.01;   // 
extern double  MaximumRisk    =0.02;   // 
extern double  DecreaseFactor =3;      //DF
extern double  StopLoss       = 0;     //  ( )
extern double  TakeProfit     = 0;     //  ( )
//--------------------------------------------------------------------
extern string           MA_Info           = " MA"; //
extern ENUM_TIMEFRAMES  MA_TimeFrame      = PERIOD_CURRENT; //
extern int              MA_Period         = 20;             //
extern int              MA_Shift          = 0;              // 
extern ENUM_MA_METHOD   MA_Method         = MODE_EMA;       //  
//extern ENUM_APPLIED_PRICE   MA_Applied_Price  = PRICE_CLOSE;   //Applied price
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
{
//---

//---
return(INIT_SUCCEEDED);
}
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
//---

//---
}
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
{
//---         -------------
if(Bars<100 || IsTradeAllowed()==false) return;
//--- calculate open orders by current symbol
if(CalculateCurrentOrders(Symbol())==0) CheckForOpen();
else                                    CheckForClose();
//---
}
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                            |
//+------------------------------------------------------------------+
int CalculateCurrentOrders(string symbol)
{
int Count = 0;
for(int index = 0; index < OrdersTotal();index++)
   {
   if(OrderSelect(index,SELECT_BY_POS,MODE_TRADES)==false) break;
   if(OrderSymbol()==symbol && OrderMagicNumber()==MAGICMA)
      {
      if(OrderType()==OP_BUY || OrderType()==OP_SELL)  Count++;
      }
   }
return(Count);
}
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                                     |
//+------------------------------------------------------------------+
double LotsOptimized()
{
//---   ----------------------------------------
string   symbol   /*   */                      = Symbol();
int      orders   /*     */     = HistoryTotal();
int      losses   /*   */      = 0;
int      digits   /*     */  = 2;
double   lot      /*   */                      = Lots;
//--------------------------------------------------------------------
lot=NormalizeDouble(AccountFreeMargin()*MaximumRisk/1000.0,digits); //  
//---     ------------------------
if(DecreaseFactor>0)
   {
   for(int index = orders-1; index >= 0; index--)
      {
      if(OrderSelect(index,SELECT_BY_POS,MODE_HISTORY)==false)
         {
         Print("Error in history!");
         break;
         }
      if(OrderSymbol()==symbol && OrderMagicNumber()==MAGICMA)
         {
         if(OrderType()==OP_BUY || OrderType()==OP_SELL)
            {
            if(OrderProfit()>0) break;
            if(OrderProfit()<0) losses++;
            }
         }
      }
   if(losses>1) lot=NormalizeDouble(lot-lot*losses/DecreaseFactor,digits);
   }
//--------------------------------------------------------------------
if(lot<0.01) lot=0.01;
return(lot);
}
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                    |                                                                  |
//+------------------------------------------------------------------+
string Signal()
{
//---   ----------------------------------------
string               symbol         /*   */       = Symbol();
ENUM_TIMEFRAMES      timeframe      /*  */         = MA_TimeFrame;
int                  ma_period      /*  */            = MA_Period;
int                  ma_shift       /*   */     = MA_Shift;
ENUM_MA_METHOD       ma_method      /*   */  = MA_Method;
//ENUM_APPLIED_PRICE   applied_price  /*   */          = MA_Applied_Price;
int                  shift          /*  */             = 1;
int  digits   = (int) SymbolInfoInteger(symbol,SYMBOL_DIGITS); //
//--------------------------------------------------------------------
double hMA = NormalizeDouble(iMA(symbol,timeframe,ma_period,ma_shift,ma_method,PRICE_HIGH,shift),digits);
double cMA = NormalizeDouble(iMA(symbol,timeframe,ma_period,ma_shift,ma_method,PRICE_CLOSE,shift),digits);
double oMA = NormalizeDouble(iMA(symbol,timeframe,ma_period,ma_shift,ma_method,PRICE_OPEN,shift),digits);
double lMA = NormalizeDouble(iMA(symbol,timeframe,ma_period,ma_shift,ma_method,PRICE_LOW,shift),digits);
double MA = NormalizeDouble((hMA+cMA+oMA+lMA) / 4,digits);
//--------------------------------------------------------------------
if (Open[1] < MA && Close[1] > MA)return("BUY");
if (Open[1] > MA && Close[1] < MA)return("SELL");
//--------------------------------------------------------------------
return("NO Signal");
}
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+
void CheckForOpen()
{
if(Volume[0]>1) return; //    
//---       -------------------------
if(Signal()=="BUY")
   {
   OpenOrder("BUY");
   return;
   }
//---       -------------------------
if(Signal()=="SELL")
   {
   OpenOrder("SELL");
   return;
   }
}
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+
void CheckForClose()
{
//---   ----------------------------------------
string   symbol   /*   */ = Symbol();
if(Volume[0]>1) return;
for(int index = 0; index < OrdersTotal(); index++)
   {
   if(OrderSelect(index,SELECT_BY_POS,MODE_TRADES)==false) break;
   if(OrderSymbol()!=symbol || OrderMagicNumber()!=MAGICMA) continue;
//--------------------------------------------------------------------
   if(OrderType()==OP_BUY)
      {
      if(Signal()=="SELL")
         {
         if(!OrderClose(OrderTicket(),OrderLots(),Bid,3,White))
               Print("OrderClose error ",GetLastError());
         }
      break;
      }
//--------------------------------------------------------------------
   if(OrderType()==OP_SELL)
      {
      if(Signal()=="BUY")
         {
         if(!OrderClose(OrderTicket(),OrderLots(),Ask,3,White))
               Print("OrderClose error ",GetLastError());
         }
      break;
      }
   }
}
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                                             |
//|------------------------------------------------------------------|
//|    :                                             |
//|   OpenOrder("BUY")  -     (BUY)           |
//|   OpenOrder("SELL") -     (SELL)          |
//+------------------------------------------------------------------+
void OpenOrder(string type)
{
//---   ----------------------------------------
int               ticket      = 0;
string            symbol      /* C */                  = Symbol();
ENUM_ORDER_TYPE   cmd         /*   */       = ORDER_TYPE_BUY; 
double            volume      /*   */        = LotsOptimized();
double            price       /*  */                    = 0.0;
int               slippage    /*  */         = 3; 
double            stoploss    /* stop loss */               = 0;
double            takeprofit  /* take profit */             = 0;
string            comment     /*  */             = NULL;
int               magic       /*  */           = MAGICMA;
datetime          expiration  /* C   */   = 0;
color             arrow_color /*  */                    = clrNONE;
//---   ---------------------------------------------
double point   = MarketInfo(symbol,MODE_POINT);  //  Point
int digits  = (int)MarketInfo(symbol,MODE_DIGITS);  //  Digits
//---       --------------
if (type == "BUY")
   {
   cmd = ORDER_TYPE_BUY;
   price = NormalizeDouble(Ask,digits);
   if (StopLoss > 0) stoploss = NormalizeDouble(Bid - StopLoss * point,digits);
   if (TakeProfit > 0) takeprofit = NormalizeDouble(Ask + TakeProfit * point,digits);
   arrow_color = Green;
   }
if (type == "SELL")
   {
   cmd = ORDER_TYPE_SELL;
   price = NormalizeDouble(Bid,digits);
   if (StopLoss > 0) stoploss = NormalizeDouble(Ask + StopLoss * point,digits); 
   if (TakeProfit > 0) takeprofit = NormalizeDouble(Bid - TakeProfit * point,digits);
   arrow_color = Red;
   }
//---        -------------
double free_margin=AccountFreeMarginCheck(symbol,cmd,volume);
if(free_margin<0) //     
   {
   string oper=(cmd==OP_BUY)? "Buy":"Sell";
   Print("Not enough money for ", oper," ",volume, " ", symbol, " Error code=",GetLastError());
   return;
   }
//--------------------------------------------------------------------
if(free_margin>0)
   {ticket = OrderSend(symbol,cmd,volume,price,slippage,stoploss,takeprofit,comment,magic,expiration,arrow_color);}
//--------------------------------------------------------------------
}
//+------------------------------------------------------------------+