//+------------------------------------------------------------------+
//|                                            ea_RSI_2MA_system.mq4 |
//|                                               Yuriy Tokman (YTG) |
//|                                               http://ytg.com.ua/ |
//+------------------------------------------------------------------+
#property copyright "Yuriy Tokman (YTG)"
#property link      "http://ytg.com.ua/"
#property version   "1.00"
#property description "yuriytokman@gmail.com"
#property description " "
#property description "http://ytg.com.ua/"
#property strict

extern double Lots       = 0.1;        
//  
extern int    StopLoss   = 30;         
//    
extern int    TakeProfit = 60;         
//    

extern int    Magic        = 2808;       
//  
extern bool   TSProfitOnly = True;     
//   
extern int    TStop_Buy    = 50;       
//      
extern int    TStop_Sell   = 35;       
//      
extern int    TrailingStep = 3;        
//    

extern int    MagicNumber   = 2808;
extern int    NumberAccount = 0;            
//   
extern bool   UseSound      = True;         
//   
extern string NameFileSound = "expert.wav"; 
//   
extern bool   ShowComment   = True;         
//  
extern bool   MarketWatch   = True;         
//    "Market Watch".
extern int    Slippage      = 3;            
//  
extern int    NumberOfTry   = 5;            
//   

bool  gbDisabled = False;         //   
bool  gbNoInit   = False;         //   
color clOpenBuy  = LightBlue;     //    
color clOpenSell = LightCoral;    //    
#include <stdlib.mqh>        //   4
//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//----
  gbNoInit=False;
  if (!IsTradeAllowed()) {
    Message("    \n"+
            "  ");
    gbNoInit=True; return(0);
  }
  if (!IsLibrariesAllowed()) {
    Message("    \n"+
            "    ");
    gbNoInit=True; return(0);
  }
  if (!IsTesting()) {
    if (IsExpertEnabled()) Message("    ");
    else Message("  \"  \"");
  }   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
void deinit(){if(!IsTesting()) Comment("");}
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
//----
  if (gbDisabled) {
    Message(" !  !"); return(0);
  }
  if (gbNoInit) {
    Message("   !"); return(0);
  }
  if (!IsTesting()) {
    if (NumberAccount>0 && NumberAccount!=AccountNumber()) {
      Comment("  : "+DoubleToStr(AccountNumber(),0)+" !");
      return(0);
    } else Comment("");
    if (ShowComment) {
      string st="CurTime="+TimeToStr(TimeCurrent(), TIME_MINUTES)
               +"  Lots="+DoubleToStr(Lots, 1)
               +"  StopLoss="+DoubleToStr(StopLoss, 0)+" ."
               +"  TakeProfit="+DoubleToStr(TakeProfit, 0)+" ."
               +IIFs(MarketWatch, "  MarketWatch", "")
               +"\n"
               +"Magic="+IIFs(Magic<0, "", DoubleToStr(Magic, 0))+"  "
               +IIFs(TSProfitOnly, "TSProfitOnly  ", "")
               +"TStop.Buy="+DoubleToStr(TStop_Buy, 0)+"  "
               +"TStop.Sell="+DoubleToStr(TStop_Sell, 0)+"  "
               +"TrailingStep="+DoubleToStr(TrailingStep, 0)+"  "               
               ;
      Comment(st);
    } else Comment("");
  }   
//----
 if(!ExistPositions(Symbol(),-1,MagicNumber))
  {
   if(SignalFun()>0)
   OpenPosition(Symbol(), OP_BUY, Lots, Ask-StopLoss*Point, Ask+TakeProfit*Point,MagicNumber);
   if(SignalFun()<0)
   OpenPosition(Symbol(), OP_SELL, Lots, Bid+StopLoss*Point, Bid-TakeProfit*Point,MagicNumber);
  }
  
  else SimpleTrailing(Symbol(), -1, MagicNumber);
//----
   return(0);
  }
//+----------------------------------------------------------------------------+
//    . 1 - , -1 - , 0 - 
 int SignalFun()
  {
   double fast_ma0 = iMA(NULL,0,6,8,MODE_SMMA,PRICE_MEDIAN,0);
   double fast_ma1 = iMA(NULL,0,6,8,MODE_SMMA,PRICE_MEDIAN,1);   
   double slow_ma0 = iMA(NULL,0,16,8,MODE_SMMA,PRICE_MEDIAN,0);
   double slow_ma1 = iMA(NULL,0,16,8,MODE_SMMA,PRICE_MEDIAN,1);
   double rsi = iRSI(NULL,0,14,PRICE_CLOSE,0);
   
   if(fast_ma1<slow_ma1 && fast_ma0>slow_ma0 && rsi>50)return(1);   
   if(fast_ma1>slow_ma1 && fast_ma0<slow_ma0 && rsi<50)return(-1);
   return(0);   
  }
//----

//----
bool ExistPositions(string sy="", int op=-1, int mn=-1, datetime ot=0) {
  int i, k=OrdersTotal();

  if (sy=="0") sy=Symbol();
  for (i=0; i<k; i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderSymbol()==sy || sy=="") {
        if (OrderType()==OP_BUY || OrderType()==OP_SELL) {
          if (op<0 || OrderType()==op) {
            if (mn<0 || OrderMagicNumber()==mn) {
              if (ot<=OrderOpenTime()) return(True);
            }
          }
        }
      }
    }
  }
  return(False);
}
//+----------------------------------------------------------------------------+
string GetNameOP(int op) {
  switch (op) {
    case OP_BUY      : return("Buy");
    case OP_SELL     : return("Sell");
    case OP_BUYLIMIT : return("Buy Limit");
    case OP_SELLLIMIT: return("Sell Limit");
    case OP_BUYSTOP  : return("Buy Stop");
    case OP_SELLSTOP : return("Sell Stop");
    default          : return("Unknown Operation");
  }
}
//+----------------------------------------------------------------------------+
string GetNameTF(int TimeFrame=0) {
  if (TimeFrame==0) TimeFrame=Period();
  switch (TimeFrame) {
    case PERIOD_M1:  return("M1");
    case PERIOD_M5:  return("M5");
    case PERIOD_M15: return("M15");
    case PERIOD_M30: return("M30");
    case PERIOD_H1:  return("H1");
    case PERIOD_H4:  return("H4");
    case PERIOD_D1:  return("Daily");
    case PERIOD_W1:  return("Weekly");
    case PERIOD_MN1: return("Monthly");
    default:         return("UnknownPeriod");
  }
}
//+----------------------------------------------------------------------------+
string IIFs(bool condition, string ifTrue, string ifFalse) {
  if (condition) return(ifTrue); else return(ifFalse);
}
//+----------------------------------------------------------------------------+
void Message(string m) {
  Comment(m);
  if (StringLen(m)>0) Print(m);
}
//+----------------------------------------------------------------------------+
void ModifyOrder(double pp=-1, double sl=0, double tp=0, datetime ex=0) {
  bool   fm;
  color  cl=clrAliceBlue;
  double op, pa, pb, os, ot;
  int    dg=(int)MarketInfo(OrderSymbol(), MODE_DIGITS), er, it;

  if (pp<=0) pp=OrderOpenPrice();
  if (sl<0 ) sl=OrderStopLoss();
  if (tp<0 ) tp=OrderTakeProfit();
  
  pp=NormalizeDouble(pp, dg);
  sl=NormalizeDouble(sl, dg);
  tp=NormalizeDouble(tp, dg);
  op=NormalizeDouble(OrderOpenPrice() , dg);
  os=NormalizeDouble(OrderStopLoss()  , dg);
  ot=NormalizeDouble(OrderTakeProfit(), dg);

  if (pp!=op || sl!=os || tp!=ot) {
    for (it=1; it<=NumberOfTry; it++) {
      if (!IsTesting() && (!IsExpertEnabled() || IsStopped())) break;
      while (!IsTradeAllowed()) Sleep(5000);
      RefreshRates();
      fm=OrderModify(OrderTicket(), pp, sl, tp, ex, cl);
      if (fm) {
        if (UseSound) PlaySound(NameFileSound); break;
      } else {
        er=GetLastError();
        pa=MarketInfo(OrderSymbol(), MODE_ASK);
        pb=MarketInfo(OrderSymbol(), MODE_BID);
        Print("Error(",er,") modifying order: ",ErrorDescription(er),", try ",it);
        Print("Ask=",pa,"  Bid=",pb,"  sy=",OrderSymbol(),
              "  op="+GetNameOP(OrderType()),"  pp=",pp,"  sl=",sl,"  tp=",tp);
        Sleep(1000*10);
      }
    }
  }
}
//+----------------------------------------------------------------------------+
//----+
void OpenPosition(string sy, int op, double ll, double sl=0, double tp=0, int mn=0) {
  color    clOpen;
  datetime ot;
  double   pp, pa, pb;
  int      dg, err, it, ticket=0;
  string   lsComm=WindowExpertName()+" "+GetNameTF(Period());

  if (sy=="" || sy=="0") sy=Symbol();
  if (op==OP_BUY) clOpen=clOpenBuy; else clOpen=clOpenSell;
  for (it=1; it<=NumberOfTry; it++) {
    if (!IsTesting() && (!IsExpertEnabled() || IsStopped())) {
      Print("OpenPosition():   ");
      break;
    }
    while (!IsTradeAllowed()) Sleep(5000);
    RefreshRates();
    dg=(int)MarketInfo(sy, MODE_DIGITS);
    pa=MarketInfo(sy, MODE_ASK);
    pb=MarketInfo(sy, MODE_BID);
    if (op==OP_BUY) pp=pa; else pp=pb;
    pp=NormalizeDouble(pp, dg);
    ot=TimeCurrent();
    if (MarketWatch)
      ticket=OrderSend(sy, op, ll, pp, Slippage, 0, 0, lsComm, mn, 0, clOpen);
    else
      ticket=OrderSend(sy, op, ll, pp, Slippage, sl, tp, lsComm, mn, 0, clOpen);
    if (ticket>0) {
      if (UseSound) PlaySound(NameFileSound); break;
    } else {
      err=GetLastError();
      if (pa==0 && pb==0) Message("      "+sy);
      //    
      Print("Error(",err,") opening position: ",ErrorDescription(err),", try ",it);
      Print("Ask=",pa," Bid=",pb," sy=",sy," ll=",ll," op=",GetNameOP(op),
            " pp=",pp," sl=",sl," tp=",tp," mn=",mn);
      //   
      if (err==2 || err==64 || err==65 || err==133) {
        gbDisabled=True; break;
      }
      //  
      if (err==4 || err==131 || err==132) {
        Sleep(1000*300); break;
      }
      if (err==128 || err==142 || err==143) {
        Sleep(1000*66.666);
        if (ExistPositions(sy, op, mn, ot)) {
          if (UseSound) PlaySound(NameFileSound); break;
        }
      }
      if (err==140 || err==148 || err==4110 || err==4111) break;
      if (err==141) Sleep(1000*100);
      if (err==145) Sleep(1000*17);
      if (err==146) while (IsTradeContextBusy()) Sleep(1000*11);
      if (err!=135) Sleep(1000*7.7);
    }
  }
  if (MarketWatch && ticket>0 && (sl>0 || tp>0)) {
    if (OrderSelect(ticket, SELECT_BY_TICKET)) ModifyOrder(-1, sl, tp);
  }
}
//+----------------------------------------------------------------------------+
void SimpleTrailing(string sy="", int op=-1, int mn=-1) {
  double po, pp;
  int    i, k=OrdersTotal();

  if (sy=="0") sy=Symbol();
  for (i=0; i<k; i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if ((OrderSymbol()==sy || sy=="") && (op<0 || OrderType()==op)) {
        po=MarketInfo(OrderSymbol(), MODE_POINT);
        if (mn<0 || OrderMagicNumber()==mn) {
          if (OrderType()==OP_BUY) {
            pp=MarketInfo(OrderSymbol(), MODE_BID);
            if (!TSProfitOnly || pp-OrderOpenPrice()>TStop_Buy*po) {
              if (OrderStopLoss()<pp-(TStop_Buy+TrailingStep-1)*po) {
                ModifyOrder(-1, pp-TStop_Buy*po, -1);
              }
            }
          }
          if (OrderType()==OP_SELL) {
            pp=MarketInfo(OrderSymbol(), MODE_ASK);
            if (!TSProfitOnly || OrderOpenPrice()-pp>TStop_Sell*po) {
              if (OrderStopLoss()>pp+(TStop_Sell+TrailingStep-1)*po || OrderStopLoss()==0) {
                ModifyOrder(-1, pp+TStop_Sell*po, -1);
              }
            }
          }
        }
      }
    }
  }
}
//+----------------------------------------------------------------------------+

