//+------------------------------------------------------------------+
//|                                           SilverTrend_Signal.mq5 |
//|                                        Ramdass - Conversion only |
//+------------------------------------------------------------------+
#property copyright "SilverTrend  rewritten by CrazyChart"
#property link      "http://viac.ru/"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 2
//----     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_ARROW
//----         Red
#property indicator_color1  clrRed
//----    1  4
#property indicator_width1  4
//----     
#property indicator_label1  "Silver Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----         Lime
#property indicator_color2  clrLime
//----    2  4
#property indicator_width2  4
//----     
#property indicator_label2 "Silver Buy"

//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int SSP=9;
input int RISK=3;                                // 
input int NumberofAlerts=2;
//+----------------------------------------------+

//----   ,   
//----      
double SellBuffer[];
double BuyBuffer[];
//----
int K;
int counter=0;
bool old,uptrend_;
//----      
int StartBars;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//----     
   StartBars=SSP+1;
//----      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,StartBars);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"Silver Sell");
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,108);
//----    ,   
   ArraySetAsSeries(SellBuffer,true);

//----      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,StartBars);
//---      DataWindow
   PlotIndexSetString(1,PLOT_LABEL,"Silver Buy");
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,108);
//----    ,   
   ArraySetAsSeries(BuyBuffer,true);

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----         
   string short_name="SilverTrend_Signal";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//----   
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<StartBars) return(0);

//----    
   int limit;
   double Range,AvgRange,smin,smax,SsMax,SsMin,price;
   bool uptrend;

//----     
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      K=33-RISK;
      limit=rates_total-StartBars;       //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }

//----    ,     
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);

//----   
   uptrend=uptrend_;

//----    
   for(int bar=limit; bar>=0; bar--)
     {
      //----        
      if(rates_total!=prev_calculated && bar==0)
        {
         uptrend_=uptrend;
        }

      Range=0;
      AvgRange=0;
      for(int iii=bar; iii<=bar+SSP; iii++) AvgRange=AvgRange+MathAbs(high[iii]-low[iii]);
      Range=AvgRange/(SSP+1);
      //----
      SsMax=low[bar];
      SsMin=close[bar];

      for(int kkk=bar; kkk<=bar+SSP-1; kkk++)
        {
         price=high[kkk];
         if(SsMax<price) SsMax=price;
         price=low[kkk];
         if(SsMin>=price) SsMin=price;
        }

      smin=SsMin+(SsMax-SsMin)*K/100;
      smax=SsMax-(SsMax-SsMin)*K/100;

      SellBuffer[bar]=0;
      BuyBuffer[bar]=0;

      if(close[bar]<smin) uptrend=false;
      if(close[bar]>smax) uptrend=true;

      if(uptrend!=old && uptrend==true)
        {
         BuyBuffer[bar]=low[bar]-Range*0.5;

         if(bar==0)
           {
            if(counter<=NumberofAlerts)
              {
               Alert("Silver Trend ",EnumToString(Period())," ",Symbol()," BUY");
               counter++;
              }
           }
         else counter=0;
        }
      if(uptrend!=old && uptrend==false)
        {
         SellBuffer[bar]=high[bar]+Range*0.5;

         if(bar==0)
           {
            if(counter<=NumberofAlerts)
              {
               Alert("Silver Trend ",EnumToString(Period())," ",Symbol()," SELL");
               counter++;
              }
           }
         else counter=0;
        }

      if(bar>0) old=uptrend;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
