#property indicator_chart_window //   
#property indicator_buffers 3
#property indicator_color1 Aqua
#property indicator_color3 Blue
//-- 
extern double Step=0.02; //    
extern double Maximum=0.2; //  

extern bool ExtremumsShift=1; //  : 0 -    ; 1 -     
extern int History=0; // -  ; 0 - 

//--
double   Peak[], //  ZigZag  
         Trough[], //  ZigZag  
         SAR[]; //  Parabolic

//=============================================================
int init()
  {
   SetIndexBuffer(0,Peak); // 
   SetIndexStyle(0,DRAW_ZIGZAG);
   SetIndexLabel(0,"Peak");
   SetIndexEmptyValue(0,0.0);

   SetIndexBuffer(1,Trough); // , .. )))
   SetIndexStyle(1,DRAW_ZIGZAG);
   SetIndexLabel(1,"Trough");
   SetIndexEmptyValue(1,0.0);

   SetIndexBuffer(2,SAR); // 
   SetIndexStyle(2,DRAW_ARROW);
   SetIndexArrow(2,159);
   SetIndexLabel(2,"SAR");
   SetIndexEmptyValue(2,0.0);
     
   return(0);
  }

//=============================================================
int start()
  {
   static int BarsPrev; //  Bars  .
   bool MissBars=Bars-BarsPrev>1; // 1 -   
   bool NewBar=Bars-BarsPrev==1; // 1 -    
   if(MissBars && BarsPrev!=0) BarsPrev=reinit(); //     -  
   
   int limit=Bars-BarsPrev-(BarsPrev==0); BarsPrev=Bars; // - 
   if(History!=0 && limit>History) limit=History-1; // -   

   int counted_bars = IndicatorCounted();
   if(counted_bars < 0)  return(-1);
   if(counted_bars > 0)   counted_bars--;
   limit = Bars - counted_bars;
   if(counted_bars==0) limit-=2+ExtremumsShift*10;
   
   for(int i=limit; i>=0; i--) //      
     {   
      SAR[i]=iSAR(NULL,0,Step,Maximum, i); // 
      double mid[2]; // . 
      mid[0]=(High[i]+Low[i])/2; // .   
      mid[1]=(High[i+1]+Low[i+1])/2; // .  .

      static int j; //           
      static bool dir; //  ; 0 - , 1 - 
      static double h,l; //   
      int shift; //          

      if(i>0) j++; //   ,    
      if(dir) //   
        {
         if(h<High[i]) {h=High[i]; j=NewBar;} //  ;   
         if(SAR[i+1]<=mid[1] && SAR[i]>mid[0]) //   
           {
            shift=i+ExtremumsShift*(j+NewBar); // 
            if (shift>=ArraySize(Peak)) break;
            Peak[shift]=h; // 
            dir=0; //  
            l=Low[i]; j=0; //  ,   
           }
        }
      else //  
        {
         if(l>Low[i]) {l=Low[i]; j=NewBar;} //  ;   
         if(SAR[i+1]>=mid[1] && SAR[i]<mid[0]) //   
           {
            shift=i+ExtremumsShift*(j+NewBar); // 
            if (shift>=ArraySize(Trough)) break;
            Trough[shift]=l; // 
            dir=1; //  
            h=High[i]; j=0; //  ,   
           }
        }
     }

//   if(MissBars) Print("limit: ",limit," Bars:",Bars," IndicatorCounted: ",IndicatorCounted());

   return(0);
  }
//=============================================================

// -  
int reinit()
  {
   ArrayInitialize(Peak,0.0);
   ArrayInitialize(Trough,0.0);
   ArrayInitialize(SAR,0.0);
   return(0);
  }
 