//+---------------------------------------------------------------------+ 
//|                                                        Dots_HTF.mq5 | 
//|                                  Copyright  2015, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+  
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.60"
//----     
#property indicator_chart_window
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
#define INDICATOR_NAME "Dots" //    
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_ARROW
//----     
#property indicator_color1  clrBlue,clrRed
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "Dots"
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;        //  
input uint AlertCount=0;                          //   
input uint SignalBar=1;                           //    , 0- 
input bool Repeat=true;                           //     
input uint Length = 10;                           //  
input uint Filter = 0;                            // ,         
input Applied_price_ IPC=PRICE_CLOSE_;            //  
input int PriceShift=0;                           //      
input int Shift=0;                                //      
//+----------------------------------------------+
//----   ,    
//----      
double IndBuffer[],ColorIndBuffer[];
//----   
string Symbol_,Word;
//----      
int min_rates_total;
//----      
int Dots_Handle;
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    Dots       ");
      return(INIT_FAILED);
     }
//----   
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);
//----    Dots
   Dots_Handle=iCustom(Symbol_,TimeFrame,"Dots",Length,Filter,IPC,PriceShift,0);
   if(Dots_Handle==INVALID_HANDLE)
     {
      Print("      Dots");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   
//PlotIndexSetInteger(0,PLOT_ARROW,108);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----       
   ArraySetAsSeries(IndBuffer,true);
//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorIndBuffer,true);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,INDICATOR_NAME);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Dots_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//----    
   double Dots[1],CLR[1];
   int limit,bar;
   datetime DotsTime[1];
   static uint UpCount,DnCount;
   static uint UpCount_,DnCount_;
   static double LastDots=0.0;
   static uint LastCountBar;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       
//----         
   ArraySetAsSeries(time,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      IndBuffer[bar]=0.0;
      ColorIndBuffer[bar]=EMPTY_VALUE;
      //----       DotsTime
      if(CopyTime(Symbol_,TimeFrame,time[bar],1,DotsTime)<=0) return(RESET);
      //----
      if(time[bar]>=DotsTime[0] && time[bar+1]<DotsTime[0])
        {
         LastCountBar=bar;
         //----      
         if(CopyBuffer(Dots_Handle,0,time[bar],1,Dots)<=0) return(RESET);
         if(CopyBuffer(Dots_Handle,1,time[bar],1,CLR)<=0) return(RESET);
         //----
         IndBuffer[bar]=Dots[0];
         ColorIndBuffer[bar]=CLR[0];
        }
      else if(Repeat)
        {
         IndBuffer[bar]=IndBuffer[bar+1];
         ColorIndBuffer[bar]=ColorIndBuffer[bar+1];
        }
     }
//----     
   if(rates_total!=prev_calculated)
     {
      UpCount=0;
      DnCount=0;
      UpCount_=0;
      DnCount_=0;
     }
//----    
   if(UpCount<AlertCount && ColorIndBuffer[SignalBar]==2)
     {
      UpCount++;
      Alert(Word+":     "+Symbol_);
     }
//----    
   if(DnCount<AlertCount && ColorIndBuffer[SignalBar]==1)
     {
      DnCount++;
      Alert(Word+":     "+Symbol_);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
