//+------------------------------------------------------------------+
//|                                  clusterbox_dayhistogramm_ad.mq4 |
//|                                        Copyright 2015, Scriptong |
//|                                          http://advancetools.net |
//+------------------------------------------------------------------+
#property copyright "Scriptong"
#property link      "http://advancetools.net"
#property description "English: Displays the ticks volume by days in the form histogram of clusters.\nRussian:         ."
#property strict

#property indicator_chart_window
#property indicator_buffers 1

#define MAX_VOLUMES_SHOW      5                                                                    //    ,   
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
struct LevelVolumeColor                                                                            //    ,      .. 
  {                                                                                                // .. 
   color             levelColor;
   int               levelMinVolume;
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
struct TickStruct                                                                                  //       
  {
   datetime          time;
   double            bid;
   double            ask;
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
struct ViewRange                                                                                   //       
  {
   datetime          leftTime;
   datetime          rightTime;
   int               rightIndex;
   int               rangeDuration;
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
struct LevelsData                                                                                  //     ,   ,        
  {
   double            price;
   int               repeatCnt;
   int               bullsCnt;
   int               bearsCnt;
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
enum ENUM_YESNO
  {
   YES,                                                                                           // Yes / 
   NO                                                                                             // No / 
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
enum ENUM_LINEWIDTH                                                                                //   
  {
   LINEWIDTH_NULL,                                                                                 // Most thin /  
   LINEWIDTH_ONE,                                                                                  // Thin / 
   LINEWIDTH_TWO,                                                                                  // Median / 
   LINEWIDTH_THREE,                                                                                // Thick / 
   LINEWIDTH_FOUR                                                                                  // Most thick /  
  };

//   
input int      i_pointsInBox           = 50;                                                       // Points in one cluster /     
input string   i_string1               = "Min volumes and colors / .   ";           // ==============================================
input int      i_minVolumeLevel1       = 1;                                                        // Minimal volume. Level 1 /  .  1
input color    i_colorLevel1           = clrSkyBlue;                                               // Color of level 1 /   1
input int      i_minVolumeLevel2       = 50;                                                       // Minimal volume. Level 2 /  .  2
input color    i_colorLevel2           = clrTurquoise;                                             // Color of level 2 /   2
input int      i_minVolumeLevel3       = 75;                                                       // Minimal volume. Level 3 /  .  3
input color    i_colorLevel3           = clrRoyalBlue;                                             // Color of level 3 /   3
input int      i_minVolumeLevel4       = 100;                                                      // Minimal volume. Level 4 /  .  4
input color    i_colorLevel4           = clrBlue;                                                  // Color of level 4 /   4
input int      i_minVolumeLevel5       = 150;                                                      // Minimal volume. Level 5 /  .  5
input color    i_colorLevel5           = clrMagenta;                                               // Color of level 5 /   5
input string   i_string2               = "Delta of volumes /  ";                      // ==============================================
input ENUM_YESNO i_isShowDelta         = YES;                                                      // Show the delta of volumes? /   ?
input color    i_bullDeltaColor        = clrLime;                                                  // Color of line price growth /    
input color    i_bearDeltaColor        = clrRed;                                                   // Color of line fall in prices /    
input string   i_string3               = " ";                                      // ==============================================
input ENUM_LINEWIDTH i_lineWidth       = LINEWIDTH_THREE;                                          // Histogram thickness /   
input ENUM_YESNO i_point5Digits        = YES;                                                      // Use 5-digits in prices? /  5-  ?
input int      i_indBarsCount=10000;                                                               // Number of bars to display / -  

//    
bool              g_activate;                                                                      //    

int               g_curDayNumber,                                                                  //       
                  g_pointMultiply;                                                                 //   ,     5- 

double            g_point;

datetime          g_curDayStart;                                                                   //   ,     

TickStruct        g_ticks[];                                                                       //    ,                         
LevelVolumeColor  g_volumeLevelsColor[MAX_VOLUMES_SHOW];                                           //   ,  ,  
LevelsData        g_levelsData[];                                                                  //   ,     ,    

#define PREFIX "CLSTRBXDH_"                                                                        //    ,   
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//| Custom indicator initialization function                                                                                                                                                          |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
int OnInit()
  {
   g_activate=false;                                                                             //   

   if(!IsTuningParametersCorrect()) //      -   
      return INIT_FAILED;

   if(!IsLoadTempTicks()) //    ,         
      return INIT_FAILED;

   CreateVolumeColorsArray();                                                                      //         

   if(Period()>=PERIOD_D1)
      Print(WindowExpertName(),":       D1  .");
   else
      g_activate=true;                                                                           //   

   return INIT_SUCCEEDED;
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                          |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool IsTuningParametersCorrect()
  {
   string name=WindowExpertName();

   int period= Period();
   if(period == 0)
     {
      Alert(name,":    -  0 .  .");
      return (false);
     }

   g_point=Point;
   if(g_point==0)
     {
      Alert(name,":    -    .  .");
      return (false);
     }

   g_pointMultiply=1;
   if(i_point5Digits==YES)
      g_pointMultiply=10;

   if(i_pointsInBox<3*g_pointMultiply && i_isShowDelta==YES)
     {
      Alert(name,":         ",3*g_pointMultiply,".  .");
      return (false);
     }

   if(i_pointsInBox<1)
     {
      Alert(name,":         1.  .");
      return (false);
     }

   g_curDayStart=0;

   return (true);
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|    ,                                                                                                                         |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool IsLoadTempTicks()
  {
//    
   int hTicksFile=FileOpen(Symbol()+"temp.tks",FILE_BIN|FILE_READ|FILE_SHARE_READ|FILE_SHARE_WRITE);
   if(hTicksFile<1)
      return true;

//     g_ticks
   int recSize=(int)(FileSize(hTicksFile)/sizeof(TickStruct));
   if(ArrayResize(g_ticks,recSize,1000)<0)
     {
      Alert(WindowExpertName(),":           .  .");
      FileClose(hTicksFile);
      return false;
     }

//  
   int i=0;
   while(i<recSize)
     {
      if(FileReadStruct(hTicksFile,g_ticks[i])==0)
        {
         Alert(WindowExpertName(),":      .  .");
         return false;
        }
      i++;
     }

   FileClose(hTicksFile);
   return true;
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                  |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void CreateVolumeColorsArray()
  {
   g_volumeLevelsColor[0].levelMinVolume = i_minVolumeLevel1;
   g_volumeLevelsColor[1].levelMinVolume = i_minVolumeLevel2;
   g_volumeLevelsColor[2].levelMinVolume = i_minVolumeLevel3;
   g_volumeLevelsColor[3].levelMinVolume = i_minVolumeLevel4;
   g_volumeLevelsColor[4].levelMinVolume = i_minVolumeLevel5;

   g_volumeLevelsColor[0].levelColor = i_colorLevel1;
   g_volumeLevelsColor[1].levelColor = i_colorLevel2;
   g_volumeLevelsColor[2].levelColor = i_colorLevel3;
   g_volumeLevelsColor[3].levelColor = i_colorLevel4;
   g_volumeLevelsColor[4].levelColor = i_colorLevel5;
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//| Custom indicator deinitialization function                                                                                                                                                        |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   if(!IsSavedFile()) //         ,     
      SaveTempTicks();                                                                             //    ,         
   DeleteAllObjects();
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                   |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool IsSavedFile()
  {
//      
   int lastTickIndex=ArraySize(g_ticks)-1;
   if(lastTickIndex<0) //      .    
      return true;

//    
   int hTicksFile=FileOpen(Symbol()+"temp.tks",FILE_BIN|FILE_READ|FILE_SHARE_READ|FILE_SHARE_WRITE);
   if(hTicksFile<1)
      return false;

//      
   if(!FileSeek(hTicksFile,-sizeof(TickStruct),SEEK_END))
     {
      FileClose(hTicksFile);
      return false;
     }

//      
   TickStruct tick;
   uint readBytes=FileReadStruct(hTicksFile,tick);
   FileClose(hTicksFile);
   if(readBytes==0)
      return false;

//   ,   ,     
   return tick.time >= g_ticks[lastTickIndex].time;                                                // /         /..
                                                                                                   // .. . ,   ,     
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|    ,                                                                                                                              |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void SaveTempTicks()
  {
//    
   int hTicksFile=FileOpen(Symbol()+"temp.tks",FILE_BIN|FILE_READ|FILE_WRITE|FILE_SHARE_READ|FILE_SHARE_WRITE);
   if(hTicksFile<1)
      return;

//  
   int total=ArraySize(g_ticks),i=0;
   while(i<total)
     {
      if(FileWriteStruct(hTicksFile,g_ticks[i])==0)
        {
         Print("     ...");
         return;
        }
      i++;
     }

   FileClose(hTicksFile);
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|   ,                                                                                                                                                        |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void DeleteAllObjects()
  {
   for(int i=ObjectsTotal()-1; i>=0; i--)
      if(StringSubstr(ObjectName(i),0,StringLen(PREFIX))==PREFIX)
         ObjectDelete(ObjectName(i));
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                                          |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void ShowTrendLine(datetime time1,double price1,datetime time2,double price2,string toolTip,color clr)
  {
   string name=PREFIX+"LINE_"+IntegerToString((int)MathRound(price1/g_point))+IntegerToString(time1);

   if(ObjectFind(0,name)<0)
     {
      ObjectCreate(0,name,OBJ_TREND,0,time1,price1,time2,price2);
      ObjectSetInteger(0,name,OBJPROP_COLOR,clr);
      ObjectSetInteger(0,name,OBJPROP_BACK,true);
      ObjectSetInteger(0,name,OBJPROP_WIDTH,(int)i_lineWidth);
      ObjectSetInteger(0,name,OBJPROP_RAY,false);
      ObjectSetInteger(0,name,OBJPROP_HIDDEN,true);
      ObjectSetInteger(0,name,OBJPROP_SELECTABLE,false);
      ObjectSetString(0,name,OBJPROP_TOOLTIP,toolTip);
      return;
     }

   ObjectMove(0,name,0,time1,price1);
   ObjectMove(0,name,1,time2,price2);
   ObjectSetInteger(0,name,OBJPROP_COLOR,clr);
   ObjectSetString(0,name,OBJPROP_TOOLTIP,toolTip);
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|   ,                                                                                                                                 |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
int GetRecalcIndex(int &total,const int ratesTotal,const int prevCalculated)
  {
//    ,       
   total=ratesTotal-1;

//          ?
   if(i_indBarsCount>0 && i_indBarsCount<total)
      total=MathMin(i_indBarsCount,total);

//       , . .          ,     ,       
   if(prevCalculated<ratesTotal-1)
     {
      DeleteAllObjects();
      return (total);
     }

//   .            ,    
   return (MathMin(ratesTotal - prevCalculated, total));
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|   ?                                                                                                                                                                                   |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool IsValuesEquals(double first,double second)
  {
   return (MathAbs(first - second) < Point / 10);
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|       g_ticks                                                                                                                                                             |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool IsUpdateTicksArray(TickStruct &tick)
  {
   int total=ArraySize(g_ticks);
   if(ArrayResize(g_ticks,total+1,100)<0)
     {
      Alert(WindowExpertName(),":          .");
      return false;
     }

   g_ticks[total]=tick;
   return true;
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                             |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void CheckForNewDayOpen(TickStruct &curTick)
  {
   int curTickDayNumber=TimeDayOfYear(curTick.time);
   if(g_curDayNumber==curTickDayNumber) //     
      return;

//     
   ShowHistogramm();
   string dayOpen= TimeToString(curTick.time,TIME_DATE);
   g_curDayStart = StringToTime(dayOpen);
   g_curDayNumber= TimeDayOfYear(g_curDayStart);

//   
   ArrayResize(g_levelsData,0,1000);
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|       g_levelsData                                                                                                                                                        |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool IsSaveTickData(TickStruct &curTick,TickStruct &prevTick)
  {
//     
   CheckForNewDayOpen(curTick);

//     
   double clusterPrice=CastPriceToCluster(curTick.bid);

//       g_levelsData
   int i=0;
   int total=ArraySize(g_levelsData);
   for(; i<total; i++)
      if(IsValuesEquals(g_levelsData[i].price,clusterPrice))
         break;

//   
   if(i<total)
     {
      g_levelsData[i].repeatCnt++;
      SaveDeltaData(i,curTick.bid,prevTick.bid);
      return true;
     }

//     -  
   if(ArrayResize(g_levelsData,total+1,1000)!=total+1)
     {
      Alert(WindowExpertName(),":       .");
      return false;
     }

   g_levelsData[total].price=clusterPrice;
   g_levelsData[total].repeatCnt=1;
   g_levelsData[i].bullsCnt = 0;
   g_levelsData[i].bearsCnt = 0;
   SaveDeltaData(i,curTick.bid,prevTick.bid);
   return true;
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
double CastPriceToCluster(double price)
  {
   int priceInPoints=(int)MathRound(price/Point);
   int clusterPrice =(int)MathRound(priceInPoints/1.0/i_pointsInBox);
   return NormalizeDouble(clusterPrice * Point * i_pointsInBox, Digits);
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                  |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void SaveDeltaData(int index,double curBid,double prevBid)
  {
   if(curBid>prevBid)
      g_levelsData[index].bullsCnt++;
   if(curBid<prevBid)
      g_levelsData[index].bearsCnt++;
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                                            |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool IsReadTimeAndBidAskOfTick(int hTicksFile,TickStruct &tick)
  {
   if(FileIsEnding(hTicksFile))
      return false;

   uint bytesCnt=FileReadStruct(hTicksFile,tick);
   return bytesCnt == sizeof(TickStruct);
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|  ,                                                                                                                         |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool IsReadTicksFromFile(datetime &lastTime,int total)
  {
//   
   ArrayResize(g_levelsData,0);

//    
   int hTicksFile=FileOpen(Symbol()+".tks",FILE_BIN|FILE_READ|FILE_SHARE_READ|FILE_SHARE_WRITE);
   if(hTicksFile<1)
      return true;

//  
   TickStruct tick={0,0,0};
   TickStruct prevTick;
   bool result=true;
   datetime viewStartTime=Time[total];
   while(!IsStopped())
     {
      prevTick=tick;
      bool fileClose=!IsReadTimeAndBidAskOfTick(hTicksFile,tick);
      if(fileClose || tick.time==0)
         break;

      if(tick.time<viewStartTime)
         continue;

      if(!IsSaveTickData(tick,prevTick))
        {
         result=false;
         break;
        }
     }

   FileClose(hTicksFile);
   lastTime = tick.time;                                                                           //    ,       ..
                                                                                                   // .. 
   return result;
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|       ,    ,     ,                                                                    |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool ReadTicksFromBuffer(datetime lastTime,int total)
  {
// ,             
   lastTime=(datetime)MathMax(lastTime,Time[total]);

//    g_ticks,      
   int totalTicks=ArraySize(g_ticks);
   int i=0;
   while(i<totalTicks && lastTime>=g_ticks[i].time)
      i++;

//  
   datetime timeTotal=Time[0]+PeriodSeconds();
   TickStruct prevTick={0,0,0};
   if(i>0)
      prevTick=g_ticks[i-1];
   while(i<totalTicks && g_ticks[i].time<timeTotal)
     {
      if(!IsSaveTickData(g_ticks[i],prevTick))
         return false;

      prevTick=g_ticks[i];
      i++;
     }

   return true;
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                             |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
int GetMaxTickVolume()
  {
   int max=0;
   int total = ArraySize(g_levelsData);
   for(int i = 0; i < total; i++)
      if(g_levelsData[i].repeatCnt>max)
         max=g_levelsData[i].repeatCnt;

   return max;
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                                             |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void ShowHistogramm()
  {
   int maxVolume= GetMaxTickVolume();
   if(maxVolume == 0)
      return;

   int total=ArraySize(g_levelsData);
   int curDayStartBarIndex=0,dayDuration=0;
   datetime curDayLastBarTime=GetCurDayLastBarTime(curDayStartBarIndex,dayDuration);
   for(int i=0; i<total; i++)
     {
      int volumeLevel=GetVolumeLevel(g_levelsData[i].repeatCnt);
      if(volumeLevel<0)
         continue;

      //   
      string price=": "+DoubleToString(g_levelsData[i].price,Digits);
      datetime histRightTime=GetHistRightTime(curDayLastBarTime,curDayStartBarIndex,dayDuration,g_levelsData[i].repeatCnt,maxVolume);
      ShowTrendLine(g_curDayStart,g_levelsData[i].price,histRightTime,g_levelsData[i].price,price+". : "+IntegerToString(g_levelsData[i].repeatCnt),
                    g_volumeLevelsColor[volumeLevel].levelColor);

      //      
      if(i_isShowDelta==NO)
         continue;
      histRightTime=GetHistRightTime(curDayLastBarTime,curDayStartBarIndex,dayDuration,g_levelsData[i].bearsCnt,maxVolume);
      ShowTrendLine(g_curDayStart,g_levelsData[i].price+g_pointMultiply*Point,histRightTime,g_levelsData[i].price+g_pointMultiply*Point,
                    price+".  : "+IntegerToString(g_levelsData[i].bearsCnt),i_bearDeltaColor);
      histRightTime=GetHistRightTime(curDayLastBarTime,curDayStartBarIndex,dayDuration,g_levelsData[i].bullsCnt,maxVolume);
      ShowTrendLine(g_curDayStart,g_levelsData[i].price+2*g_pointMultiply*Point,histRightTime,g_levelsData[i].price+2*g_pointMultiply*Point,
                    price+".  : "+IntegerToString(g_levelsData[i].bullsCnt),i_bullDeltaColor);
     }
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|        (   g_curDayOpen),                                                            |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
datetime GetCurDayLastBarTime(int &curDayStartBarIndex,int &dayDuration)
  {
//    
   curDayStartBarIndex=iBarShift(NULL,0,g_curDayStart);
   while(Time[curDayStartBarIndex]<g_curDayStart && curDayStartBarIndex>0)
      curDayStartBarIndex--;

//    
   datetime absoluteDayEnd=g_curDayStart+PERIOD_D1*60-1;
   int curDayEndBarIndex=iBarShift(NULL,0,absoluteDayEnd);
   while(Time[curDayEndBarIndex]>absoluteDayEnd && curDayEndBarIndex<Bars)
      curDayEndBarIndex++;

//         
   dayDuration=curDayStartBarIndex-curDayEndBarIndex;
   return Time[curDayEndBarIndex] + PeriodSeconds() - 1;
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//| ,                                                                                                                    |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
int GetVolumeLevel(int ticksVolume)
  {
   for(int i=0; i<MAX_VOLUMES_SHOW; i++)
      if(g_volumeLevelsColor[i].levelMinVolume>ticksVolume)
         return i - 1;

   return MAX_VOLUMES_SHOW - 1;
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|   ,                                                                                                      |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
datetime GetHistRightTime(datetime curDayLastBarTime,int curDayStartBarIndex,int dayDuration,int tickVolume,int maxVolume)
  {
   int barsIndex=curDayStartBarIndex -(int)(dayDuration*tickVolume/1.0/maxVolume);
   if(barsIndex<0 || barsIndex>=Bars)
      return curDayLastBarTime;

   return Time[barsIndex];
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                      |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void ShowNewData(int total)
  {
//    
   datetime lastTime=0;
   if(!IsReadTicksFromFile(lastTime,total))
     {
      g_activate=false;
      return;
     }

//     
   if(!ReadTicksFromBuffer(lastTime,total))
     {
      g_activate=false;
      return;
     }

   ShowHistogramm();
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                                        |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void UpdateData()
  {
   TickStruct tick;
   tick.time= TimeCurrent();
   tick.ask = Ask;
   tick.bid = Bid;

//          
   if(!IsUpdateTicksArray(tick))
     {
      g_activate=false;
      return;
     }

//     
   TickStruct prevTick={0,0,0};
   int lastTickIndex=ArraySize(g_ticks)-1;
   if(lastTickIndex>0)
      prevTick=g_ticks[lastTickIndex-1];
   if(!IsSaveTickData(tick,prevTick))
     {
      g_activate=false;
      return;
     }

   ShowHistogramm();
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                                        |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void ShowIndicatorData(int limit,int total)
  {
   if(limit>0)
     {
      ShowNewData(total);
      return;
     }

   UpdateData();
  }
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//| Custom indicator iteration function                                                                                                                                                               |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   if(!g_activate) //       ,     
      return rates_total;

   int total;
   int limit=GetRecalcIndex(total,rates_total,prev_calculated);                                //     ?

   ShowIndicatorData(limit,total);                                                                //   
   WindowRedraw();

   return rates_total;
  }
//+------------------------------------------------------------------+
