//+------------------------------------------------------------------+ 
//|                                     Bollinger_Squeeze_v9_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----   
#property version   "1.60"
//----     
#property indicator_separate_window
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----      
#property indicator_color1 clrRed,clrOrchid,clrGray,clrDodgerBlue,clrLime
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----   
#property indicator_label1 "Bollinger_Squeeze_v9 HISTOGRAM"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Mode // 
  {
   ENAME_STOCHASTIC = 1,     //stochastic
   ENAME_CCI,                //cci
   ENAME_RSI,                //rsi
   ENAME_MACD,               //macd
   ENAME_MOMENTUM            //momentum
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4; //  
input Mode triggerType=ENAME_MACD;
input uint stochPeriod_trigger1=14;
input uint cciPeriod_trigger2=50;
input uint rsiPeriod_trigger3=10;
input uint macd_fastEMA_trigger4=5;
input uint macd_slowEMA_trigger4=13;
input uint macd_macdEMA_trigger4=1;
input uint momentumPeriod_trigger5=14;
input bool ReDraw=true;                    //      
//+----------------------------------------------+
//----      
int min_rates_total;
//----      
int Ind_Handle;
//----   ,    
//----      
double IndBuffer[],ColorIndBuffer[];
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {
//----
   return(StringSubstr(EnumToString(timeframe),7,-1));
  }
//+------------------------------------------------------------------+    
//| Bollinger_Squeeze_v9 indicator initialization function           | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   min_rates_total=3;
//----     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    Bollinger_Squeeze_v9       ");
      return(INIT_FAILED);
     }
//----    Bollinger_Squeeze_v9
   Ind_Handle=iCustom(Symbol(),TimeFrame,"Bollinger_Squeeze_v9",triggerType,stochPeriod_trigger1,cciPeriod_trigger2,rsiPeriod_trigger3,macd_fastEMA_trigger4,
                      macd_slowEMA_trigger4,macd_macdEMA_trigger4,momentumPeriod_trigger5);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      Bollinger_Squeeze_v9");
      return(INIT_FAILED);
     }
//----     
   switch(triggerType)
     {
      case 1:
         //----        
         IndicatorSetInteger(INDICATOR_LEVELS,2);
         //----       
         IndicatorSetDouble(INDICATOR_LEVELVALUE,0,+30);
         IndicatorSetDouble(INDICATOR_LEVELVALUE,1,-30);
         //----             
         IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,clrMagenta);
         IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,clrMagenta);
         //----       -  
         IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,STYLE_DASHDOTDOT);
         IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,STYLE_DASHDOTDOT);
         break;
      case 2:
         //----        
         IndicatorSetInteger(INDICATOR_LEVELS,4);
         //----       
         IndicatorSetDouble(INDICATOR_LEVELVALUE,0,+200);
         IndicatorSetDouble(INDICATOR_LEVELVALUE,1,+100);
         IndicatorSetDouble(INDICATOR_LEVELVALUE,2,-100);
         IndicatorSetDouble(INDICATOR_LEVELVALUE,3,-200);
         //----             
         IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,clrMagenta);
         IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,clrMagenta);
         IndicatorSetInteger(INDICATOR_LEVELCOLOR,2,clrMagenta);
         IndicatorSetInteger(INDICATOR_LEVELCOLOR,3,clrMagenta);
         //----       -  
         IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,STYLE_DASHDOTDOT);
         IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,STYLE_DASHDOTDOT);
         IndicatorSetInteger(INDICATOR_LEVELSTYLE,2,STYLE_DASHDOTDOT);
         IndicatorSetInteger(INDICATOR_LEVELSTYLE,3,STYLE_DASHDOTDOT);
         break;
      case 3:
         //----        
         IndicatorSetInteger(INDICATOR_LEVELS,2);
         //----       
         IndicatorSetDouble(INDICATOR_LEVELVALUE,0,+20);
         IndicatorSetDouble(INDICATOR_LEVELVALUE,1,-20);
         //----             
         IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,clrMagenta);
         IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,clrMagenta);
         //----       -  
         IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,STYLE_DASHDOTDOT);
         IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,STYLE_DASHDOTDOT);
         break;
      case 4:
         //----        
         IndicatorSetInteger(INDICATOR_LEVELS,0);
         break;
      case 5:
         //----        
         IndicatorSetInteger(INDICATOR_LEVELS,2);
         //----       
         IndicatorSetDouble(INDICATOR_LEVELVALUE,0,+1);
         IndicatorSetDouble(INDICATOR_LEVELVALUE,1,-1);
         //----             
         IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,clrMagenta);
         IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,clrMagenta);
         //----       -  
         IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,STYLE_DASHDOTDOT);
         IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,STYLE_DASHDOTDOT);
         break;
     }
//----    IndBuffer   
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(IndBuffer,true);
//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorIndBuffer,true);
//---           
   switch(triggerType)
     {
      case 1: IndicatorSetString(INDICATOR_SHORTNAME,"Bollinger Squeeze with Stochastic ("+string(stochPeriod_trigger1)+",3,3)"); break;
      case 2: IndicatorSetString(INDICATOR_SHORTNAME,"Bollinger Squeeze with CCI ("+string(cciPeriod_trigger2)+",CLOSE)"); break;
      case 3: IndicatorSetString(INDICATOR_SHORTNAME,"Bollinger Squeeze with RSI ("+string(rsiPeriod_trigger3)+",CLOSE)"); break;
      case 4: IndicatorSetString(INDICATOR_SHORTNAME,"Bollinger Squeeze with MACD (5,13,1,CLOSE)"); break;
      case 5: IndicatorSetString(INDICATOR_SHORTNAME,"Bollinger Squeeze with Momentum ("+string(momentumPeriod_trigger5)+",CLOSE)"); break;
     }
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Bollinger_Squeeze_v9 iteration function                          | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//----   
   int limit,bar;
//----       
   double Ind[1],Col[1];
   datetime IndTime[1];
   static uint LastCountBar;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       
//----         
   ArraySetAsSeries(time,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      IndBuffer[bar]=EMPTY_VALUE;
      ColorIndBuffer[bar]=0;
      //----      
      if(CopyTime(Symbol(),TimeFrame,time[bar],1,IndTime)<=0) return(RESET);
      //----
      if(time[bar]>=IndTime[0] && time[bar+1]<IndTime[0])
        {
         LastCountBar=bar;
         //----      
         if(CopyBuffer(Ind_Handle,0,time[bar],1,Ind)<=0) return(RESET);
         if(CopyBuffer(Ind_Handle,1,time[bar],1,Col)<=0) return(RESET);
         //----      
         IndBuffer[bar]=Ind[0];
         ColorIndBuffer[bar]=Col[0];
        }
      if(ReDraw)
        {
         if(IndBuffer[bar+1]!=EMPTY_VALUE && IndBuffer[bar]==EMPTY_VALUE)
           {
            IndBuffer[bar]=IndBuffer[bar+1];
            ColorIndBuffer[bar]=ColorIndBuffer[bar+1];
           }
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
