//+------------------------------------------------------------------+ 
//|                                               Aggressiveness.mq5 | 
//|                   Copyright  2009, Trofimov Evgeniy Vitalyevich | 
//|                                     http://TrofimovVBA.narod.ru/ | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2009, Trofimov Evgeniy Vitalyevich"
#property link      "http://TrofimovVBA.narod.ru/"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----        BlueViolet 
#property indicator_color1 clrBlueViolet
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "Aggressiveness"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint MyPeriod=22;
input double Lot=0; // Lot (0 -  , >0 -   )
input int Shift=0;  //      
//+-----------------------------------+
//----  
double IndBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+    
//| Aggressiveness indicator initialization function                 | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=int(MyPeriod+1);
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   string shortname;
   if(!Lot) shortname="Aggressiveness("+string(MyPeriod)+"), (pips) = ";
   else shortname="Aggressiveness("+string(MyPeriod)+"), ("+AccountInfoString(ACCOUNT_CURRENCY)+""+DoubleToString(Lot,2)+") = ";
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+  
//| Aggressiveness iteration function                                | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total)return(0);
//----   
   int first,bar;
//----       
   double Sum;
//----
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total; //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total; bar++)
     {
      Sum=0;
      for(int x=0; x<int(MyPeriod); x++)
        {
         int barx=bar-x;
         if(close[barx]>open[barx]) Sum+=close[barx]-close[barx-1]; // 
         else Sum+=close[barx-1]-close[barx]; // 
        }
      //----
      IndBuffer[bar]=Sum/(_Point*MyPeriod);
      //----
      if(Lot)
        {
         double TICKVALUE=SymbolInfoDouble(Symbol(),SYMBOL_TRADE_TICK_VALUE);
         if(!TICKVALUE) return(prev_calculated);
         IndBuffer[bar]*=TICKVALUE*Lot;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
