//+---------------------------------------------------------------------+
//|                                                       BWImp-T01.mq5 | 
//|                             Copyright  2006, HomeSoft-Tartan Corp. | 
//|                        spiky@transkeino.ru - http:\\www.fxexpert.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2006, HomeSoft-Tartan Corp."
#property link      "spiky@transkeino.ru - http:\\www.fxexpert.ru"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       DodgerBlue 
#property indicator_color1 clrDodgerBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "BWImp-T01"
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint Period1=96; //  1
input uint Period2=3;  //  2
input Smooth_Method XMA_Method=MODE_T3; //  
input uint XLength=8; //                      
input int XPhase=70;  //  
                      //  JJMA    -100 ... +100,     ;
                      //  VIDIA   CMO,  AMA    
input int Shift=0;    //      
//----   ,    
//----      
double IndBuffer[];
double Point10;
//----      
int min_rates_1,min_rates_total;
//----   
int Count[];
double impr[],impb[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
   int numb,Max1,Max2;
   static int count=1;
   Max2=Size;
   Max1=Max2-1;
   count--;
   if(count<0) count=Max1;
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
  }
//+------------------------------------------------------------------+
//|                          |
//+------------------------------------------------------------------+   
double Get_dPrice(const double  &Price1[],const double  &Price2[],int index)
  {
   return(Price1[index]-Price2[index]);
  }
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_1=int(Period1+Period2);
   min_rates_total=min_rates_1+XMA1.GetStartBars(XMA_Method,XLength,XPhase);
   Point10=_Point/10;
//----       
   XMA1.XMALengthCheck("XLength",XLength);
   XMA1.XMAPhaseCheck("XPhase",XPhase,XMA_Method);
//----       
   ArrayResize(Count,Period2);
   ArrayResize(impr,Period2);
   ArrayResize(impb,Period2);
   ArrayInitialize(Count,0);
   ArrayInitialize(impr,0.0);
   ArrayInitialize(impb,0.0);
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"BWImp-T01(",XLength,", ",Smooth1,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double imppr,imppb,sipr,sipb,sum;
//----        
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=int(Period1); //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      imppr=0;
      imppb=0;
      for(int kkk=0; kkk<int(Period1); kkk++)
        {
         double diff=Get_dPrice(close,open,bar-kkk);
         if(diff>0) imppr+=diff;
         if(diff<0) imppb+=diff;
        }
      imppr=MathRound(imppr/_Point);
      imppb=MathRound(imppb/_Point);
      if(!imppr) imppr=Point10;
      if(!imppb) imppb=Point10;
      impr[Count[0]]=imppr;
      impb[Count[0]]=imppb;
      sipr=0;
      sipb=0;
      for(int kkk=0; kkk<int(Period2); kkk++)
        {
         sipr+=impr[kkk];
         sipb+=impb[kkk];
        }
      sipr=MathRound((sipr/Period2));
      sipb=MathRound((sipb/Period2));
      sum=sipr+sipb;
      IndBuffer[bar]=XMA1.XMASeries(min_rates_1,prev_calculated,rates_total,XMA_Method,XPhase,XLength,sum,bar,false);
      if(bar<rates_total-1) Recount_ArrayZeroPos(Count,Period2);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
