//+------------------------------------------------------------------+
//|                                              TrendlessAGSign.mq5 |
//|                                       Copyright  2012, Barmaley | 
//|                                                                  | 
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2012, Barmaley"
//---    
#property link ""
#property description "   ,      "
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---    
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---        DeepPink 
#property indicator_color1  clrDeepPink
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "TrendlessAGSign Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        BlueViolet 
#property indicator_color2  clrBlueViolet
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "TrendlessAGSign Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint MAPeriod=7;                          //      
input  ENUM_MA_METHOD   MAType=MODE_EMA;        //       
input ENUM_APPLIED_PRICE   MAPrice=PRICE_CLOSE; //       
input uint PointsCount=600;                     //     . -    
input uint In100=90;                            //  %       +-100%
input int  Shift=0;                             //      
//+----------------------------------------------+
//---   ,   
//---      
double SellBuffer[];
double BuyBuffer[];
//---   
int Count[],Start;
double Value[],Sort[];
//---      
int min_rates_total;
int ATR_Handle,MA_Handle;
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//---
   int numb,Max1,Max2;
   static int count=1;
//---
   Max2=Size;
   Max1=Max2-1;
//---
   count--;
   if(count<0) count=Max1;
//---
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//---
  }
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//---     
   min_rates_total=int(PointsCount+MAPeriod);
   int ATR_Period=10;
   min_rates_total=int(MathMax(min_rates_total,ATR_Period));
   Start=int(PointsCount*In100/100);
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---    iMA
   MA_Handle=iMA(NULL,0,MAPeriod,0,MAType,MAPrice);
   if(MA_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }
//---       
   ArrayResize(Count,PointsCount);
   ArrayResize(Value,PointsCount);
   ArrayResize(Sort,PointsCount);
//---
   ArrayInitialize(Count,0);
   ArrayInitialize(Value,0.0);
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,171);
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---       
   ArraySetAsSeries(SellBuffer,true);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,171);
//---    1  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//---       
   ArraySetAsSeries(BuyBuffer,true);
//---      
   string shortname="TrendlessAGSign";
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(MA_Handle)<rates_total
      || BarsCalculated(ATR_Handle)<rates_total
      || rates_total<min_rates_total) return(RESET);
//---  
   int to_copy,limit;
//---       
   double TrendlessAG0,Res0,ATR[],Ma[];
   static double TrendlessAG1,Res1;
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      TrendlessAG1=0.0;
      Res1=0.0;
     }
   else limit=rates_total-prev_calculated;  //       
   to_copy=limit+1;
//---      
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
   if(CopyBuffer(MA_Handle,0,0,to_copy,Ma)<=0) return(RESET);
//---         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(Ma,true);
//---
   TrendlessAG0=TrendlessAG1;
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      //---
      Res0=close[bar]-Ma[bar];
      Value[Count[0]]=MathAbs(Res0);
      if(bar>0) Recount_ArrayZeroPos(Count,PointsCount);
      if(bar>rates_total-min_rates_total-1) continue;
      ArrayCopy(Sort,Value,0,0,WHOLE_ARRAY);
      ArraySort(Sort);
      double level_100=Sort[Start];
      if(level_100) Res0*=100/(level_100);
      else Res0=EMPTY_VALUE;
      //---
      if(Res0>0.0 && Res1<=0.0) BuyBuffer[bar]=low[bar]-ATR[0]*3/8;
      if(Res0<0.0 && Res1>=0.0) SellBuffer[bar]=high[bar]+ATR[0]*3/8;
      //---
      if(bar)
        {
         TrendlessAG1=TrendlessAG0;
         Res1=Res0;
        }
     }
//---    
   return(rates_total);
  }
//+------------------------------------------------------------------+
