//+------------------------------------------------------------------+
//|                                                  TrendlessAG.mq5 |
//|                                       Copyright  2012, Barmaley | 
//|                                                                  | 
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2012, Barmaley"
//---    
#property link ""
#property description "      ,"
#property description "     \"    \""
//---   
#property version   "1.01"
//---     
#property indicator_separate_window
//---        
#property indicator_buffers 1
//---    
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---         
#property indicator_color1  clrRed
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  1
#property indicator_width1  1
//---    
#property indicator_label1  "TrendlessAG"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 +100
#property indicator_level2 +80
#property indicator_level3 +60
#property indicator_level4  0
#property indicator_level5 -60
#property indicator_level6 -80
#property indicator_level7 -100
#property indicator_levelcolor clrBlue
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint MAPeriod=7;                          //      
input  ENUM_MA_METHOD   MAType=MODE_EMA;        //       
input ENUM_APPLIED_PRICE   MAPrice=PRICE_CLOSE; //       
input uint PointsCount=600;                     //     . -    
input uint In100=90;                            //  %       +-100%
input int  Shift=0;                             //       
//+----------------------------------------------+
//---   ,   
//---      
double IndBuffer[];
//---   
int Count[],Start;
double Value[],Sort[];
//---      
int min_rates_total;
//---      
int MA_Handle;
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//---
   int numb,Max1,Max2;
   static int count=1;

   Max2=Size;
   Max1=Max2-1;

   count--;
   if(count<0) count=Max1;

   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//---
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   min_rates_total=int(PointsCount+MAPeriod);
   Start=int(PointsCount*In100/100);
//---    iMA
   MA_Handle=iMA(NULL,0,MAPeriod,0,MAType,MAPrice);
   if(MA_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }
//---       
   ArrayResize(Count,PointsCount);
   ArrayResize(Value,PointsCount);
   ArrayResize(Sort,PointsCount);
//---
   ArrayInitialize(Count,0);
   ArrayInitialize(Value,0.0);   
//---    PVIBuffer   
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(IndBuffer,true);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"TrendlessAG");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(MA_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//---   
   int to_copy,limit,bar;
   double Ma[];
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=int(rates_total-MAPeriod-1);   //    
   else limit=rates_total-prev_calculated; //      
//---         
   ArraySetAsSeries(Ma,true);
   ArraySetAsSeries(close,true);
   to_copy=limit+1;
//---      
   if(CopyBuffer(MA_Handle,0,0,to_copy,Ma)<=0) return(RESET);
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {     
      double Res=close[bar]-Ma[bar];
      Value[Count[0]]=MathAbs(Res);     
      if(bar>0) Recount_ArrayZeroPos(Count,PointsCount);      
      if(bar>rates_total-min_rates_total-1) continue;      
      ArrayCopy(Sort,Value,0,0,WHOLE_ARRAY);
      ArraySort(Sort);      
      double level_100=Sort[Start];
      if(level_100) Res*=100/(level_100);
      else Res=EMPTY_VALUE;   
      IndBuffer[bar]=Res;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
