#property copyright "ExcStrategy"
#property link      "http://www.ExcStrategy.ru"
#property version   "1.4"
#property description "   !"
#property strict
//----
#property indicator_chart_window
#property indicator_buffers 5
#property indicator_color2 Tomato
#property indicator_color1 DeepSkyBlue
#property indicator_color4 DeepSkyBlue
#property indicator_color3 Tomato
#property indicator_color5 Black
#property indicator_width1  3
#property indicator_width2  3
#property indicator_width3  2
#property indicator_width4  2
//----
extern int Period_1 = 2;
extern int Period_2 = 2;
extern bool DrawArrow = true;
//----
bool nexttrend;
double minh, maxl, up[], down[], trend[], atrlo[], atrhi[];
//----
int init () 
{
    SetIndexBuffer (0, up);
    SetIndexStyle (0, DRAW_LINE);
    SetIndexBuffer (1, down);
    SetIndexStyle (1, DRAW_LINE);
    SetIndexBuffer (2, atrlo);
    SetIndexStyle (2, DRAW_ARROW);
    SetIndexArrow(2, 234);
    SetIndexBuffer (3, atrhi);
    SetIndexStyle (3, DRAW_ARROW);
    SetIndexArrow(3, 233);
    SetIndexBuffer (4, trend);
    //----
    SetIndexEmptyValue (0, 0.0);
    SetIndexEmptyValue (1, 0.0);
    //----
    IndicatorShortName("Ozymandias_lite");
    SetIndexLabel(0, NULL);
    SetIndexLabel(1, NULL);
    SetIndexLabel(2, "Dn");
    SetIndexLabel(3, "Up");
    SetIndexLabel(4, "Trend");
    //----
    nexttrend = 0;
    minh = High[Bars - 1];
    maxl = Low[Bars - 1];
    //----
    return (0);
}
//----
int start ()
{
    double atr, ll, hh, lma, hma;
    int workbar = 1;
    int c = IndicatorCounted ();
    //----
    if(c < 0) 
    {
        return (- 1);
    }
    //----
    for (int i = Bars - 1 - c; i >= workbar; i --) 
    {
        if(Bars - i > 5 + MathMax(Period_1, Period_2))
        {
            //--------------------------------------------------------------------------------------------
            //      http://tradelikeapro.ru/indikator-ozymandias/
            //--------------------------------------------------------------------------------------------
            ll = iLow(Symbol (), Period (), iLowest (Symbol (), Period (), MODE_LOW, Period_1, i));
            hh = iHigh(Symbol (), Period (), iHighest (Symbol (), Period (), MODE_HIGH, Period_1, i));
            lma = iMA(NULL, 0, Period_2, 0, MODE_SMA, PRICE_LOW, i);
            hma = iMA(NULL, 0, Period_2, 0, MODE_SMA, PRICE_HIGH, i);
            trend[i] = trend[i + 1];
            atr = iATR(Symbol (), 0, 100, i) / 2;
            //----
            if(nexttrend == 1) 
            {
                maxl = MathMax (ll, maxl);
                if(hma < maxl && Close[i] < Low[i + 1]) 
                {
                    trend[i] = 1;
                    nexttrend = 0;
                    minh = hh;
                }
            }
            //----
            if(nexttrend == 0)
            {
                minh = MathMin (hh, minh);
                if(lma > minh && Close[i] > High[i + 1]) 
                {
                    trend[i] = 0;
                    nexttrend = 1;
                    maxl = ll;
                }
            }
            //----
            if(trend[i] == 0.0) 
            {
                if(trend[i + 1] != 0.0) 
                {
                    up[i] = down[i + 1];
                    up[i + 1] = up[i];
                } 
                else 
                {
                    up[i] = MathMax (maxl, up[i + 1]);
                }
                down[i] = 0.0;
            } 
            else 
            {
                if(trend[i + 1] != 1.0) 
                {
                    down[i] = up[i + 1];
                    down[i + 1] = down[i];
                } 
                else 
                {
                    down[i] = MathMin (minh, down[i + 1]);
                }
                up[i] = 0.0;
            }
            //----  
            if(DrawArrow)
            {
                if(trend[i] == 0 && trend[i+1] == 1) atrhi[i] = up[i] - atr;
                if(trend[i] == 1 && trend[i+1] == 0) atrlo[i] = down[i] + atr;          
            }
            //----
        }
    }
    //----
    return (0);
}
