//+------------------------------------------------------------------+
//|                                              Trailling_All_Orders |
//|                                      Copyright 2014, Infoplus    |
//|                                    http://www.infoplus.ipsys.net |
//+------------------------------------------------------------------+
#property copyright "Infoplus"
#property link      "http://www.infoplus.ipsys.net"
#include <stdlib.mqh>

//-------    --------------------------------
extern string _Parameters_Trade="-----  ";
extern int    TrailingStop=20;      //   
extern int    TrailingStep=1;       //  
extern bool    Otl_Trall=false;       //  ?
extern int    Slippage=3;       //  
extern int    NoLoss=0;        //   ,  0 - 
extern int     ProfitClose=10;        //     
extern bool   UseSound      = True;         //   
extern string NameFileSound = "expert.wav"; //   
extern color  clOpenBuy     = LightBlue;    //   
extern color  clOpenSell    = LightCoral;   //   
extern color  clModifyBuy   = Aqua;         //   
extern color  clModifySell  = Tomato;       //   
extern color  clCloseBuy    = Blue;         //   
extern color  clCloseSell   = Red;          //   
//----    -------------------------------
int g_fontsize_544=10;
int g_color_548 = Gold;
int g_color_547 = Red;
int g_color_5=Gold;
double BStopLoss;
double SStopLoss;
double LottB,LottS;
int flagTrStartB=0;
int flagTrStartS=0;
int KolB;
int preKolB;
int KolS;
int preKolS;
double PrBuy=0;
double PrSell=0;
double HistoryZeroPrice,ZeroPrice,StopOutPrice;
double LotS,ProfitS;
double LotB,ProfitB;
double LotT,ProfitT;
double ProfitHistory;
double PartEquity;
color Color;
int  pos,orderremit,TotalOrders,Symb;
string text;
int File;
string FileName;
int CountDate;
double TikB,TikS;
int prevBar;
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
void init()
  {
   Comment("");
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
void start()
  {
   KolB=CheckLots(OP_BUY);
   if(preKolB!=KolB)
     {
      preKolB=KolB;
      BStopLoss=0; flagTrStartB=0;    StopOutPrice=0; ZeroPrice=0;
     }
   KolS=CheckLots(OP_SELL);
   if(preKolS!=KolS)
     {
      preKolS=KolS;
      SStopLoss=0; flagTrStartS=0;   StopOutPrice=0; ZeroPrice=0;
     }
   if(flagTrStartB==1) {TrailingPositions(1); }
   if(flagTrStartS==1) {TrailingPositions(2); }
   if(Otl_Trall) {TrailingPositions(0);}
   if(NoLoss!=0) {No_Loss();}
   Show();
   IndikatorLots();
  }
//+------------------------------------------------------------------+
//|   -                                           |
//+------------------------------------------------------------------+
int CheckLots(int mn)
  {
   int ko=0;
   for(int i=0; i<OrdersTotal(); i++)
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES))
        {
         if(OrderSymbol()==Symbol() && OrderType()==mn)
           {
            ko=ko+1;
           }
        }
     }
   return(ko);
  }
//+------------------------------------------------------------------+
//|                                                    |
//+------------------------------------------------------------------+
string ShowProfit()
  {
   double Proff=0; PrBuy=0; PrSell=0;

   for(int i=0; i<OrdersTotal(); i++)
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES))
        {
         if(OrderSymbol()==Symbol())
           {
            Proff=Proff+OrderProfit()+OrderSwap();
            if(OrderType()==OP_BUY)
              {
               PrBuy=PrBuy+OrderProfit()+OrderSwap();
              }
            if(OrderType()==OP_SELL)
              {
               PrSell=PrSell+OrderProfit()+OrderSwap();
              }
           }
        }
     }
//---------    500%    . 
/*  if(AccountMargin()!=0) 
     {
      if(AccountEquity()/AccountMargin()*100<500) 
        {
         if(Proff>=ProfitClose)
           {
            CloseAll(0);
           }
        }
     }*/

   if(PrBuy>=ProfitClose && BStopLoss==0)
     {
      flagTrStartB=1;
      BStopLoss=Bid;
     }
   if(PrSell>=ProfitClose && SStopLoss==0) 
     {
      flagTrStartS=1; SStopLoss=Ask;
     }
   return(Proff);
  }
//+------------------------------------------------------------------+
//|                                 |
//+------------------------------------------------------------------+
void CloseAll(int pp)
  {
   bool fc; int i;
   if(pp==0)
     {
      for(i=OrdersTotal()-1; i>=0; i--)
        {
         if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES))
           {
            if(OrderSymbol()==Symbol())
              {
               if(OrderType()==OP_BUY)
                 {
                  fc=False;
                  while(fc==False)
                    {
                     fc=OrderClose(OrderTicket(),OrderLots(),Bid,Slippage,clCloseBuy); EE();
                    }
                 }
               if(OrderType()==OP_SELL)
                 {
                  fc=False;
                  while(fc==False)
                    {
                     fc=OrderClose(OrderTicket(),OrderLots(),Ask,Slippage,clCloseSell); EE();
                    }
                 }
               if(OrderType()==OP_BUYSTOP || OrderType()==OP_SELLSTOP || OrderType()==OP_SELLLIMIT || OrderType()==OP_BUYLIMIT)
                 {
                  fc=OrderDelete(OrderTicket());
                 }
               if(fc && UseSound) PlaySound(NameFileSound);
              }
           }
        }
     }
  }
//+------------------------------------------------------------------+
//|                                                   |
//+------------------------------------------------------------------+
void EE()
  {
   int EError=GetLastError();                 //   :(
   switch(EError) //  
     {
      case 135:Alert(" .   ..");
      RefreshRates();                     //  

      case 136:Alert(" .   ..");
      while(RefreshRates()==false)        //   
         Sleep(1);                        //   
      // continue;                           //  . 
      case 146:Alert("  .  ..");
      Sleep(500);                         //  
      RefreshRates();                     //  

     }
  }
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//| -                             |
//+------------------------------------------------------------------+
void TrailingPositions(int mn)
  {
   int i;
   if(mn==1)
     {
      if(BStopLoss<Bid-(TrailingStop+TrailingStep-1)*Point) 
        {
         BStopLoss=BStopLoss+TrailingStep*Point;
         for(i=0; i<OrdersTotal(); i++)
           {
            if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES))
              {
               if(OrderSymbol()==Symbol() && OrderType()==OP_BUY)
                 {

                  if(OrderProfit()<=0)
                    {
                     ModifyStopLoss(0,BStopLoss,clModifyBuy);
                       } else {
                     ModifyStopLoss(BStopLoss,0,clModifyBuy);
                    }
                 }
              }
           }
        }
     }
   if(mn==2)
     {
      if(SStopLoss>Ask+(TrailingStop+TrailingStep-1)*Point)
        {
         SStopLoss=SStopLoss-TrailingStep*Point;

         for(i=0; i<OrdersTotal(); i++)
           {
            if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES))
              {
               if(OrderSymbol()==Symbol() && OrderType()==OP_SELL)
                 {
                  if(OrderProfit()<=0)
                    {
                     ModifyStopLoss(0,SStopLoss,clModifySell);
                       } else {
                     ModifyStopLoss(SStopLoss,0,clModifySell);
                    }
                 }
              }
           }
        }
     }
   if(mn==0) //  
     {
      for(i=0; i<OrdersTotal(); i++)
        {
         if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES))
           {
            if(OrderType()==OP_SELLSTOP)
              {
               if(Bid-OrderOpenPrice()>TrailingStop*Point)
                 {
                  if(OrderOpenPrice()<Bid-(TrailingStop+TrailingStep-1)*Point)
                    {
                     double newpr=Bid-TrailingStop*Point;
                     ModStopOrders(newpr,OP_SELLSTOP);
                    }
                 }
              }
            if(OrderType()==OP_BUYSTOP)
              {
               if(OrderOpenPrice()-Ask>TrailingStop*Point)
                 {
                  if(OrderOpenPrice()>Ask+(TrailingStop+TrailingStep-1)*Point)
                    {
                     double newprBS=Ask+TrailingStop*Point;
                     ModStopOrders(newprBS,OP_BUYSTOP);
                    }
                 }
              }
           }
        }
     }
  }
//+------------------------------------------------------------------+
//|   StopLoss                                          |
//| :                                                       |
//|   ldStopLoss -  StopLoss                                  |
//|   clModify   -                                    |
//+------------------------------------------------------------------+
void ModifyStopLoss(double ldStop,double ldTake,color clModify)
  {
   bool   fm=false;
   double ldOpen=OrderOpenPrice();
   while(fm==false) {fm=OrderModify(OrderTicket(),ldOpen,ldStop,ldTake,0,clModify);}
   if(fm && UseSound) 
     {
      PlaySound(NameFileSound);
      Print("   !");
     }
  }
//+------------------------------------------------------------------+
//|    .                                         |
//+------------------------------------------------------------------+
void ModStopOrders(double newprice,string OP)
  {
   bool   fm;
   fm=OrderModify(OrderTicket(),newprice,0,0,0,Red);
   if(fm && UseSound) {PlaySound(NameFileSound); }
  }
//+------------------------------------------------------------------+
//|                                                         |
//+------------------------------------------------------------------+
void No_Loss()
  {
   double OOP,OSL;
   int tip;
   bool error=true;
   for(int i=0; i<OrdersTotal(); i++)
     {
      if(OrderSelect(i,SELECT_BY_POS))
        {
         tip=OrderType();
         if(tip<2 && OrderSymbol()==Symbol())
           {
            OOP = NormalizeDouble(OrderOpenPrice(),Digits);
            OSL = NormalizeDouble(OrderStopLoss(),Digits);

            //-----      
            if(BStopLoss !=0) {OOP=BStopLoss;}
            if(SStopLoss !=0) {OOP=SStopLoss;}

            if(tip==0)
              {
               if((Bid-OOP)/Point>=NoLoss && OOP>OSL)
                  error=OrderModify(OrderTicket(),OOP,OOP+2*Point,OrderTakeProfit(),0,White);
              }
            if(tip==1)
              {
               if((OOP-Ask)/Point>=NoLoss && (OOP<OSL || OSL==0))
                  error=OrderModify(OrderTicket(),OOP,OOP-2*Point,OrderTakeProfit(),0,White);
              }
            if(!error) Alert("Error No_Loss ",GetLastError(),"   ",Symbol());
           }
        }
     }
  }
//+------------------------------------------------------------------+
//|                                                      |
//+------------------------------------------------------------------+
void Show()
  {
   RefreshRates();
   string  name_8="5";
   if(ObjectFind(name_8)==-1)
     {
      ObjectCreate(name_8,OBJ_LABEL,0,0,0);
      ObjectSet(name_8,OBJPROP_CORNER,1);
      ObjectSet(name_8,OBJPROP_XDISTANCE,20);
      ObjectSet(name_8,OBJPROP_YDISTANCE,36);
     }
   ObjectSetText(name_8,": "+DoubleToStr(AccountBalance(),2),g_fontsize_544,"Courier New",g_color_548);
   name_8="6";
   if(ObjectFind(name_8)==-1)
     {
      ObjectCreate(name_8,OBJ_LABEL,0,0,0);
      ObjectSet(name_8,OBJPROP_CORNER,1);
      ObjectSet(name_8,OBJPROP_XDISTANCE,20);
      ObjectSet(name_8,OBJPROP_YDISTANCE,56);
     }
   ObjectSetText(name_8,": "+DoubleToStr(AccountFreeMargin(),2),g_fontsize_544,"Courier New",g_color_548);
   name_8="7";
   if(ObjectFind(name_8)==-1)
     {
      ObjectCreate(name_8,OBJ_LABEL,0,0,0);
      ObjectSet(name_8,OBJPROP_CORNER,1);
      ObjectSet(name_8,OBJPROP_XDISTANCE,20);
      ObjectSet(name_8,OBJPROP_YDISTANCE,76);
     }
   if(AccountMargin()==0)
     {
      StopOutPrice=0; ZeroPrice=0;
      ObjectSetText(name_8,":   ",g_fontsize_544,"Courier New",g_color_548);
     }
   else
     {
      if(AccountEquity()/AccountMargin()*100<2000) {g_color_5=Red;} else {g_color_5=Gold;}
      ObjectSetText(name_8,": "+DoubleToStr(AccountEquity()/AccountMargin()*100,0),g_fontsize_544,"Courier New",g_color_5);
     }
   name_8="8";
   if(ObjectFind(name_8)==-1)
     {
      ObjectCreate(name_8,OBJ_LABEL,0,0,0);
      ObjectSet(name_8,OBJPROP_CORNER,1);
      ObjectSet(name_8,OBJPROP_XDISTANCE,20);
      ObjectSet(name_8,OBJPROP_YDISTANCE,96);
     }
   ObjectSetText(name_8,": "+DoubleToStr(ShowProfit(),2),g_fontsize_544,"Courier New",g_color_548);
   name_8="13";
   if(ObjectFind(name_8)==-1)
     {
      ObjectCreate(name_8,OBJ_LABEL,0,0,0);
      ObjectSet(name_8,OBJPROP_CORNER,1);
      ObjectSet(name_8,OBJPROP_XDISTANCE,20);
      ObjectSet(name_8,OBJPROP_YDISTANCE,116);
     }
   ObjectSetText(name_8,"STOPOUT: "+DoubleToStr(StopOutPrice,4),g_fontsize_544,"Courier New",g_color_547);
   name_8="14";
   if(ObjectFind(name_8)==-1)
     {
      ObjectCreate(name_8,OBJ_LABEL,0,0,0);
      ObjectSet(name_8,OBJPROP_CORNER,1);
      ObjectSet(name_8,OBJPROP_XDISTANCE,20);
      ObjectSet(name_8,OBJPROP_YDISTANCE,136);
     }
   ObjectSetText(name_8,"ZEROPRICE: "+DoubleToStr(ZeroPrice,4),g_fontsize_544,"Courier New",Gold);
   name_8="15";
   if(ObjectFind(name_8)==-1)
     {
      ObjectCreate(name_8,OBJ_LABEL,0,0,0);
      ObjectSet(name_8,OBJPROP_CORNER,1);
      ObjectSet(name_8,OBJPROP_XDISTANCE,20);
      ObjectSet(name_8,OBJPROP_YDISTANCE,156);
     }
   ObjectSetText(name_8," BUY: "+KolB+" Lots: "+DoubleToStr(LotB,2),g_fontsize_544,"Courier New",g_color_548);
   name_8="16";
   if(ObjectFind(name_8)==-1)
     {
      ObjectCreate(name_8,OBJ_LABEL,0,0,0);
      ObjectSet(name_8,OBJPROP_CORNER,1);
      ObjectSet(name_8,OBJPROP_XDISTANCE,20);
      ObjectSet(name_8,OBJPROP_YDISTANCE,176);
     }
   ObjectSetText(name_8," SELL: "+KolS+" Lots: "+DoubleToStr(LotS,2),g_fontsize_544,"Courier New",g_color_548);
   name_8="17";
   if(ObjectFind(name_8)==-1)
     {
      ObjectCreate(name_8,OBJ_LABEL,0,0,0);
      ObjectSet(name_8,OBJPROP_CORNER,1);
      ObjectSet(name_8,OBJPROP_XDISTANCE,20);
      ObjectSet(name_8,OBJPROP_YDISTANCE,196);
     }
//  ObjectSetText(name_8,"BUY Profit: "+DoubleToStr(ProfitB,2),g_fontsize_544,"Courier New",g_color_548);
   ObjectSetText(name_8,"BUYStopLOSS: "+DoubleToStr(BStopLoss,4),g_fontsize_544,"Courier New",g_color_548);
   name_8="18";
   if(ObjectFind(name_8)==-1)
     {
      ObjectCreate(name_8,OBJ_LABEL,0,0,0);
      ObjectSet(name_8,OBJPROP_CORNER,1);
      ObjectSet(name_8,OBJPROP_XDISTANCE,20);
      ObjectSet(name_8,OBJPROP_YDISTANCE,216);
     }
//   ObjectSetText(name_8,"SELL Profit: "+DoubleToStr(ProfitS,2),g_fontsize_544,"Courier New",g_color_548);
   ObjectSetText(name_8,"SELLStopLOSS: "+DoubleToStr(SStopLoss,4),g_fontsize_544,"Courier New",g_color_548);
   name_8="19";
   if(ObjectFind(name_8)==-1)
     {
      ObjectCreate(name_8,OBJ_LABEL,0,0,0);
      ObjectSet(name_8,OBJPROP_CORNER,1);
      ObjectSet(name_8,OBJPROP_XDISTANCE,20);
      ObjectSet(name_8,OBJPROP_YDISTANCE,236);
     }
   ObjectSetText(name_8,"ProfitClose: "+DoubleToStr(ProfitClose,2),g_fontsize_544,"Courier New",g_color_548);
  }
//+------------------------------------------------------------------+
//|                                                   |
//+------------------------------------------------------------------+
int IndikatorLots()
  {
   if(AccountBalance()==0)return(0);
   double TickVal=MarketInfo(Symbol(),MODE_TICKVALUE);
//----   
   if(TotalOrders!=OrdersTotal() && AccountBalance()!=0)
     {
      TotalOrders=OrdersTotal();
      double Lot,Lot_1;
      for(pos=OrdersTotal()-1;pos>=0;pos--)
        {
         if(OrderSelect(pos,SELECT_BY_POS,MODE_TRADES)==true)
           {
            if(OrderType()<=OP_SELL && OrderSymbol()==Symbol())
              {
               if(OrderType()==OP_BUY){Lot=OrderLots();}
               if(OrderType()==OP_SELL){Lot=-OrderLots();}
               Lot_1=NormalizeDouble(Lot_1+Lot,2);//}
              }
           }
         else Print(" ",GetLastError());
        }
     }
   PartEquity=(AccountEquity()-AccountStopoutLevel()/100*AccountMargin());// 

//----     
   LotS=0;
   ProfitS=0;
   LotB=0;
   ProfitB=0;
   ProfitT=0;

   for(pos=OrdersTotal()-1; pos>=0; pos--)
     {
      if(OrderSelect(pos,SELECT_BY_POS,MODE_TRADES)==true)
        {
         if(OrderSymbol()==Symbol())
           {
            //----
            if(OrderType()==OP_BUY)
              {
               LotB+=OrderLots();
               ProfitB+=OrderProfit()+OrderSwap();
              }
            //----
            if(OrderType()==OP_SELL)
              {
               LotS+=OrderLots();
               ProfitS+=OrderProfit()+OrderSwap();
              }
            //----
            ProfitT+=OrderProfit()+OrderSwap();
            //----
           }
        }
      else Print("      (",GetLastError(),")");
     }
//----      
   if(AccountBalance()!=0)
      //----
     {
      int order;
      for(pos=OrdersTotal()-1;pos>=0;pos--)//   
        {
         if(OrderSelect(pos,SELECT_BY_POS,MODE_TRADES)==true)
           {
            if(OrderSymbol()==Symbol() && OrderType()<=OP_SELL)
              {
               order++;
              }
           }
         else Print("      (",GetLastError(),")");
        }
     }
//----
   text=StringConcatenate("Total History profit (",TimeToStr(CountDate,TIME_DATE|TIME_MINUTES),")=");
//----  
   ProfitHistory=0;
   for(pos=OrdersHistoryTotal()-1;pos>=0;pos--)//   
     {
      if(OrderSelect(pos,SELECT_BY_POS,MODE_HISTORY)==true)
        {
         if(OrderSymbol()==Symbol() && OrderOpenTime()>=CountDate)
           {
            ProfitHistory+=OrderProfit()+OrderSwap();
           }
        }
      else Print("      (",GetLastError(),")");
     }
   ProfitHistory=ProfitHistory+ProfitT;

//----    StopOut   
   LotT=LotB-LotS;
   if(LotT!=0)
     {
      if(LotT>0)//Buy  e
        {
         HistoryZeroPrice=NormalizeDouble(Bid-(ProfitHistory/LotT/TickVal*Point),Digits);
         ZeroPrice=NormalizeDouble(Bid-(ProfitT/LotT/TickVal*Point),Digits);
         StopOutPrice=NormalizeDouble(Bid-(PartEquity/LotT/TickVal*Point),Digits);
        }
      if(LotT<0)//Sell  e
        {
         HistoryZeroPrice=NormalizeDouble(Ask-(ProfitHistory/LotT/TickVal*Point),Digits);
         ZeroPrice=NormalizeDouble(Ask-(ProfitT/LotT/TickVal*Point),Digits);
         StopOutPrice=NormalizeDouble(Ask-(PartEquity/LotT/TickVal*Point),Digits);
        }
      //----     
      if(ObjectFind("Line of the zero price")!=0)// Line zero   
        {
         ObjectCreate("Line of the zero price",OBJ_TREND,0,Time[5],ZeroPrice,Time[0]+Period()*60*20,ZeroPrice,0,0);
         ObjectSetText("Line of the zero price",DoubleToStr(ZeroPrice,Digits));
         ObjectSet("Line of the zero price",OBJPROP_RAY,false);
         ObjectSet("Line of the zero price",OBJPROP_STYLE,STYLE_SOLID);
         ObjectSet("Line of the zero price",OBJPROP_WIDTH,1);
         ObjectSet("Line of the zero price",OBJPROP_COLOR,Gold);
        }
      else if(ObjectFind("Line of the zero price")==0)// Line zero   
        {
         ObjectSetText("Line of the zero price",DoubleToStr(ZeroPrice,Digits));
         ObjectSet("Line of the zero price",OBJPROP_TIME1,Time[5]);
         ObjectSet("Line of the zero price",OBJPROP_PRICE1,ZeroPrice);
         ObjectSet("Line of the zero price",OBJPROP_TIME2,Time[0]+Period()*60*20);
         ObjectSet("Line of the zero price",OBJPROP_PRICE2,ZeroPrice);
        }
      if(ObjectFind("Zero price")!=0)// Arrow zero   
        {
         ObjectCreate("Zero price",OBJ_ARROW,0,Time[5],ZeroPrice,0,0,0,0);
         ObjectSet("Zero price",OBJPROP_ARROWCODE,5);
         ObjectSet("Zero price",OBJPROP_WIDTH,2);
         ObjectSet("Zero price",OBJPROP_COLOR,Gold);
        }
      else if(ObjectFind("Zero price")==0)// Arrow zero    
        {
         ObjectSet("Zero price",OBJPROP_PRICE1,ZeroPrice);
         ObjectSet("Zero price",OBJPROP_TIME1,Time[5]);
        }
      //----  StopOut   
      if(ObjectFind("Line of the StopOut price")!=0)
        {
         ObjectCreate("Line of the StopOut price",OBJ_TREND,0,Time[5],StopOutPrice,Time[0]+Period()*60*20,StopOutPrice,0,0);
         ObjectSetText("Line of the StopOut price",DoubleToStr(StopOutPrice,Digits));
         ObjectSet("Line of the StopOut price",OBJPROP_RAY,false);
         ObjectSet("Line of the StopOut price",OBJPROP_STYLE,STYLE_SOLID);
         ObjectSet("Line of the StopOut price",OBJPROP_WIDTH,2);
         ObjectSet("Line of the StopOut price",OBJPROP_COLOR,Brown);
        }
      else if(ObjectFind("Line of the StopOut price")==0)
        {
         ObjectSetText("Line of the StopOut price",DoubleToStr(StopOutPrice,Digits));
         ObjectSet("Line of the StopOut price",OBJPROP_TIME1,Time[5]);
         ObjectSet("Line of the StopOut price",OBJPROP_PRICE1,StopOutPrice);
         ObjectSet("Line of the StopOut price",OBJPROP_TIME2,Time[0]+Period()*60*20);
         ObjectSet("Line of the StopOut price",OBJPROP_PRICE2,StopOutPrice);
        }
      if(ObjectFind("StopOut price")!=0)
        {
         ObjectCreate("StopOut price",OBJ_ARROW,0,Time[5],StopOutPrice,0,0,0,0);
         ObjectSet("StopOut price",OBJPROP_ARROWCODE,5);
         ObjectSet("StopOut price",OBJPROP_WIDTH,3);
         ObjectSet("StopOut price",OBJPROP_COLOR,Brown);
        }
      else if(ObjectFind("StopOut price")==0)
        {
         ObjectSet("StopOut price",OBJPROP_PRICE1,StopOutPrice);
         ObjectSet("StopOut price",OBJPROP_TIME1,Time[5]);
        }
      //----
     }
   else if(LotT==0)
     {
      if(ObjectFind("Line of the history zero price")==0)ObjectDelete("Line of the history zero price");
      if(ObjectFind("History zero price")==0)ObjectDelete("History zero price");
      if(ObjectFind("Line of the zero price")==0)ObjectDelete("Line of the zero price");
      if(ObjectFind("Zero price")==0)ObjectDelete("Zero price");
      if(ObjectFind("Line of the StopOut price")==0)ObjectDelete("Line of the StopOut price");
      if(ObjectFind("StopOut price")==0)ObjectDelete("StopOut price");
     }
//----  BUY   
   if(LotB>0)
     {
      double BUYZeroPrice;
      BUYZeroPrice=NormalizeDouble(Bid-(ProfitB/LotB/TickVal*Point),Digits);
      if(ObjectFind("Line of the BUY zero price")!=0)
        {
         ObjectCreate("Line of the BUY zero price",OBJ_TREND,0,Time[5],BUYZeroPrice,Time[0]+Period()*60*20,BUYZeroPrice,0,0);
         ObjectSetText("Line of the BUY zero price",DoubleToStr(BUYZeroPrice,Digits));
         ObjectSet("Line of the BUY zero price",OBJPROP_RAY,false);
         ObjectSet("Line of the BUY zero price",OBJPROP_STYLE,STYLE_SOLID);
         ObjectSet("Line of the BUY zero price",OBJPROP_WIDTH,1);
         ObjectSet("Line of the BUY zero price",OBJPROP_COLOR,Chartreuse);
        }
      else if(ObjectFind("Line of the BUY zero price")==0)
        {
         ObjectSetText("Line of the BUY zero price",DoubleToStr(BUYZeroPrice,Digits));
         ObjectSet("Line of the BUY zero price",OBJPROP_TIME1,Time[5]);
         ObjectSet("Line of the BUY zero price",OBJPROP_PRICE1,BUYZeroPrice);
         ObjectSet("Line of the BUY zero price",OBJPROP_TIME2,Time[0]+Period()*60*20);
         ObjectSet("Line of the BUY zero price",OBJPROP_PRICE2,BUYZeroPrice);
        }
      if(ObjectFind("BUY Zero price")!=0)
        {
         ObjectCreate("BUY Zero price",OBJ_ARROW,0,Time[5],BUYZeroPrice,0,0,0,0);
         ObjectSet("BUY Zero price",OBJPROP_ARROWCODE,5);
         ObjectSet("BUY Zero price",OBJPROP_WIDTH,2);
         ObjectSet("BUY Zero price",OBJPROP_COLOR,Chartreuse);
        }
      else if(ObjectFind("BUY Zero price")==0)
        {
         ObjectSet("BUY Zero price",OBJPROP_PRICE1,BUYZeroPrice);
         ObjectSet("BUY Zero price",OBJPROP_TIME1,Time[5]);
        }
     }
   else if(LotB==0)
     {
      if(ObjectFind("Line of the BUY zero price")==0)ObjectDelete("Line of the BUY zero price");
      if(ObjectFind("BUY Zero price")==0)ObjectDelete("BUY Zero price");
     }
//----  SELL   
   if(LotS>0)
     {
      double SELLZeroPrice;
      SELLZeroPrice=NormalizeDouble(Ask+(ProfitS/LotS/TickVal*Point),Digits);
      if(ObjectFind("Line of the SELL zero price")!=0)
        {
         ObjectCreate("Line of the SELL zero price",OBJ_TREND,0,Time[5],SELLZeroPrice,Time[0]+Period()*60*20,SELLZeroPrice,0,0);
         ObjectSetText("Line of the SELL zero price",DoubleToStr(SELLZeroPrice,Digits));
         ObjectSet("Line of the SELL zero price",OBJPROP_RAY,false);
         ObjectSet("Line of the SELL zero price",OBJPROP_STYLE,STYLE_SOLID);
         ObjectSet("Line of the SELL zero price",OBJPROP_WIDTH,1);
         ObjectSet("Line of the SELL zero price",OBJPROP_COLOR,DeepPink);
        }
      else if(ObjectFind("Line of the SELL zero price")==0)
        {
         ObjectSetText("Line of the SELL zero price",DoubleToStr(SELLZeroPrice,Digits));
         ObjectSet("Line of the SELL zero price",OBJPROP_TIME1,Time[5]);
         ObjectSet("Line of the SELL zero price",OBJPROP_PRICE1,SELLZeroPrice);
         ObjectSet("Line of the SELL zero price",OBJPROP_TIME2,Time[0]+Period()*60*20);
         ObjectSet("Line of the SELL zero price",OBJPROP_PRICE2,SELLZeroPrice);
        }
      if(ObjectFind("SELL Zero price")!=0)
        {
         ObjectCreate("SELL Zero price",OBJ_ARROW,0,Time[5],SELLZeroPrice,0,0,0,0);
         ObjectSet("SELL Zero price",OBJPROP_ARROWCODE,5);
         ObjectSet("SELL Zero price",OBJPROP_WIDTH,2);
         ObjectSet("SELL Zero price",OBJPROP_COLOR,DeepPink);
        }
      else if(ObjectFind("SELL Zero price")==0)
        {
         ObjectSet("SELL Zero price",OBJPROP_PRICE1,SELLZeroPrice);
         ObjectSet("SELL Zero price",OBJPROP_TIME1,Time[5]);
        }
     }
   else if(LotS==0)
     {
      if(ObjectFind("Line of the SELL zero price")==0)ObjectDelete("Line of the SELL zero price");
      if(ObjectFind("SELL Zero price")==0)ObjectDelete("SELL Zero price");
     }

//----   
   ProfitB=NormalizeDouble(ProfitB,0);
   ProfitS=NormalizeDouble(ProfitS,0);
   ProfitHistory=NormalizeDouble(ProfitHistory,0);
//----
   return(0);
  }
//+------------------------------------------------------------------+
