//+------------------------------------------------------------------+
//|                                                        InOut.mq4 |
//|                                Copyright 2014, cmillion@narod.ru |
//|                                               http://cmillion.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright 2014, cmillion@narod.ru"
#property link      "http://cmillion.ru"
#property version   "1.00"
#property strict

#property description "   sell     TimeStart  TimeEnd     "
#property description "       "
#property description "      = Loss,      "
#property description "   ProfitClose   ."

extern double  ProfitClose     = 0.5;  //    
extern int     Loss            = 10;
extern double  K_Lot           = 2.0;
extern int     slippage        = 3,     //       (    ).
               magic           = 0;     //  .      .
extern double  Lot             = 0.1;
extern int     TimeStart_1     = 10,
               TimeEnd_1       = 12,
               TimeStart_2     = 15,
               TimeEnd_2       = 18;

//+------------------------------------------------------------------+
int OnInit()
{
   return(INIT_SUCCEEDED);
}
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{

}
//+------------------------------------------------------------------+
void OnTick()
{
   int TekHour  = Hour();
   bool Trade=false;
   if ((TekHour >= TimeStart_1 && TekHour < TimeEnd_1) || (TekHour >= TimeStart_2 && TekHour < TimeEnd_2)) Trade=true; 
   //---
   double OOP=0,OL=0,Profit=0,MaxLot=0;
   int OT,b=0,s=0,Order=0;
   for (int i=0; i<OrdersTotal(); i++)
   {    
      if (OrderSelect(i,SELECT_BY_POS,MODE_TRADES))
      { 
         if (OrderSymbol()==Symbol() && OrderMagicNumber()==magic)
         { 
            OT = OrderType(); 
            if (OT<2)
            {
               OOP = NormalizeDouble(OrderOpenPrice(),Digits);
               OL = OrderLots();
               Profit+=OrderProfit()+OrderSwap()+OrderCommission();
               if (MaxLot<OL) MaxLot=OL;
               if (OT==OP_BUY)             
               {  
                  Order= 1;
               }                                         
               if (OT==OP_SELL)        
               {
                  Order=-1;
               } 
            }
         }
      }
   } 
   //---
   if (Profit>=ProfitClose && ProfitClose!=0)
   {
      Alert(", Profit = "+DoubleToStr(Profit,2));
      CloseAll();
   }
   //---
   double LOT=NormalizeDouble(MaxLot*K_Lot,2);
   if (Order==1 && (OOP-Bid)/Point>=Loss)
   {
      if (AccountFreeMarginCheck(Symbol(),OP_SELL, LOT) <= 0) Comment("    SELL ",DoubleToStr(LOT,2)," ");
      else if(OrderSend(Symbol(),OP_SELL,LOT,NormalizeDouble(Bid,Digits),slippage,0,0,"",magic,0,Red)==-1) 
         Print("OrderSend Sell Error ",GetLastError()," Lot ",DoubleToStr(LOT,2));
   }
   
   if (Order==-1 && (Ask-OOP)/Point>=Loss) 
   {
      if (AccountFreeMarginCheck(Symbol(),OP_BUY, LOT) <= 0) Comment("    BUY ",DoubleToStr(LOT,2)," ");
      else if(OrderSend(Symbol(),OP_BUY,LOT,NormalizeDouble(Ask,Digits),slippage,0,0,"",magic,0,Blue)==-1) 
         Print("OrderSend Buy Error ",GetLastError()," Lot ",DoubleToStr(LOT,2));
   }
   
   if (Trade && Order==0)
   {
      if(OrderSend(Symbol(),OP_SELL,Lot,NormalizeDouble(Bid,Digits),slippage,0,0,"",magic,0,Red)==-1) 
         Print("Order Send 1 Sell Error ",GetLastError());
   }
}
//+------------------------------------------------------------------+
bool CloseAll()
{
   bool error=true;
   int j,err,nn,OT,OMN;
   while(true)
   {
      for (j = OrdersTotal()-1; j >= 0; j--)
      {
         if (OrderSelect(j, SELECT_BY_POS))
         {
            OMN = OrderMagicNumber();
            if (OrderSymbol() == Symbol() && OMN == magic)
            {
               OT = OrderType();
               if (OT==OP_BUY) 
               {
                  error=OrderClose(OrderTicket(),OrderLots(),NormalizeDouble(Bid,Digits),slippage,Blue);
                  if (error) Comment("  N ",OrderTicket(),"   ",OrderProfit(),
                                     "     ",TimeToStr(TimeCurrent(),TIME_SECONDS));
               }
               if (OT==OP_SELL) 
               {
                  error=OrderClose(OrderTicket(),OrderLots(),NormalizeDouble(Ask,Digits),slippage,Red);
                  if (error) Comment("  N ",OrderTicket(),"   ",OrderProfit(),
                                     "     ",TimeToStr(TimeCurrent(),TIME_SECONDS));
               }
               if (!error) 
               {
                  err = GetLastError();
                  if (err<2) continue;
                  if (err==129) 
                  {  Comment("  ",TimeToStr(TimeCurrent(),TIME_SECONDS));
                     RefreshRates();
                     continue;
                  }
                  if (err==146) 
                  {
                     if (IsTradeContextBusy()) Sleep(2000);
                     continue;
                  }
                  Comment(" ",err,"   N ",OrderTicket(),
                          "     ",TimeToStr(TimeCurrent(),TIME_SECONDS));
               }
            }
         }
      }
      int n=0;
      for (j = 0; j < OrdersTotal(); j++)
      {
         if (OrderSelect(j, SELECT_BY_POS))
         {
            OMN = OrderMagicNumber();
            if (OrderSymbol() == Symbol() && OMN == magic)
            {
               OT = OrderType();
               if (OT==OP_BUY || OT==OP_SELL) n++;
            }
         }  
      }
      if (n==0) break;
      nn++;
      if (nn>10) {Alert(Symbol(),"     ,   ",n);return(0);}
      Sleep(1000);
      RefreshRates();
   }
   return(1);
}
//--------------------------------------------------------------------