//+------------------------------------------------------------------+
//|                                                      SizeBar.mq5 | 
//|                                            Copyright  2011, zfs | 
//|                                                   vasbsm@mail.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2011, zfs"
#property link "vasbsm@mail.ru"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window 
//---   
#property indicator_buffers 1 
//---     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---     
#property indicator_type1   DRAW_HISTOGRAM
//---       DodgerBlue 
#property indicator_color1 clrDodgerBlue
//---   -  
#property indicator_style1  STYLE_SOLID
//---     3
#property indicator_width1  3
//---   
#property indicator_label1  "SizeBar"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int Shift=0; //      
//+-----------------------------------+
//---   ,  
//---       
double IndBuffer[];
//---      
int min_rates_total;
//+------------------------------------------------------------------+   
//| SizeBar indicator initialization function                        | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---     
   min_rates_total=2;
//---      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"SizeBar");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
  }
//+------------------------------------------------------------------+ 
//| SizeBar iteration function                                       | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(0);
//---       
   double max,x,y;
//---        
   int first,bar;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total-1; //      
   else first=prev_calculated-1; //      
//---    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      x=((high[bar]-close[bar-1])/_Point)-spread[bar];
      y=((close[bar-1]-low[bar])/_Point)-spread[bar];
      if(x>y) max=x;
      else max=y;
      max=MathMax(max,0);
      IndBuffer[bar]=max;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
