//+------------------------------------------------------------------+
//|                                                       ExMass.mq4 |
//|                           Copyright  2006, Alex Sidd (Executer) |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Alex Sidd (Executer)"
#property link      "mailto:work_st@mail.ru"
//----
#property indicator_separate_window
#property indicator_minimum 0
#property indicator_maximum 100
#property indicator_buffers 1
#property  indicator_color1  Black
//---- input parameters
extern int ExPeriod = 8;
//---- buffers
double MassBuffer[];
//+------------------------------------------------------------------+
//| initialization function                                          |
//+------------------------------------------------------------------+
int init()
  {
   string short_name;
   IndicatorBuffers(1);
   SetIndexStyle(0, DRAW_LINE);
   SetIndexBuffer(0, MassBuffer);
   SetIndexDrawBegin(0, ExPeriod);
   short_name = "ExMass";
   IndicatorShortName(short_name);
   SetIndexLabel(0, short_name);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Exexuter Mass Indicator                                          |
//+------------------------------------------------------------------+
int start()
  {
   int    i, counted_bars = IndicatorCounted();
   double negative,positive;
//----
   if(Bars <= ExPeriod) 
       return(0);
   if(counted_bars < 1)
       for(i = 1; i <= ExPeriod; i++) 
           MassBuffer[Bars-i] = 0.0;
//----
   i = Bars - ExPeriod - 1;
   if(counted_bars >= ExPeriod) 
       i = Bars - counted_bars - 1;
   while(i >= 0)
     {
       negative = 1000;
       positive = 0;
       if(i < Bars - ExPeriod - 1)
         {
           int k = i + ExPeriod;
           while(k >= i)
             {
               if(High[k] > positive) 
                   positive = High[k];
               if(Low[k] < negative) 
                   negative = Low[k];
               k--;
             }
         }
       MassBuffer[i] = (positive - negative)*2500;
       i--;
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+